/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorBasicTree;
import biomesoplenty.common.world.generator.tree.GeneratorBigTree;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;

public class BiomeGenSnowyForest
extends BOPOverworldBiome {
    public BiomeGenSnowyForest() {
        super("snowy_forest", new BOPBiome.PropsBuilder("Snowy Forest").withGuiColour(11261628).withSnowEnabled().withTemperature(Float.valueOf(-0.25f)).withRainfall(Float.valueOf(0.5f)));
        this.terrainSettings.avgHeight(66.0).heightVariation(6.0, 21.0);
        this.field_76752_A = BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.SILTY));
        this.field_76753_B = BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)((Object)BlockBOPDirt.BOPDirtType.SILTY));
        this.canGenerateVillages = false;
        this.addWeight(BOPClimates.TUNDRA, 7);
        GeneratorWeighted treeGenerator = new GeneratorWeighted(3.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("oak", 3, ((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().leaves(BOPTrees.DEAD)).create());
        treeGenerator.add("dying_tree", 1, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().minHeight(5)).maxHeight(12)).foliageHeight(2).leaves(BOPTrees.DEAD)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(1.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("tallgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        this.addGenerator("shrubs", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BOPPlants.SHRUB)).create());
        this.addGenerator("leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).placeOn(BlockQueries.fertile)).with(BOPPlants.LEAFPILE)).create());
        this.addGenerator("dead_leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.4f)).placeOn(BlockQueries.fertile)).with(BOPPlants.DEADLEAFPILE)).create());
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(0.3f);
        this.addGenerator("flowers", GeneratorStage.FLOWERS, flowerGenerator);
        flowerGenerator.add("violets", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.VIOLET)).create());
        this.addGenerator("tanzanite", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.TANZANITE)).create());
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GEMS)) {
            this.removeGenerator("tanzanite");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.SOILS)) {
            this.field_76752_A = Blocks.field_150349_c.func_176223_P();
            this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FOLIAGE)) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("flowers");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.TREES)) {
            this.removeGenerator("trees");
            GeneratorWeighted treeGenerator = new GeneratorWeighted(3.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("oak", 3, ((GeneratorBasicTree.Builder)new GeneratorBasicTree.Builder().leaves(BlockPlanks.EnumType.OAK)).create());
            treeGenerator.add("dying_tree", 1, ((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)((GeneratorBigTree.Builder)new GeneratorBigTree.Builder().minHeight(5)).maxHeight(12)).foliageHeight(2).leaves(BlockPlanks.EnumType.OAK)).create());
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GRASSES)) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
    }

    public int func_180627_b(BlockPos pos) {
        return 12362085;
    }

    public int func_180625_c(BlockPos pos) {
        return 12362085;
    }
}

