/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.world.generator.GeneratorColumns;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWaterside;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorPalmTree;
import biomesoplenty.common.world.generator.tree.GeneratorTwigletTree;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;

public class BiomeGenTropicalIsland
extends BOPOverworldBiome {
    public BiomeGenTropicalIsland() {
        super("tropical_island", new BOPBiome.PropsBuilder("Tropical Island").withTemperature(Float.valueOf(1.0f)).withRainfall(Float.valueOf(1.0f)).withGuiColour(2211330));
        this.terrainSettings.avgHeight(64.0).heightVariation(5.0, 40.0).octaves(0.0, 1.0, 2.0, 2.0, 1.0, 0.0).sidewaysNoise(0.2);
        if (BOPBiomes.white_beach.isPresent()) {
            this.beachBiomeLocation = ((BOPOverworldBiome)BOPBiomes.white_beach.get()).getResourceLocation();
        }
        this.canSpawnInBiome = true;
        this.canGenerateVillages = false;
        this.canGenerateRivers = false;
        this.skyColor = 507391;
        this.fogColor = 11925759;
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityParrot.class, 40, 1, 2));
        this.clearWeights();
        this.addGenerator("sand", GeneratorStage.SAND_PASS2, ((GeneratorWaterside.Builder)((GeneratorWaterside.Builder)new GeneratorWaterside.Builder().amountPerChunk(10.0f)).maxRadius(7).with(BOPBlocks.white_sand.func_176223_P())).create());
        GeneratorWeighted treeGenerator = new GeneratorWeighted(25.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("palm", 4, ((GeneratorPalmTree.Builder)((GeneratorPalmTree.Builder)new GeneratorPalmTree.Builder().log(BOPWoods.PALM)).leaves(BlockBOPLeaves.paging.getVariantState(BOPTrees.PALM).func_177226_a((IProperty)BlockOldLeaf.field_176237_a, (Comparable)Boolean.valueOf(false)))).create());
        treeGenerator.add("jungle_twiglet", 2, ((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)new GeneratorTwigletTree.Builder().minHeight(2)).maxHeight(2)).log(BlockPlanks.EnumType.JUNGLE)).leaves(BlockPlanks.EnumType.JUNGLE)).trunkFruit(Blocks.field_150375_by.func_176223_P())).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(3.5f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("dampgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.DAMPGRASS)).create());
        grassGenerator.add("tallgrass", 2, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        this.addGenerator("leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).placeOn(BlockQueries.fertile)).with(BOPPlants.LEAFPILE)).create());
        this.addGenerator("sprouts", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BOPPlants.SPROUT)).create());
        this.addGenerator("shrubs", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).with(BOPPlants.SHRUB)).create());
        this.addGenerator("melons", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.015625f)).placeOn(this.field_76752_A)).with(Blocks.field_150440_ba.func_176223_P())).create());
        this.addGenerator("bamboo", GeneratorStage.FLOWERS, ((GeneratorColumns.Builder)((GeneratorColumns.Builder)((GeneratorColumns.Builder)new GeneratorColumns.Builder().amountPerChunk(0.2f)).generationAttempts(24).placeOn(this.field_76752_A)).with(BOPBlocks.bamboo.func_176223_P())).minHeight(1).maxHeight(3).create());
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(2.0f);
        this.addGenerator("flowers", GeneratorStage.FLOWERS, flowerGenerator);
        flowerGenerator.add("hibiscus", 6, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.PINK_HIBISCUS)).create());
        flowerGenerator.add("blue_hydrangeas", 2, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.BLUE_HYDRANGEA)).create());
        flowerGenerator.add("white_anemones", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.WHITE_ANEMONE)).create());
        flowerGenerator.add("dandelion", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.DANDELION)).create());
        flowerGenerator.add("poppy", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.POPPY)).create());
        this.addGenerator("topaz", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.TOPAZ)).create());
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GEMS)) {
            this.removeGenerator("topaz");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FOLIAGE)) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.TREES)) {
            this.removeGenerator("trees");
            GeneratorWeighted treeGenerator = new GeneratorWeighted(25.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("palm", 4, ((GeneratorPalmTree.Builder)((GeneratorPalmTree.Builder)new GeneratorPalmTree.Builder().log(BlockPlanks.EnumType.JUNGLE)).leaves(Blocks.field_150362_t.func_176203_a(BlockPlanks.EnumType.JUNGLE.func_176839_a()).func_177226_a((IProperty)BlockOldLeaf.field_176237_a, (Comparable)Boolean.valueOf(false)))).create());
            treeGenerator.add("jungle_twiglet", 2, ((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)new GeneratorTwigletTree.Builder().minHeight(2)).maxHeight(2)).log(BlockPlanks.EnumType.JUNGLE)).leaves(BlockPlanks.EnumType.JUNGLE)).trunkFruit(Blocks.field_150375_by.func_176223_P())).create());
        }
        GeneratorWeighted flowerGen = (GeneratorWeighted)this.getGenerator("flowers");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            flowerGen.removeGenerator("bluebells");
            flowerGen.removeGenerator("clover");
            flowerGen.removeGenerator("swampflower");
            flowerGen.removeGenerator("deathbloom");
            flowerGen.removeGenerator("glowflower");
            flowerGen.removeGenerator("blue_hydrangeas");
            flowerGen.removeGenerator("pink_daffodil");
            flowerGen.removeGenerator("white_anemones");
            flowerGen.removeGenerator("orange_cosmos");
            flowerGen.removeGenerator("wildflowers");
            flowerGen.removeGenerator("violet");
            flowerGen.removeGenerator("hibiscus");
            flowerGen.removeGenerator("goldenrods");
            flowerGen.removeGenerator("icy_irises");
            flowerGen.removeGenerator("wilted_lily");
            flowerGen.removeGenerator("lily_of_the_valley");
            flowerGen.removeGenerator("bromeliad");
            this.removeGenerator("bromeliad");
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GRASSES)) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
    }
}

