/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.command;

import biomesoplenty.common.util.biome.BiomeUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class BOPCommand
extends CommandBase {
    public static int blockCount = 0;
    public static int itemCount = 0;
    public static int entityCount = 0;
    public static int biomeCount = 0;

    public String func_71517_b() {
        return "biomesoplenty";
    }

    public List func_71514_a() {
        return Lists.newArrayList((Object[])new String[]{"bop", "biomesop"});
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.biomesoplenty.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException("commands.biomesoplenty.usage", new Object[0]);
        }
        if (args[0].equals("biomename")) {
            this.getBiomeName(sender, args);
        } else if (args[0].equals("tpbiome")) {
            this.teleportFoundBiome(sender, args);
        } else if (args[0].equals("stats")) {
            this.printStats(sender, args);
        } else if (args[0].equals("stripchunk")) {
            this.stripChunk(sender, args);
        }
    }

    private void getBiomeName(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            throw new WrongUsageException("commands.biomesoplenty.biomename.usage", new Object[0]);
        }
        int biomeId = BOPCommand.func_175764_a((String)args[1], (int)0, (int)255);
        Biome biome = Biome.func_150568_d((int)biomeId);
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.biomesoplenty.biomename.success", new Object[]{biomeId, biome == null ? "Undefined" : biome.func_185359_l()}));
    }

    private void teleportFoundBiome(ICommandSender sender, String[] args) throws CommandException {
        BlockPos closestBiomePos;
        if (args.length < 2) {
            throw new WrongUsageException("commands.biomesoplenty.tpbiome.usage", new Object[0]);
        }
        Biome biomeToFind = null;
        if (biomeToFind == null) {
            try {
                int biomeId = BOPCommand.func_175764_a((String)args[1], (int)0, (int)255);
                biomeToFind = Biome.func_150568_d((int)biomeId);
            }
            catch (NumberInvalidException e) {
                biomeToFind = BiomeUtils.getBiomeForLoc(new ResourceLocation(args[1]));
            }
        }
        EntityPlayerMP player = BOPCommand.func_71521_c((ICommandSender)sender);
        World world = player.field_70170_p;
        BlockPos blockPos = closestBiomePos = biomeToFind == null ? null : BiomeUtils.spiralOutwardsLookingForBiome(world, biomeToFind, player.field_70165_t, player.field_70161_v);
        if (closestBiomePos != null) {
            double x = closestBiomePos.func_177958_n();
            double y = world.func_175672_r(closestBiomePos).func_177956_o();
            double z = closestBiomePos.func_177952_p();
            String biomeName = FMLCommonHandler.instance().getSide() == Side.CLIENT ? biomeToFind.func_185359_l() : "";
            player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.biomesoplenty.tpbiome.success", new Object[]{player.func_70005_c_(), biomeName, x, y, z}));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.biomesoplenty.tpbiome.error", new Object[]{biomeToFind == null ? "Undefined" : biomeToFind.func_185359_l()}));
        }
    }

    private void printStats(ICommandSender sender, String[] args) throws CommandException {
        TextComponentTranslation text = new TextComponentTranslation("commands.biomesoplenty.stats.blocks", new Object[]{blockCount});
        text.func_150256_b().func_150238_a(TextFormatting.GREEN);
        sender.func_145747_a((ITextComponent)text);
        text = new TextComponentTranslation("commands.biomesoplenty.stats.items", new Object[]{itemCount});
        text.func_150256_b().func_150238_a(TextFormatting.GREEN);
        sender.func_145747_a((ITextComponent)text);
        text = new TextComponentTranslation("commands.biomesoplenty.stats.entities", new Object[]{entityCount});
        text.func_150256_b().func_150238_a(TextFormatting.GREEN);
        sender.func_145747_a((ITextComponent)text);
        text = new TextComponentTranslation("commands.biomesoplenty.stats.biomes", new Object[]{biomeCount});
        text.func_150256_b().func_150238_a(TextFormatting.GREEN);
        sender.func_145747_a((ITextComponent)text);
    }

    private void stripChunk(ICommandSender sender, String[] args) throws CommandException {
        boolean blacklist;
        if (args.length < 5) {
            throw new WrongUsageException("commands.biomesoplenty.stripchunk.usage", new Object[0]);
        }
        int radius = BOPCommand.func_175755_a((String)args[1]);
        String mode = args[2];
        if (mode.equals("include")) {
            blacklist = false;
        } else if (mode.equals("exclude")) {
            blacklist = true;
        } else {
            throw new WrongUsageException("commands.biomesoplenty.stripchunk.usage", new Object[0]);
        }
        ArrayList stateList = Lists.newArrayList();
        for (int i = 0; i < (args.length - 3) / 2; ++i) {
            Block block = BOPCommand.func_147180_g((ICommandSender)sender, (String)args[i * 2 + 3]);
            int metadata = BOPCommand.func_175755_a((String)args[i * 2 + 3 + 1]);
            stateList.add(block.func_176203_a(metadata));
        }
        BlockPos playerPos = sender.func_180425_c();
        World world = sender.func_130014_f_();
        int playerChunkX = playerPos.func_177958_n() >> 4;
        int playerChunkZ = playerPos.func_177952_p() >> 4;
        for (int chunkX = -radius; chunkX < radius; ++chunkX) {
            for (int chunkZ = -radius; chunkZ < radius; ++chunkZ) {
                Chunk chunk = world.func_72964_e(playerChunkX + chunkX, playerChunkZ + chunkZ);
                for (ExtendedBlockStorage blockStorage : chunk.func_76587_i()) {
                    if (blockStorage == null) continue;
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            for (int z = 0; z < 16; ++z) {
                                BlockPos pos = new BlockPos(chunk.field_76635_g * 16 + x, blockStorage.func_76662_d() + y, chunk.field_76647_h * 16 + z);
                                IBlockState state = blockStorage.func_177485_a(x, y, z);
                                if ((blacklist || !stateList.contains(state)) && (!blacklist || stateList.contains(state)) || pos.func_177956_o() <= 0) continue;
                                blockStorage.func_177484_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                                world.func_184138_a(pos, state, Blocks.field_150350_a.func_176223_P(), 3);
                                world.func_175722_b(pos, Blocks.field_150350_a, false);
                            }
                        }
                    }
                }
                chunk.func_76603_b();
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return BOPCommand.func_71530_a((String[])args, (String[])new String[]{"biomename", "tpbiome", "stats", "stripchunk"});
        }
        if (args.length == 3) {
            return BOPCommand.func_71530_a((String[])args, (String[])new String[]{"include", "exclude"});
        }
        return null;
    }
}

