/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.api.generation.BOPGenLayer;
import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.common.world.layer.GenLayerBiomeBOPHell;
import biomesoplenty.common.world.layer.GenLayerIslandBOP;
import biomesoplenty.common.world.layer.GenLayerRaggedEdges;
import biomesoplenty.common.world.layer.GenLayerSubBiomesBOPHell;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;

public class BiomeProviderBOPHell
extends BiomeProvider {
    public BiomeProviderBOPHell(long seed, WorldType worldType, String chunkProviderSettings) {
        System.out.println("settings for hell world: " + chunkProviderSettings);
        BOPWorldSettings settings = new BOPWorldSettings(chunkProviderSettings);
        GenLayer[] genlayers = BiomeProviderBOPHell.setupBOPGenLayers(seed, settings);
        this.field_76944_d = genlayers[0];
        this.field_76945_e = genlayers[1];
    }

    public BiomeProviderBOPHell(World world) {
        this(world.func_72905_C(), world.func_72912_H().func_76067_t(), world.func_72912_H().func_82571_y());
    }

    public static GenLayer allocateBiomes(long worldSeed, BOPWorldSettings settings, GenLayer subBiomesInit) {
        BOPGenLayer biomesLayer = new GenLayerBiomeBOPHell(200L, settings);
        biomesLayer = new GenLayerZoom(1000L, (GenLayer)biomesLayer);
        subBiomesInit = new GenLayerZoom(1000L, subBiomesInit);
        biomesLayer = new GenLayerZoom(1000L, (GenLayer)biomesLayer);
        subBiomesInit = new GenLayerZoom(1000L, subBiomesInit);
        biomesLayer = new GenLayerSubBiomesBOPHell(1000L, biomesLayer, subBiomesInit);
        return biomesLayer;
    }

    public static GenLayer[] setupBOPGenLayers(long worldSeed, BOPWorldSettings settings) {
        int biomeSize = 3;
        BOPGenLayer mainBranch = new GenLayerIslandBOP(1L, 1);
        GenLayerRiverInit riversAndSubBiomesInit = new GenLayerRiverInit(100L, (GenLayer)mainBranch);
        mainBranch = BiomeProviderBOPHell.allocateBiomes(worldSeed, settings, (GenLayer)riversAndSubBiomesInit);
        for (int i = 0; i < biomeSize; ++i) {
            mainBranch = new GenLayerZoom((long)(1000 + i), (GenLayer)mainBranch);
            if (i != 0) continue;
            mainBranch = new GenLayerRaggedEdges(3L, mainBranch);
        }
        mainBranch = new GenLayerSmooth(1000L, (GenLayer)mainBranch);
        GenLayerVoronoiZoom biomesFinal = new GenLayerVoronoiZoom(10L, (GenLayer)mainBranch);
        mainBranch.func_75905_a(worldSeed);
        biomesFinal.func_75905_a(worldSeed);
        return new GenLayer[]{mainBranch, biomesFinal};
    }
}

