/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.configuration;

import codechicken.lib.configuration.IConfigValue;
import java.util.List;
import javax.annotation.Nullable;

public interface IConfigTag
extends IConfigValue {
    public boolean hasParent();

    @Nullable
    public IConfigTag getParent();

    public boolean isCategory();

    public boolean isValue();

    public String getName();

    public String getUnlocalizedName();

    public boolean isDirty();

    public IConfigTag markDirty();

    public void clear();

    public boolean hasTag(String var1);

    public IConfigTag getTag(String var1);

    @Nullable
    public IConfigTag getTagIfPresent(String var1);

    public IConfigTag deleteTag(String var1);

    public List<String> getChildNames();

    public String getTagVersion();

    public IConfigTag setTagVersion(String var1);

    public TagType getTagType();

    public IConfigTag setComment(String var1);

    public IConfigTag setComment(List<String> var1);

    default public void save() {
        if (this.hasParent()) {
            this.getParent().save();
        }
    }

    public Object getRawValue();

    public static enum TagType {
        BOOLEAN{

            @Override
            public char getChar() {
                return 'B';
            }
        }
        ,
        STRING{

            @Override
            public char getChar() {
                return 'S';
            }
        }
        ,
        INT{

            @Override
            public char getChar() {
                return 'I';
            }
        }
        ,
        HEX{

            @Override
            public char getChar() {
                return 'H';
            }

            @Override
            protected String processLine(Object obj) {
                if (obj instanceof String) {
                    String line = (String)obj;
                    return "0x" + line.substring(2).toUpperCase();
                }
                Integer hex = (Integer)obj;
                return "0x" + Long.toString((long)hex.intValue() << 32 >>> 32, 16).toUpperCase();
            }
        }
        ,
        DOUBLE{

            @Override
            public char getChar() {
                return 'D';
            }
        }
        ,
        LIST{

            @Override
            public char getChar() {
                return '#';
            }
        };


        public abstract char getChar();

        protected String processLine(Object obj) {
            return obj.toString();
        }

        public static TagType fromChar(char c) {
            switch (c) {
                case 'B': {
                    return BOOLEAN;
                }
                case 'S': {
                    return STRING;
                }
                case 'I': {
                    return INT;
                }
                case 'D': {
                    return DOUBLE;
                }
                case 'H': {
                    return HEX;
                }
            }
            return null;
        }
    }
}

