/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.particle;

import codechicken.lib.internal.network.PacketDispatcher;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.particle.DigIconParticle;
import codechicken.lib.render.particle.IModelParticleProvider;
import codechicken.lib.texture.IWorldBlockTextureProvider;
import codechicken.lib.util.ResourceUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CustomParticleHandler {
    @SideOnly(value=Side.CLIENT)
    private static Set<TextureAtlasSprite> ignoredParticleSprites;

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public static void addHitEffects(IBlockState state, World world, RayTraceResult trace, ParticleManager particleManager, IWorldBlockTextureProvider provider) {
        TextureAtlasSprite sprite = provider.getTexture(trace.field_178784_b, state, BlockRenderLayer.SOLID, (IBlockAccess)world, trace.func_178782_a());
        Cuboid6 cuboid = new Cuboid6(state.func_185900_c((IBlockAccess)world, trace.func_178782_a())).add(trace.func_178782_a());
        CustomParticleHandler.addBlockHitEffects(world, cuboid, trace.field_178784_b, sprite, particleManager);
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public static void addDestroyEffects(World world, BlockPos pos, ParticleManager particleManager, IWorldBlockTextureProvider provider) {
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[6];
        IBlockState state = world.func_180495_p(pos);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            sprites[face.ordinal()] = provider.getTexture(face, state, BlockRenderLayer.SOLID, (IBlockAccess)world, pos);
        }
        Cuboid6 cuboid = new Cuboid6(state.func_185900_c((IBlockAccess)world, pos)).add(pos);
        CustomParticleHandler.addBlockDestroyEffects(world, cuboid, sprites, particleManager);
    }

    public static boolean handleLandingEffects(WorldServer world, BlockPos pos, EntityLivingBase entity, int numParticles) {
        PacketDispatcher.dispatchLandingEffects((World)world, pos, entity, numParticles);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean handleHitEffects(IBlockState state, World world, RayTraceResult traceResult, ParticleManager manager) {
        if (traceResult != null && traceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = traceResult.func_178782_a();
            BlockModelShapes modelProvider = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
            try {
                state = state.func_185899_b((IBlockAccess)world, pos);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            IBakedModel model = modelProvider.func_178125_b(state);
            state = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos);
            if (model instanceof IModelParticleProvider) {
                Cuboid6 bounds = traceResult instanceof CuboidRayTraceResult ? ((CuboidRayTraceResult)traceResult).cuboid6 : new Cuboid6(state.func_185900_c((IBlockAccess)world, pos));
                bounds = ((Cuboid6)bounds).copy().add(pos);
                Set<TextureAtlasSprite> hitSprites = ((IModelParticleProvider)model).getHitEffects(traceResult, state, (IBlockAccess)world, pos);
                List sprites = hitSprites.stream().filter(sprite -> !ignoredParticleSprites.contains(sprite)).collect(Collectors.toList());
                CustomParticleHandler.addBlockHitEffects(world, bounds, traceResult.field_178784_b, (TextureAtlasSprite)sprites.get(world.field_73012_v.nextInt(sprites.size())), manager);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean handleDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IBlockState state = world.func_180495_p(pos);
        BlockModelShapes modelProvider = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        try {
            state = state.func_185899_b((IBlockAccess)world, pos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IBakedModel model = modelProvider.func_178125_b(state);
        state = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos);
        if (model instanceof IModelParticleProvider) {
            Cuboid6 bounds = new Cuboid6(state.func_185900_c((IBlockAccess)world, pos));
            Set<TextureAtlasSprite> destroySprites = ((IModelParticleProvider)model).getDestroyEffects(state, (IBlockAccess)world, pos);
            List<TextureAtlasSprite> sprites = destroySprites.stream().filter(sprite -> !ignoredParticleSprites.contains(sprite)).collect(Collectors.toList());
            CustomParticleHandler.addBlockDestroyEffects(world, bounds.add(pos), sprites, manager);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addLandingEffects(World world, BlockPos pos, IBlockState state, Vector3 entityPos, int numParticles) {
        Vector3 start = entityPos.copy();
        Vector3 end = start.copy().add(Vector3.down.copy().multiply(4.0));
        RayTraceResult traceResult = world.func_147447_a(start.vec3(), end.vec3(), true, false, true);
        if (traceResult != null && traceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            ParticleManager manager = Minecraft.func_71410_x().field_71452_i;
            Random randy = new Random();
            BlockModelShapes modelProvider = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
            try {
                state = state.func_185899_b((IBlockAccess)world, pos);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            IBakedModel model = modelProvider.func_178125_b(state);
            state = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos);
            if (model instanceof IModelParticleProvider) {
                Set<TextureAtlasSprite> hitSprites = ((IModelParticleProvider)model).getHitEffects(traceResult, state, (IBlockAccess)world, pos);
                List sprites = hitSprites.stream().filter(sprite -> !ignoredParticleSprites.contains(sprite)).collect(Collectors.toList());
                double speed = 0.15f;
                if (numParticles != 0) {
                    for (int i = 0; i < numParticles; ++i) {
                        double mX = randy.nextGaussian() * speed;
                        double mY = randy.nextGaussian() * speed;
                        double mZ = randy.nextGaussian() * speed;
                        manager.func_78873_a((Particle)DigIconParticle.newLandingParticle(world, entityPos.x, entityPos.y, entityPos.z, mX, mY, mZ, (TextureAtlasSprite)sprites.get(randy.nextInt(sprites.size()))));
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addBlockHitEffects(World world, Cuboid6 bounds, EnumFacing side, TextureAtlasSprite icon, ParticleManager particleManager) {
        float border = 0.1f;
        Vector3 diff = bounds.max.copy().subtract(bounds.min).add(-2.0f * border);
        diff.x *= world.field_73012_v.nextDouble();
        diff.y *= world.field_73012_v.nextDouble();
        diff.z *= world.field_73012_v.nextDouble();
        Vector3 pos = diff.add(bounds.min).add(border);
        if (side == EnumFacing.DOWN) {
            diff.y = bounds.min.y - (double)border;
        }
        if (side == EnumFacing.UP) {
            diff.y = bounds.max.y + (double)border;
        }
        if (side == EnumFacing.NORTH) {
            diff.z = bounds.min.z - (double)border;
        }
        if (side == EnumFacing.SOUTH) {
            diff.z = bounds.max.z + (double)border;
        }
        if (side == EnumFacing.WEST) {
            diff.x = bounds.min.x - (double)border;
        }
        if (side == EnumFacing.EAST) {
            diff.x = bounds.max.x + (double)border;
        }
        particleManager.func_78873_a(new DigIconParticle(world, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0, icon).func_70543_e(0.2f).func_70541_f(0.6f));
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public static void addBlockDestroyEffects(World world, Cuboid6 bounds, TextureAtlasSprite[] icons, ParticleManager particleManager) {
        CustomParticleHandler.addBlockDestroyEffects(world, bounds, Lists.newArrayList((Object[])icons), particleManager);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addBlockDestroyEffects(World world, Cuboid6 bounds, List<TextureAtlasSprite> icons, ParticleManager particleManager) {
        Vector3 diff = bounds.max.copy().subtract(bounds.min);
        Vector3 center = bounds.min.copy().add(bounds.max).multiply(0.5);
        Vector3 density = diff.copy().multiply(4.0).ceil();
        int i = 0;
        while ((double)i < density.x) {
            int j = 0;
            while ((double)j < density.y) {
                int k = 0;
                while ((double)k < density.z) {
                    double x = bounds.min.x + ((double)i + 0.5) * diff.x / density.x;
                    double y = bounds.min.y + ((double)j + 0.5) * diff.y / density.y;
                    double z = bounds.min.z + ((double)k + 0.5) * diff.z / density.z;
                    particleManager.func_78873_a((Particle)new DigIconParticle(world, x, y, z, x - center.x, y - center.y, z - center.z, icons.get(world.field_73012_v.nextInt(icons.size()))));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addIgnoredSprite(TextureAtlasSprite sprite) {
        ignoredParticleSprites.add(sprite);
    }

    @SideOnly(value=Side.CLIENT)
    public static void init() {
        ignoredParticleSprites = new HashSet<TextureAtlasSprite>();
        ResourceUtils.registerReloadListener(resourceManager -> ignoredParticleSprites.clear());
    }
}

