/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.handles;

import com.google.common.io.ByteStreams;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import dan200.computercraft.core.apis.handles.HandleGeneric;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class BinaryInputHandle
extends HandleGeneric {
    private final InputStream m_stream;

    public BinaryInputHandle(InputStream reader) {
        super(reader);
        this.m_stream = reader;
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"read", "readAll", "close"};
    }

    @Override
    public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException {
        switch (method) {
            case 0: {
                this.checkOpen();
                try {
                    Object[] objectArray;
                    if (args.length > 0 && args[0] != null) {
                        int count = ArgumentHelper.getInt(args, 0);
                        if (count <= 0 || count >= 16384) {
                            throw new LuaException("Count out of range");
                        }
                        byte[] bytes = new byte[count];
                        if ((count = this.m_stream.read(bytes)) < 0) {
                            return null;
                        }
                        if (count < bytes.length) {
                            bytes = Arrays.copyOf(bytes, count);
                        }
                        return new Object[]{bytes};
                    }
                    int b = this.m_stream.read();
                    if (b == -1) {
                        objectArray = null;
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = b;
                    }
                    return objectArray;
                }
                catch (IOException e) {
                    return null;
                }
            }
            case 1: {
                this.checkOpen();
                try {
                    Object[] objectArray;
                    byte[] out = ByteStreams.toByteArray((InputStream)this.m_stream);
                    if (out == null) {
                        objectArray = null;
                    } else {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = out;
                    }
                    return objectArray;
                }
                catch (IOException e) {
                    return null;
                }
            }
            case 2: {
                this.close();
                return null;
            }
        }
        return null;
    }
}

