/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.api.filesystem.IWritableMount;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;

public class FileMount
implements IWritableMount {
    private static int MINIMUM_FILE_SIZE = 500;
    private File m_rootPath;
    private long m_capacity;
    private long m_usedSpace;

    public FileMount(File rootPath, long capacity) {
        this.m_rootPath = rootPath;
        this.m_capacity = capacity + (long)MINIMUM_FILE_SIZE;
        this.m_usedSpace = this.created() ? this.measureUsedSpace(this.m_rootPath) : (long)MINIMUM_FILE_SIZE;
    }

    @Override
    public boolean exists(@Nonnull String path) throws IOException {
        if (!this.created()) {
            return path.length() == 0;
        }
        File file = this.getRealPath(path);
        return file.exists();
    }

    @Override
    public boolean isDirectory(@Nonnull String path) throws IOException {
        if (!this.created()) {
            return path.length() == 0;
        }
        File file = this.getRealPath(path);
        return file.exists() && file.isDirectory();
    }

    @Override
    public void list(@Nonnull String path, @Nonnull List<String> contents) throws IOException {
        if (!this.created()) {
            if (path.length() != 0) {
                throw new IOException("/" + path + ": Not a directory");
            }
        } else {
            File file = this.getRealPath(path);
            if (file.exists() && file.isDirectory()) {
                String[] paths;
                for (String subPath : paths = file.list()) {
                    if (!new File(file, subPath).exists()) continue;
                    contents.add(subPath);
                }
            } else {
                throw new IOException("/" + path + ": Not a directory");
            }
        }
    }

    @Override
    public long getSize(@Nonnull String path) throws IOException {
        if (!this.created()) {
            if (path.length() == 0) {
                return 0L;
            }
        } else {
            File file = this.getRealPath(path);
            if (file.exists()) {
                if (file.isDirectory()) {
                    return 0L;
                }
                return file.length();
            }
        }
        throw new IOException("/" + path + ": No such file");
    }

    @Override
    @Nonnull
    public InputStream openForRead(@Nonnull String path) throws IOException {
        File file;
        if (this.created() && (file = this.getRealPath(path)).exists() && !file.isDirectory()) {
            return new FileInputStream(file);
        }
        throw new IOException("/" + path + ": No such file");
    }

    @Override
    public void makeDirectory(@Nonnull String path) throws IOException {
        this.create();
        File file = this.getRealPath(path);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException("/" + path + ": File exists");
            }
        } else {
            int dirsToCreate = 1;
            File parent = file.getParentFile();
            while (!parent.exists()) {
                ++dirsToCreate;
                parent = parent.getParentFile();
            }
            if (this.getRemainingSpace() < (long)(dirsToCreate * MINIMUM_FILE_SIZE)) {
                throw new IOException("/" + path + ": Out of space");
            }
            boolean success = file.mkdirs();
            if (success) {
                this.m_usedSpace += (long)(dirsToCreate * MINIMUM_FILE_SIZE);
            } else {
                throw new IOException("/" + path + ": Access denied");
            }
        }
    }

    @Override
    public void delete(@Nonnull String path) throws IOException {
        File file;
        if (path.length() == 0) {
            throw new IOException("/" + path + ": Access denied");
        }
        if (this.created() && (file = this.getRealPath(path)).exists()) {
            this.deleteRecursively(file);
        }
    }

    private void deleteRecursively(File file) throws IOException {
        if (file.isDirectory()) {
            String[] children;
            for (String aChildren : children = file.list()) {
                this.deleteRecursively(new File(file, aChildren));
            }
        }
        long fileSize = file.isDirectory() ? 0L : file.length();
        boolean success = file.delete();
        if (success) {
            this.m_usedSpace -= Math.max((long)MINIMUM_FILE_SIZE, fileSize);
        } else {
            throw new IOException("Access denied");
        }
    }

    @Override
    @Nonnull
    public OutputStream openForWrite(@Nonnull String path) throws IOException {
        this.create();
        File file = this.getRealPath(path);
        if (file.exists() && file.isDirectory()) {
            throw new IOException("/" + path + ": Cannot write to directory");
        }
        if (!file.exists()) {
            if (this.getRemainingSpace() < (long)MINIMUM_FILE_SIZE) {
                throw new IOException("/" + path + ": Out of space");
            }
            this.m_usedSpace += (long)MINIMUM_FILE_SIZE;
        } else {
            this.m_usedSpace -= Math.max(file.length(), (long)MINIMUM_FILE_SIZE);
            this.m_usedSpace += (long)MINIMUM_FILE_SIZE;
        }
        return new CountingOutputStream(new FileOutputStream(file, false), MINIMUM_FILE_SIZE);
    }

    @Override
    @Nonnull
    public OutputStream openForAppend(@Nonnull String path) throws IOException {
        if (this.created()) {
            File file = this.getRealPath(path);
            if (!file.exists()) {
                throw new IOException("/" + path + ": No such file");
            }
            if (file.isDirectory()) {
                throw new IOException("/" + path + ": Cannot write to directory");
            }
            return new CountingOutputStream(new FileOutputStream(file, true), Math.max((long)MINIMUM_FILE_SIZE - file.length(), 0L));
        }
        throw new IOException("/" + path + ": No such file");
    }

    @Override
    public long getRemainingSpace() throws IOException {
        return Math.max(this.m_capacity - this.m_usedSpace, 0L);
    }

    public File getRealPath(String path) {
        return new File(this.m_rootPath, path);
    }

    private boolean created() {
        return this.m_rootPath.exists();
    }

    private void create() throws IOException {
        boolean success;
        if (!this.m_rootPath.exists() && !(success = this.m_rootPath.mkdirs())) {
            throw new IOException("Access denied");
        }
    }

    private long measureUsedSpace(File file) {
        if (!file.exists()) {
            return 0L;
        }
        if (file.isDirectory()) {
            String[] contents;
            long size = MINIMUM_FILE_SIZE;
            for (String content : contents = file.list()) {
                size += this.measureUsedSpace(new File(file, content));
            }
            return size;
        }
        return Math.max(file.length(), (long)MINIMUM_FILE_SIZE);
    }

    private class CountingOutputStream
    extends OutputStream {
        private OutputStream m_innerStream;
        private long m_ignoredBytesLeft;

        public CountingOutputStream(OutputStream innerStream, long bytesToIgnore) {
            this.m_innerStream = innerStream;
            this.m_ignoredBytesLeft = bytesToIgnore;
        }

        @Override
        public void close() throws IOException {
            this.m_innerStream.close();
        }

        @Override
        public void flush() throws IOException {
            this.m_innerStream.flush();
        }

        @Override
        public void write(@Nonnull byte[] b) throws IOException {
            this.count(b.length);
            this.m_innerStream.write(b);
        }

        @Override
        public void write(@Nonnull byte[] b, int off, int len) throws IOException {
            this.count(len);
            this.m_innerStream.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.count(1L);
            this.m_innerStream.write(b);
        }

        private void count(long n) throws IOException {
            this.m_ignoredBytesLeft -= n;
            if (this.m_ignoredBytesLeft < 0L) {
                long newBytes = -this.m_ignoredBytesLeft;
                this.m_ignoredBytesLeft = 0L;
                long bytesLeft = FileMount.this.m_capacity - FileMount.this.m_usedSpace;
                if (newBytes > bytesLeft) {
                    throw new IOException("Out of space");
                }
                FileMount.this.m_usedSpace = FileMount.this.m_usedSpace + newBytes;
            }
        }
    }
}

