/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.common.BlockGeneric;
import dan200.computercraft.shared.common.IDirectionalTile;
import dan200.computercraft.shared.common.ITerminal;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.blocks.BlockComputerBase;
import dan200.computercraft.shared.computer.blocks.IComputerTile;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.PeripheralUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class TileComputerBase
extends TileGeneric
implements IComputerTile,
IDirectionalTile,
ITickable {
    protected int m_instanceID = -1;
    protected int m_computerID = -1;
    protected String m_label = null;
    protected boolean m_on = false;
    protected boolean m_startOn = false;

    protected TileComputerBase() {
    }

    @Override
    public BlockComputerBase getBlock() {
        BlockGeneric block = super.getBlock();
        if (block != null && block instanceof BlockComputerBase) {
            return (BlockComputerBase)block;
        }
        return null;
    }

    protected void unload() {
        if (this.m_instanceID >= 0) {
            if (!this.func_145831_w().field_72995_K) {
                ComputerCraft.serverComputerRegistry.remove(this.m_instanceID);
            }
            this.m_instanceID = -1;
        }
    }

    @Override
    public void destroy() {
        this.unload();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            RedstoneUtil.propagateRedstoneOutput(this.func_145831_w(), this.func_174877_v(), dir);
        }
    }

    public void onChunkUnload() {
        this.unload();
    }

    public void func_145843_s() {
        this.unload();
        super.func_145843_s();
    }

    public abstract void openGUI(EntityPlayer var1);

    protected boolean canNameWithTag(EntityPlayer player) {
        return false;
    }

    protected boolean onDefaultComputerInteract(EntityPlayer player) {
        if (!this.func_145831_w().field_72995_K && this.isUsable(player, false)) {
            this.createServerComputer().turnOn();
            this.openGUI(player);
        }
        return true;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack currentItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!currentItem.func_190926_b() && currentItem.func_77973_b() == Items.field_151057_cb && this.canNameWithTag(player)) {
            if (!this.func_145831_w().field_72995_K) {
                if (currentItem.func_82837_s()) {
                    this.setLabel(currentItem.func_82833_r());
                } else {
                    this.setLabel(null);
                }
                currentItem.func_190918_g(1);
            }
            return true;
        }
        if (!player.func_70093_af()) {
            return this.onDefaultComputerInteract(player);
        }
        return false;
    }

    @Override
    public boolean getRedstoneConnectivity(EnumFacing side) {
        if (side == null) {
            return false;
        }
        int localDir = this.remapLocalSide(DirectionUtil.toLocal(this, side.func_176734_d()));
        return !this.isRedstoneBlockedOnSide(localDir);
    }

    @Override
    public int getRedstoneOutput(EnumFacing side) {
        ServerComputer computer;
        int localDir = this.remapLocalSide(DirectionUtil.toLocal(this, side));
        if (!this.isRedstoneBlockedOnSide(localDir) && this.func_145831_w() != null && !this.func_145831_w().field_72995_K && (computer = this.getServerComputer()) != null) {
            return computer.getRedstoneOutput(localDir);
        }
        return 0;
    }

    @Override
    public boolean getBundledRedstoneConnectivity(@Nonnull EnumFacing side) {
        int localDir = this.remapLocalSide(DirectionUtil.toLocal(this, side));
        return !this.isRedstoneBlockedOnSide(localDir);
    }

    @Override
    public int getBundledRedstoneOutput(@Nonnull EnumFacing side) {
        ServerComputer computer;
        int localDir = this.remapLocalSide(DirectionUtil.toLocal(this, side));
        if (!this.isRedstoneBlockedOnSide(localDir) && !this.func_145831_w().field_72995_K && (computer = this.getServerComputer()) != null) {
            return computer.getBundledRedstoneOutput(localDir);
        }
        return 0;
    }

    @Override
    public void onNeighbourChange() {
        this.updateInput();
    }

    @Override
    public void onNeighbourTileEntityChange(@Nonnull BlockPos neighbour) {
        this.updateInput(neighbour);
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            ServerComputer computer = this.createServerComputer();
            if (computer != null) {
                if (this.m_startOn) {
                    computer.turnOn();
                    this.m_startOn = false;
                }
                computer.keepAlive();
                if (computer.hasOutputChanged()) {
                    this.updateOutput();
                }
                this.m_computerID = computer.getID();
                this.m_label = computer.getLabel();
                this.m_on = computer.isOn();
            }
        } else {
            ClientComputer computer = this.createClientComputer();
            if (computer != null && computer.hasOutputChanged()) {
                this.updateBlock();
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        if (this.m_computerID >= 0) {
            nbttagcompound.func_74768_a("computerID", this.m_computerID);
        }
        if (this.m_label != null) {
            nbttagcompound.func_74778_a("label", this.m_label);
        }
        nbttagcompound.func_74757_a("on", this.m_on);
        return nbttagcompound;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        int id = -1;
        if (nbttagcompound.func_74764_b("computerID")) {
            id = nbttagcompound.func_74762_e("computerID");
        } else if (nbttagcompound.func_74764_b("userDir")) {
            String userDir = nbttagcompound.func_74779_i("userDir");
            try {
                id = Integer.parseInt(userDir);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_computerID = id;
        this.m_label = nbttagcompound.func_74764_b("label") ? nbttagcompound.func_74779_i("label") : null;
        this.m_on = this.m_startOn = nbttagcompound.func_74767_n("on");
    }

    protected boolean isPeripheralBlockedOnSide(int localSide) {
        return false;
    }

    protected boolean isRedstoneBlockedOnSide(int localSide) {
        return false;
    }

    protected int remapLocalSide(int localSide) {
        return localSide;
    }

    private void updateSideInput(ServerComputer computer, EnumFacing dir, BlockPos offset) {
        EnumFacing offsetSide = dir.func_176734_d();
        int localDir = this.remapLocalSide(DirectionUtil.toLocal(this, dir));
        if (!this.isRedstoneBlockedOnSide(localDir)) {
            computer.setRedstoneInput(localDir, RedstoneUtil.getRedstoneOutput(this.func_145831_w(), offset, offsetSide));
            computer.setBundledRedstoneInput(localDir, RedstoneUtil.getBundledRedstoneOutput(this.func_145831_w(), offset, offsetSide));
        }
        if (!this.isPeripheralBlockedOnSide(localDir)) {
            computer.setPeripheral(localDir, PeripheralUtil.getPeripheral(this.func_145831_w(), offset, offsetSide));
        }
    }

    public void updateInput() {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return;
        }
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            BlockPos pos = computer.getPosition();
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                this.updateSideInput(computer, dir, pos.func_177972_a(dir));
            }
        }
    }

    public void updateInput(BlockPos neighbour) {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return;
        }
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            BlockPos pos = computer.getPosition();
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                BlockPos offset = pos.func_177972_a(dir);
                if (!offset.equals((Object)neighbour)) continue;
                this.updateSideInput(computer, dir, offset);
                break;
            }
        }
    }

    public void updateOutput() {
        this.updateBlock();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            RedstoneUtil.propagateRedstoneOutput(this.func_145831_w(), this.func_174877_v(), dir);
        }
    }

    protected abstract ServerComputer createComputer(int var1, int var2);

    @Override
    public ITerminal getTerminal() {
        return this.getComputer();
    }

    @Override
    public void setComputerID(int id) {
        if (!this.func_145831_w().field_72995_K && this.m_computerID != id) {
            this.m_computerID = id;
            ServerComputer computer = this.getServerComputer();
            if (computer != null) {
                computer.setID(this.m_computerID);
            }
            this.func_70296_d();
        }
    }

    @Override
    public void setLabel(String label) {
        if (!this.func_145831_w().field_72995_K) {
            this.createServerComputer().setLabel(label);
        }
    }

    @Override
    public IComputer createComputer() {
        if (this.func_145831_w().field_72995_K) {
            return this.createClientComputer();
        }
        return this.createServerComputer();
    }

    @Override
    public IComputer getComputer() {
        if (this.func_145831_w().field_72995_K) {
            return this.getClientComputer();
        }
        return this.getServerComputer();
    }

    @Override
    public ComputerFamily getFamily() {
        BlockComputerBase block = this.getBlock();
        if (block != null) {
            return block.getFamily((IBlockAccess)this.func_145831_w(), this.func_174877_v());
        }
        return ComputerFamily.Normal;
    }

    public ServerComputer createServerComputer() {
        if (!this.func_145831_w().field_72995_K) {
            boolean changed = false;
            if (this.m_instanceID < 0) {
                this.m_instanceID = ComputerCraft.serverComputerRegistry.getUnusedInstanceID();
                changed = true;
            }
            if (!ComputerCraft.serverComputerRegistry.contains(this.m_instanceID)) {
                ServerComputer computer = this.createComputer(this.m_instanceID, this.m_computerID);
                ComputerCraft.serverComputerRegistry.add(this.m_instanceID, computer);
                changed = true;
            }
            if (changed) {
                this.updateBlock();
                this.updateInput();
            }
            return (ServerComputer)ComputerCraft.serverComputerRegistry.get(this.m_instanceID);
        }
        return null;
    }

    public ServerComputer getServerComputer() {
        if (!this.func_145831_w().field_72995_K) {
            return (ServerComputer)ComputerCraft.serverComputerRegistry.get(this.m_instanceID);
        }
        return null;
    }

    public ClientComputer createClientComputer() {
        if (this.func_145831_w().field_72995_K && this.m_instanceID >= 0) {
            if (!ComputerCraft.clientComputerRegistry.contains(this.m_instanceID)) {
                ComputerCraft.clientComputerRegistry.add(this.m_instanceID, new ClientComputer(this.m_instanceID));
            }
            return (ClientComputer)ComputerCraft.clientComputerRegistry.get(this.m_instanceID);
        }
        return null;
    }

    public ClientComputer getClientComputer() {
        if (this.func_145831_w().field_72995_K) {
            return (ClientComputer)ComputerCraft.clientComputerRegistry.get(this.m_instanceID);
        }
        return null;
    }

    @Override
    public void writeDescription(@Nonnull NBTTagCompound nbttagcompound) {
        super.writeDescription(nbttagcompound);
        nbttagcompound.func_74768_a("instanceID", this.createServerComputer().getInstanceID());
    }

    @Override
    public void readDescription(@Nonnull NBTTagCompound nbttagcompound) {
        super.readDescription(nbttagcompound);
        this.m_instanceID = nbttagcompound.func_74762_e("instanceID");
    }

    protected void transferStateFrom(TileComputerBase copy) {
        if (copy.m_computerID != this.m_computerID || copy.m_instanceID != this.m_instanceID) {
            this.unload();
            this.m_instanceID = copy.m_instanceID;
            this.m_computerID = copy.m_computerID;
            this.m_label = copy.m_label;
            this.m_on = copy.m_on;
            this.m_startOn = copy.m_startOn;
            this.updateBlock();
        }
        copy.m_instanceID = -1;
    }
}

