/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.api.network.IPacketReceiver;
import dan200.computercraft.api.network.IPacketSender;
import dan200.computercraft.api.network.Packet;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class WirelessNetwork
implements IPacketNetwork {
    private static WirelessNetwork s_universalNetwork = null;
    private final Set<IPacketReceiver> m_receivers = new HashSet<IPacketReceiver>();

    public static WirelessNetwork getUniversal() {
        if (s_universalNetwork == null) {
            s_universalNetwork = new WirelessNetwork();
        }
        return s_universalNetwork;
    }

    public static void resetNetworks() {
        s_universalNetwork = null;
    }

    private WirelessNetwork() {
    }

    @Override
    public synchronized void addReceiver(@Nonnull IPacketReceiver receiver) {
        Preconditions.checkNotNull((Object)receiver, (Object)"device cannot be null");
        this.m_receivers.add(receiver);
    }

    @Override
    public synchronized void removeReceiver(@Nonnull IPacketReceiver receiver) {
        Preconditions.checkNotNull((Object)receiver, (Object)"device cannot be null");
        this.m_receivers.remove(receiver);
    }

    @Override
    public synchronized void transmitSameDimension(@Nonnull Packet packet, double range) {
        Preconditions.checkNotNull((Object)packet, (Object)"packet cannot be null");
        for (IPacketReceiver device : this.m_receivers) {
            this.tryTransmit(device, packet, range, false);
        }
    }

    @Override
    public synchronized void transmitInterdimensional(@Nonnull Packet packet) {
        Preconditions.checkNotNull((Object)packet, (Object)"packet cannot be null");
        for (IPacketReceiver device : this.m_receivers) {
            this.tryTransmit(device, packet, 0.0, true);
        }
    }

    private void tryTransmit(IPacketReceiver receiver, Packet packet, double range, boolean interdimensional) {
        IPacketSender sender = packet.getSender();
        if (receiver.getWorld() == sender.getWorld()) {
            double receiveRange = Math.max(range, receiver.getRange());
            double distanceSq = receiver.getPosition().func_72436_e(sender.getPosition());
            if (interdimensional || receiver.isInterdimensional() || distanceSq <= receiveRange * receiveRange) {
                receiver.receiveSameDimension(packet, Math.sqrt(distanceSq));
            }
        } else if (interdimensional || receiver.isInterdimensional()) {
            receiver.receiveDifferentDimension(packet);
        }
    }

    @Override
    public boolean isWireless() {
        return true;
    }
}

