/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import java.util.Optional;
import javax.annotation.Nonnull;

public class TurtleToolCommand
implements ITurtleCommand {
    private final TurtleVerb m_verb;
    private final InteractDirection m_direction;
    private final Optional<TurtleSide> m_side;

    public TurtleToolCommand(TurtleVerb verb, InteractDirection direction, Optional<TurtleSide> side) {
        this.m_verb = verb;
        this.m_direction = direction;
        this.m_side = side;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        TurtleCommandResult firstFailure = null;
        for (TurtleSide side : TurtleSide.values()) {
            ITurtleUpgrade upgrade;
            if (this.m_side.isPresent() && this.m_side.get() != side || (upgrade = turtle.getUpgrade(side)) == null || !upgrade.getType().isTool()) continue;
            TurtleCommandResult result = upgrade.useTool(turtle, side, this.m_verb, this.m_direction.toWorldDir(turtle));
            if (result.isSuccess()) {
                switch (side) {
                    case Left: {
                        turtle.playAnimation(TurtleAnimation.SwingLeftTool);
                        break;
                    }
                    case Right: {
                        turtle.playAnimation(TurtleAnimation.SwingRightTool);
                        break;
                    }
                    default: {
                        turtle.playAnimation(TurtleAnimation.Wait);
                    }
                }
                return result;
            }
            if (firstFailure != null) continue;
            firstFailure = result;
        }
        if (firstFailure != null) {
            return firstFailure;
        }
        return TurtleCommandResult.failure("No tool to " + this.m_verb.toString().toLowerCase() + " with");
    }
}

