/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.util.InventoryUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class TurtleTransferToCommand
implements ITurtleCommand {
    private final int m_slot;
    private final int m_quantity;

    public TurtleTransferToCommand(int slot, int limit) {
        this.m_slot = slot;
        this.m_quantity = limit;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        ItemStack stack = InventoryUtil.takeItems(this.m_quantity, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot(), 1, turtle.getSelectedSlot());
        if (stack.func_190926_b()) {
            turtle.playAnimation(TurtleAnimation.Wait);
            return TurtleCommandResult.success();
        }
        ItemStack remainder = InventoryUtil.storeItems(stack, (IItemHandler)turtle.getItemHandler(), this.m_slot, 1, this.m_slot);
        if (!remainder.func_190926_b()) {
            InventoryUtil.storeItems(remainder, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot(), 1, turtle.getSelectedSlot());
        }
        if (remainder != stack) {
            turtle.playAnimation(TurtleAnimation.Wait);
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure("No space for items");
    }
}

