/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.PeripheralItemFactory;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPeripheral;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TurtleSpeaker
implements ITurtleUpgrade {
    private ResourceLocation m_id;
    private int m_legacyID;
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation m_leftModel;
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation m_rightModel;

    public TurtleSpeaker(ResourceLocation id, int legacyId) {
        this.m_id = id;
        this.m_legacyID = legacyId;
    }

    @Override
    @Nonnull
    public ResourceLocation getUpgradeID() {
        return this.m_id;
    }

    @Override
    public int getLegacyUpgradeID() {
        return this.m_legacyID;
    }

    @Override
    @Nonnull
    public String getUnlocalisedAdjective() {
        return "upgrade.computercraft:speaker.adjective";
    }

    @Override
    @Nonnull
    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    @Override
    @Nonnull
    public ItemStack getCraftingItem() {
        return PeripheralItemFactory.create(PeripheralType.Speaker, null, 1);
    }

    @Override
    public IPeripheral createPeripheral(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return new Peripheral(turtle);
    }

    @Override
    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtleAccess, @Nonnull TurtleSide turtleSide, @Nonnull TurtleVerb verb, @Nonnull EnumFacing direction) {
        return TurtleCommandResult.failure();
    }

    @SideOnly(value=Side.CLIENT)
    private void loadModelLocations() {
        if (this.m_leftModel == null) {
            this.m_leftModel = new ModelResourceLocation("computercraft:turtle_speaker_upgrade_left", "inventory");
            this.m_rightModel = new ModelResourceLocation("computercraft:turtle_speaker_upgrade_right", "inventory");
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Pair<IBakedModel, Matrix4f> getModel(ITurtleAccess turtle, @Nonnull TurtleSide side) {
        this.loadModelLocations();
        ModelManager modelManager = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a();
        if (side == TurtleSide.Left) {
            return Pair.of((Object)modelManager.func_174953_a(this.m_leftModel), null);
        }
        return Pair.of((Object)modelManager.func_174953_a(this.m_rightModel), null);
    }

    @Override
    public void update(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide turtleSide) {
        IPeripheral turtlePeripheral = turtle.getPeripheral(turtleSide);
        if (turtlePeripheral instanceof Peripheral) {
            Peripheral peripheral = (Peripheral)turtlePeripheral;
            peripheral.update();
        }
    }

    private static class Peripheral
    extends SpeakerPeripheral {
        ITurtleAccess m_turtle;

        public Peripheral(ITurtleAccess turtle) {
            this.m_turtle = turtle;
        }

        @Override
        public void update() {
            super.update();
        }

        @Override
        public World getWorld() {
            return this.m_turtle.getWorld();
        }

        @Override
        public BlockPos getPos() {
            return this.m_turtle.getPosition();
        }

        @Override
        public boolean equals(IPeripheral other) {
            if (other instanceof Peripheral) {
                Peripheral otherPeripheral = (Peripheral)other;
                return otherPeripheral.m_turtle == this.m_turtle;
            }
            return false;
        }
    }
}

