/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.util.Vector;
import org.luaj.vm2.Lua;
import org.luaj.vm2.Prototype;

public class BasicBlock {
    int pc0;
    int pc1;
    BasicBlock[] prev;
    BasicBlock[] next;
    boolean islive;

    public BasicBlock(Prototype prototype, int n) {
        this.pc0 = this.pc1 = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.pc0 + 1 + "-" + (this.pc1 + 1) + (this.prev != null ? "  prv: " + this.str(this.prev, 1) : "") + (this.next != null ? "  nxt: " + this.str(this.next, 0) : "") + "\n");
        return stringBuffer.toString();
    }

    private String str(BasicBlock[] basicBlockArray, int n) {
        if (basicBlockArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n2 = basicBlockArray.length;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(String.valueOf(n == 1 ? basicBlockArray[i].pc1 + 1 : basicBlockArray[i].pc0 + 1));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static BasicBlock[] findBasicBlocks(Prototype prototype) {
        Object object;
        int n = prototype.code.length;
        boolean[] blArray = new boolean[n];
        final boolean[] blArray2 = new boolean[n];
        blArray[0] = true;
        BranchVisitor branchVisitor = new BranchVisitor(blArray){

            public void visitBranch(int n, int n2) {
                blArray2[n] = true;
                this.isbeg[n2] = true;
            }

            public void visitReturn(int n) {
                blArray2[n] = true;
            }
        };
        BasicBlock.visitBranches(prototype, branchVisitor);
        BasicBlock.visitBranches(prototype, branchVisitor);
        final BasicBlock[] basicBlockArray = new BasicBlock[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = true;
            object = new BasicBlock(prototype, i);
            basicBlockArray[i] = object;
            while (!blArray2[i] && i + 1 < n && !blArray[i + 1]) {
                object.pc1 = ++i;
                basicBlockArray[object.pc1] = object;
            }
        }
        final int[] nArray = new int[n];
        object = new int[n];
        BasicBlock.visitBranches(prototype, new BranchVisitor(blArray, (int[])object){
            private final /* synthetic */ int[] val$nprev;
            {
                this.val$nprev = nArray2;
            }

            public void visitBranch(int n, int n2) {
                int n3 = n;
                nArray[n3] = nArray[n3] + 1;
                int n4 = n2;
                this.val$nprev[n4] = this.val$nprev[n4] + 1;
            }
        });
        BasicBlock.visitBranches(prototype, new BranchVisitor(blArray, (int[])object){
            private final /* synthetic */ int[] val$nprev;
            {
                this.val$nprev = nArray2;
            }

            public void visitBranch(int n, int n2) {
                if (basicBlockArray[n].next == null) {
                    basicBlockArray[n].next = new BasicBlock[nArray[n]];
                }
                if (basicBlockArray[n2].prev == null) {
                    basicBlockArray[n2].prev = new BasicBlock[this.val$nprev[n2]];
                }
                int n3 = n;
                int n4 = nArray[n3] - 1;
                nArray[n3] = n4;
                basicBlockArray[n].next[n4] = basicBlockArray[n2];
                int n5 = n2;
                int n6 = this.val$nprev[n5] - 1;
                this.val$nprev[n5] = n6;
                basicBlockArray[n2].prev[n6] = basicBlockArray[n];
            }
        });
        return basicBlockArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void visitBranches(Prototype prototype, BranchVisitor branchVisitor) {
        int[] nArray = prototype.code;
        int n = nArray.length;
        int n2 = 0;
        while (true) {
            block12: {
                if (n2 >= n) {
                    return;
                }
                int n3 = nArray[n2];
                switch (Lua.GET_OPCODE(n3)) {
                    case 2: {
                        if (0 == Lua.GETARG_C(n3)) break;
                        if (Lua.GET_OPCODE(nArray[n2 + 1]) == 22) {
                            throw new IllegalArgumentException("OP_LOADBOOL followed by jump at " + n2);
                        }
                        branchVisitor.visitBranch(n2, n2 + 2);
                        break block12;
                    }
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 33: {
                        if (Lua.GET_OPCODE(nArray[n2 + 1]) != 22) {
                            throw new IllegalArgumentException("test not followed by jump at " + n2);
                        }
                        int n4 = Lua.GETARG_sBx(nArray[n2 + 1]);
                        int n5 = ++n2 + n4 + 1;
                        branchVisitor.visitBranch(n2, n5);
                        branchVisitor.visitBranch(n2, n2 + 1);
                        break block12;
                    }
                    case 31: {
                        int n4 = Lua.GETARG_sBx(n3);
                        int n5 = n2 + n4 + 1;
                        branchVisitor.visitBranch(n2, n5);
                        branchVisitor.visitBranch(n2, n2 + 1);
                        break block12;
                    }
                    case 22: 
                    case 32: {
                        int n4 = Lua.GETARG_sBx(n3);
                        int n5 = n2 + n4 + 1;
                        branchVisitor.visitBranch(n2, n5);
                        break block12;
                    }
                    case 29: 
                    case 30: {
                        branchVisitor.visitReturn(n2);
                        break block12;
                    }
                }
                if (n2 + 1 < n && branchVisitor.isbeg[n2 + 1]) {
                    branchVisitor.visitBranch(n2, n2 + 1);
                }
            }
            ++n2;
        }
    }

    public static BasicBlock[] findLiveBlocks(BasicBlock[] basicBlockArray) {
        int n;
        Object object;
        Vector<BasicBlock> vector = new Vector<BasicBlock>();
        vector.addElement(basicBlockArray[0]);
        while (!vector.isEmpty()) {
            int n2;
            object = (BasicBlock)vector.elementAt(0);
            vector.removeElementAt(0);
            if (((BasicBlock)object).islive) continue;
            ((BasicBlock)object).islive = true;
            int n3 = n2 = ((BasicBlock)object).next != null ? ((BasicBlock)object).next.length : 0;
            for (n = 0; n < n2; ++n) {
                if (((BasicBlock)object).next[n].islive) continue;
                vector.addElement(((BasicBlock)object).next[n]);
            }
        }
        object = new Vector();
        n = 0;
        while (n < basicBlockArray.length) {
            if (basicBlockArray[n].islive) {
                ((Vector)object).addElement(basicBlockArray[n]);
            }
            n = basicBlockArray[n].pc1 + 1;
        }
        Object[] objectArray = new BasicBlock[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        return objectArray;
    }

    public static abstract class BranchVisitor {
        final boolean[] isbeg;

        public BranchVisitor(boolean[] blArray) {
            this.isbeg = blArray;
        }

        public void visitBranch(int n, int n2) {
        }

        public void visitReturn(int n) {
        }
    }
}

