/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCPetData;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.ai.EntityAIFollowAdult;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIHunt;
import drzhark.mocreatures.entity.ai.EntityAINearestAttackableTargetMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.inventory.MoCAnimalChest;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MoCEntityBigCat
extends MoCEntityTameableAnimal {
    public int mouthCounter;
    public int tailCounter;
    public int wingFlapCounter;
    public MoCAnimalChest localchest;
    public ItemStack localstack;
    protected String chestName = "BigCatChest";
    private int tCounter;
    private float fTransparency;
    private static final DataParameter<Boolean> RIDEABLE = EntityDataManager.func_187226_a(MoCEntityBigCat.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_AMULET = EntityDataManager.func_187226_a(MoCEntityBigCat.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(MoCEntityBigCat.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> GHOST = EntityDataManager.func_187226_a(MoCEntityBigCat.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CHESTED = EntityDataManager.func_187226_a(MoCEntityBigCat.class, (DataSerializer)DataSerializers.field_187198_h);

    public MoCEntityBigCat(World world) {
        super(world);
        this.setEdad(45);
        this.func_70105_a(1.4f, 1.3f);
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.setAdult(false);
        } else {
            this.setAdult(true);
        }
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowAdult((EntityLiving)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwnerPlayer((EntityLiving)this, 1.0, 2.0f, 10.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderMoC2((EntityCreature)this, 0.8, 30));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTargetMoC((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAIHunt((EntityCreature)this, (Class<? extends EntityCreature>)EntityAnimal.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(8.0);
    }

    @Override
    public void selectType() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.calculateMaxHealth());
        this.func_70606_j(this.func_110138_aP());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.calculateAttackDmg());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getAttackRange());
        if (this.getIsAdult()) {
            this.setEdad(this.getMaxEdad());
        }
    }

    @Override
    public double getCustomSpeed() {
        return 2.0;
    }

    public float getMoveSpeed() {
        return 1.6f;
    }

    public float calculateMaxHealth() {
        return 20.0f;
    }

    public double calculateAttackDmg() {
        return 5.0;
    }

    public double getAttackRange() {
        return 6.0;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RIDEABLE, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(GHOST, (Object)false);
        this.field_70180_af.func_187214_a(HAS_AMULET, (Object)false);
        this.field_70180_af.func_187214_a(CHESTED, (Object)false);
    }

    public boolean getHasAmulet() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_AMULET);
    }

    @Override
    public boolean getIsSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    @Override
    public boolean getIsRideable() {
        return (Boolean)this.field_70180_af.func_187225_a(RIDEABLE);
    }

    public boolean getIsChested() {
        return (Boolean)this.field_70180_af.func_187225_a(CHESTED);
    }

    @Override
    public boolean getIsGhost() {
        return (Boolean)this.field_70180_af.func_187225_a(GHOST);
    }

    public void setHasAmulet(boolean flag) {
        this.field_70180_af.func_187227_b(HAS_AMULET, (Object)flag);
    }

    public void setSitting(boolean flag) {
        this.field_70180_af.func_187227_b(SITTING, (Object)flag);
    }

    public void setIsChested(boolean flag) {
        this.field_70180_af.func_187227_b(CHESTED, (Object)flag);
    }

    @Override
    public void setRideable(boolean flag) {
        this.field_70180_af.func_187227_b(RIDEABLE, (Object)flag);
    }

    public void setIsGhost(boolean flag) {
        this.field_70180_af.func_187227_b(GHOST, (Object)flag);
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        Entity entity = damagesource.func_76346_g();
        if (this.func_184207_aI() && entity == this.func_184187_bx()) {
            return false;
        }
        if (super.func_70097_a(damagesource, i)) {
            if (entity != null && this.getIsTamed() && entity instanceof EntityPlayer) {
                return false;
            }
            if (entity != this && entity instanceof EntityLivingBase && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                this.func_70624_b((EntityLivingBase)entity);
            }
            return true;
        }
        return false;
    }

    protected SoundEvent func_184615_bR() {
        this.openMouth();
        if (this.getIsAdult()) {
            return MoCSoundEvents.ENTITY_LION_DEATH;
        }
        return MoCSoundEvents.ENTITY_LION_DEATH_BABY;
    }

    protected Item func_146068_u() {
        return MoCItems.bigcatclaw;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        this.openMouth();
        if (this.getIsAdult()) {
            return MoCSoundEvents.ENTITY_LION_HURT;
        }
        return MoCSoundEvents.ENTITY_LION_HURT_BABY;
    }

    protected SoundEvent func_184639_G() {
        this.openMouth();
        if (this.getIsAdult()) {
            return MoCSoundEvents.ENTITY_LION_AMBIENT;
        }
        return MoCSoundEvents.ENTITY_LION_AMBIENT_BABY;
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getHasAmulet()) {
                MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack((Item)MoCItems.medallion, 1));
                this.setHasAmulet(false);
            }
            if (this.getIsTamed() && !this.getIsGhost() && this.field_70146_Z.nextInt(4) == 0) {
                this.spawnGhost();
            }
        }
        super.func_70645_a(damagesource);
    }

    public void spawnGhost() {
        try {
            EntityLiving templiving = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation("mocreatures:" + this.getClazzString().toLowerCase()), (World)this.field_70170_p);
            if (templiving != null && templiving instanceof MoCEntityBigCat) {
                MoCEntityBigCat ghost = (MoCEntityBigCat)templiving;
                ghost.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)ghost);
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_MAGIC_APPEAR);
                ghost.setOwnerId(this.func_184753_b());
                ghost.setTamed(true);
                EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 24.0);
                if (entityplayer != null) {
                    MoCTools.tameWithName(entityplayer, ghost);
                }
                ghost.setAdult(false);
                ghost.setEdad(1);
                ghost.setType(this.getType());
                ghost.selectType();
                ghost.setIsGhost(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void func_70636_d() {
        EntityItem entityitem;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() == null) {
                this.func_70031_b(false);
            } else {
                this.func_70031_b(true);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
                this.mouthCounter = 0;
            }
            if (this.field_70146_Z.nextInt(250) == 0) {
                this.moveTail();
            }
            if (this.tailCounter > 0 && ++this.tailCounter > 10 && this.field_70146_Z.nextInt(15) == 0) {
                this.tailCounter = 0;
            }
        } else {
            if (this.getIsGhost() && this.getEdad() > 0 && this.getEdad() < 10 && this.field_70146_Z.nextInt(5) == 0) {
                this.setEdad(this.getEdad() + 1);
                if (this.getEdad() == 9) {
                    this.setEdad(this.getMaxEdad());
                    this.setAdult(true);
                }
            }
            if (!this.getIsGhost() && this.getEdad() < 10) {
                this.func_70106_y();
            }
        }
        if (!this.field_70170_p.field_72995_K && this.isFlyer() && this.isOnAir()) {
            float myFlyingSpeed = MoCTools.getMyMovementSpeed((Entity)this);
            int wingFlapFreq = (int)(25.0f - myFlyingSpeed * 10.0f);
            if (!this.func_184207_aI() || wingFlapFreq < 5) {
                wingFlapFreq = 5;
            }
            if (this.field_70146_Z.nextInt(wingFlapFreq) == 0) {
                this.wingFlap();
            }
        }
        if (this.isFlyer()) {
            if (this.wingFlapCounter > 0 && ++this.wingFlapCounter > 20) {
                this.wingFlapCounter = 0;
            }
            if (!this.field_70170_p.field_72995_K && this.wingFlapCounter == 5) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_WINGFLAP);
            }
        }
        if (this.field_70146_Z.nextInt(300) == 0 && this.func_110143_aJ() <= this.func_110138_aP() && this.field_70725_aQ == 0 && !this.field_70170_p.field_72995_K) {
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
        }
        if (this.field_70725_aQ == 0 && !this.isMovementCeased() && (entityitem = this.getClosestItem((Entity)this, 12.0, Items.field_151147_al, Items.field_151115_aP)) != null) {
            float f = entityitem.func_70032_d((Entity)this);
            if (f > 2.0f) {
                this.getMyOwnPath((Entity)entityitem, f);
            }
            if (f < 2.0f && entityitem != null && this.field_70725_aQ == 0) {
                entityitem.func_70106_y();
                this.func_70606_j(this.func_110138_aP());
                this.setHasEaten(true);
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_EATING);
            }
        }
    }

    @Override
    public boolean readytoBreed() {
        return !this.getIsGhost() && super.readytoBreed();
    }

    public void wingFlap() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.wingFlapCounter == 0) {
            this.wingFlapCounter = 1;
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 3), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
    }

    @Override
    public boolean isNotScared() {
        return this.getIsAdult() || this.getEdad() > 80;
    }

    @Override
    public boolean isReadyToHunt() {
        return this.getIsAdult() && !this.isMovementCeased();
    }

    public void func_184232_k(Entity passenger) {
        double dist = (double)this.getSizeFactor() * 0.1;
        double newPosX = this.field_70165_t + dist * Math.sin(this.field_70761_aq / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.cos(this.field_70761_aq / 57.29578f);
        passenger.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), newPosZ);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Saddle", this.getIsRideable());
        nbttagcompound.func_74757_a("Sitting", this.getIsSitting());
        nbttagcompound.func_74757_a("Chested", this.getIsChested());
        nbttagcompound.func_74757_a("Ghost", this.getIsGhost());
        nbttagcompound.func_74757_a("Amulet", this.getHasAmulet());
        if (this.getIsChested() && this.localchest != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.localchest.func_70302_i_(); ++i) {
                this.localstack = this.localchest.func_70301_a(i);
                if (this.localstack == null || this.localstack.func_190926_b()) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                this.localstack.func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setRideable(nbttagcompound.func_74767_n("Saddle"));
        this.setSitting(nbttagcompound.func_74767_n("Sitting"));
        this.setIsChested(nbttagcompound.func_74767_n("Chested"));
        this.setIsGhost(nbttagcompound.func_74767_n("Ghost"));
        this.setHasAmulet(nbttagcompound.func_74767_n("Amulet"));
        if (this.getIsChested()) {
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
            this.localchest = new MoCAnimalChest("BigCatChest", 18);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.localchest.func_70302_i_()) continue;
                this.localchest.func_70299_a(j, new ItemStack(nbttagcompound1));
            }
        }
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean onMainHand;
        Boolean tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = onMainHand = hand == EnumHand.MAIN_HAND;
        if (!stack.func_190926_b() && onMainHand && !this.getIsTamed() && this.getHasEaten() && !this.getIsAdult() && stack.func_77973_b() == MoCItems.medallion) {
            if (!this.field_70170_p.field_72995_K) {
                this.setHasAmulet(true);
                MoCTools.tameWithName(player, this);
            }
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                return true;
            }
            return true;
        }
        if (!stack.func_190926_b() && onMainHand && this.getIsTamed() && !this.getHasAmulet() && stack.func_77973_b() == MoCItems.medallion) {
            if (!this.field_70170_p.field_72995_K) {
                this.setHasAmulet(true);
            }
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                return true;
            }
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == MoCItems.whip) {
            this.setSitting(!this.getIsSitting());
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && onMainHand && MoCTools.isItemEdibleforCarnivores(stack.func_77973_b())) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
            this.func_70606_j(this.func_110138_aP());
            MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_EATING);
            this.setIsHunting(false);
            this.setHasEaten(true);
            return true;
        }
        if (!stack.func_190926_b() && onMainHand && this.getIsTamed() && !this.getIsRideable() && this.getEdad() > 80 && (stack.func_77973_b() == Items.field_151141_av || stack.func_77973_b() == MoCItems.horsesaddle)) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
            this.setRideable(true);
            return true;
        }
        if (!stack.func_190926_b() && onMainHand && this.getIsGhost() && this.getIsTamed() && stack.func_77973_b() == MoCItems.amuletghost) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            if (!this.field_70170_p.field_72995_K) {
                MoCPetData petData = MoCreatures.instance.mapData.getPetData(this.func_184753_b());
                if (petData != null) {
                    petData.setInAmulet(this.getOwnerPetId(), true);
                }
                this.dropMyStuff();
                MoCTools.dropAmulet(this, 3, player);
                this.field_70128_L = true;
            }
            return true;
        }
        if (!stack.func_190926_b() && onMainHand && this.getIsTamed() && this.getIsAdult() && !this.getIsChested() && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
            this.setIsChested(true);
            MoCTools.playCustomSound((Entity)this, SoundEvents.field_187665_Y);
            return true;
        }
        if (this.getIsChested() && player.func_70093_af()) {
            if (this.localchest == null) {
                this.localchest = new MoCAnimalChest(this.chestName, 18);
            }
            if (!this.field_70170_p.field_72995_K) {
                player.func_71007_a((IInventory)this.localchest);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public float getSizeFactor() {
        return (float)this.getEdad() * 0.01f;
    }

    public void func_180430_e(float f, float f1) {
        if (this.isFlyer()) {
            return;
        }
        float i = (float)(Math.ceil(f - 3.0f) / 2.0);
        if (!this.field_70170_p.field_72995_K && i > 0.0f) {
            if ((i /= 2.0f) > 1.0f) {
                this.func_70097_a(DamageSource.field_76379_h, i);
            }
            if (this.func_184207_aI() && i > 1.0f) {
                for (Entity entity : this.func_184182_bu()) {
                    entity.func_70097_a(DamageSource.field_76379_h, i);
                }
            }
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 0.2 - (double)this.field_70126_B, this.field_70161_v));
            Block block = iblockstate.func_177230_c();
            if (iblockstate.func_185904_a() != Material.field_151579_a && !this.func_174814_R()) {
                SoundType soundtype = block.getSoundType(iblockstate, this.field_70170_p, new BlockPos(this.field_70165_t, this.field_70163_u - 0.2 - (double)this.field_70126_B, this.field_70161_v), (Entity)this);
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundtype.func_185844_d(), this.func_184176_by(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    private void openMouth() {
        this.mouthCounter = 1;
    }

    public boolean hasMane() {
        return false;
    }

    public int func_70627_aG() {
        return 400;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    public boolean hasSaberTeeth() {
        return false;
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType != 0 && animationType == 3) {
            this.wingFlapCounter = 1;
        }
    }

    @Override
    public void makeEntityJump() {
        if (this.isFlyer()) {
            this.wingFlap();
        }
        super.makeEntityJump();
    }

    @Override
    public void dropMyStuff() {
        if (!this.field_70170_p.field_72995_K) {
            this.dropArmor();
            MoCTools.dropSaddle(this, this.field_70170_p);
            if (this.getIsChested()) {
                MoCTools.dropInventory((Entity)this, this.localchest);
                MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack((Block)Blocks.field_150486_ae, 1));
                this.setIsChested(false);
            }
        }
    }

    public boolean getHasStinger() {
        return false;
    }

    public double func_70042_X() {
        double Yfactor = (0.0833 * (double)this.getEdad() - 2.5) / 10.0;
        return (double)this.field_70131_O * Yfactor;
    }

    public float tFloat() {
        if (++this.tCounter > 30) {
            this.tCounter = 0;
            this.fTransparency = this.field_70146_Z.nextFloat() * 0.2f + 0.15f;
        }
        if (this.getEdad() < 10) {
            return 0.0f;
        }
        return this.fTransparency;
    }

    @Override
    public int nameYOffset() {
        return (int)((0.445 * (double)this.getEdad() + 15.0) * -1.0);
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    public float func_70689_ay() {
        if (this.func_70051_ag()) {
            return 0.37f;
        }
        return 0.18f;
    }
}

