/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import com.google.common.base.Predicate;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromEntityMoC;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.init.MoCSoundEvents;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MoCEntityBird
extends MoCEntityTameableAnimal {
    private boolean fleeing;
    public float wingb;
    public float wingc;
    public float wingd;
    public float winge;
    public float wingh;
    public boolean textureSet;
    private int jumpTimer;
    protected EntityAIWanderMoC2 wander;
    public static final String[] birdNames = new String[]{"Dove", "Crow", "Parrot", "Blue", "Canary", "Red"};
    private static final DataParameter<Boolean> PRE_TAMED = EntityDataManager.func_187226_a(MoCEntityBird.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_FLYING = EntityDataManager.func_187226_a(MoCEntityBird.class, (DataSerializer)DataSerializers.field_187198_h);

    public MoCEntityBird(World world) {
        super(world);
        this.func_70105_a(0.4f, 0.3f);
        this.field_70124_G = true;
        this.wingb = 0.0f;
        this.wingc = 0.0f;
        this.wingh = 1.0f;
        this.fleeing = false;
        this.textureSet = false;
        this.setTamed(false);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFleeFromEntityMoC((EntityCreature)this, new Predicate<Entity>(){

            public boolean apply(Entity entity) {
                return !(entity instanceof MoCEntityBird) && (entity.field_70131_O > 0.4f || entity.field_70130_N > 0.4f);
            }
        }, 6.0f, 1.0, 1.3));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowOwnerPlayer((EntityLiving)this, 0.8, 2.0f, 10.0f));
        this.wander = new EntityAIWanderMoC2((EntityCreature)this, 1.0, 80);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.wander);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            this.setType(this.field_70146_Z.nextInt(6) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("birdwhite.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("birdblack.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("birdgreen.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("birdblue.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("birdyellow.png");
            }
            case 6: {
                return MoCreatures.proxy.getTexture("birdred.png");
            }
        }
        return MoCreatures.proxy.getTexture("birdblue.png");
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PRE_TAMED, (Object)false);
        this.field_70180_af.func_187214_a(IS_FLYING, (Object)false);
    }

    public boolean getPreTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(PRE_TAMED);
    }

    public void setPreTamed(boolean flag) {
        this.field_70180_af.func_187227_b(PRE_TAMED, (Object)flag);
    }

    @Override
    public boolean getIsFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_FLYING);
    }

    public void setIsFlying(boolean flag) {
        this.field_70180_af.func_187227_b(IS_FLYING, (Object)flag);
    }

    public void func_180430_e(float f, float f1) {
    }

    private int[] FindTreeTop(int i, int j, int k) {
        int l = i - 5;
        int i1 = k - 5;
        int j1 = i + 5;
        int k1 = j + 7;
        int l1 = k + 5;
        for (int i2 = l; i2 < j1; ++i2) {
            for (int j2 = i1; j2 < l1; ++j2) {
                BlockPos pos = new BlockPos(i2, j, j2);
                IBlockState blockstate = this.field_70170_p.func_180495_p(pos);
                if (blockstate.func_177230_c().isAir(blockstate, (IBlockAccess)this.field_70170_p, pos) || blockstate.func_185904_a() != Material.field_151575_d) continue;
                for (int l2 = j; l2 < k1; ++l2) {
                    BlockPos pos1 = new BlockPos(i2, l2, j2);
                    IBlockState blockstate1 = this.field_70170_p.func_180495_p(pos1);
                    if (!blockstate1.func_177230_c().isAir(blockstate1, (IBlockAccess)this.field_70170_p, pos1)) continue;
                    return new int[]{i2, l2 + 2, j2};
                }
            }
        }
        return new int[]{0, 0, 0};
    }

    private boolean FlyToNextEntity(Entity entity) {
        if (entity != null) {
            int i = MathHelper.func_76128_c((double)entity.field_70165_t);
            int j = MathHelper.func_76128_c((double)entity.field_70163_u);
            int k = MathHelper.func_76128_c((double)entity.field_70161_v);
            this.faceLocation(i, j, k, 30.0f);
            if (MathHelper.func_76128_c((double)this.field_70163_u) < j) {
                this.field_70181_x += 0.15;
            }
            if (this.field_70165_t < entity.field_70165_t) {
                double d = entity.field_70165_t - this.field_70165_t;
                if (d > 0.5) {
                    this.field_70159_w += 0.05;
                }
            } else {
                double d1 = this.field_70165_t - entity.field_70165_t;
                if (d1 > 0.5) {
                    this.field_70159_w -= 0.05;
                }
            }
            if (this.field_70161_v < entity.field_70161_v) {
                double d2 = entity.field_70161_v - this.field_70161_v;
                if (d2 > 0.5) {
                    this.field_70179_y += 0.05;
                }
            } else {
                double d3 = this.field_70161_v - entity.field_70161_v;
                if (d3 > 0.5) {
                    this.field_70179_y -= 0.05;
                }
            }
            return true;
        }
        return false;
    }

    private boolean FlyToNextTree() {
        int[] ai = this.ReturnNearestMaterialCoord((Entity)this, Material.field_151584_j, 20.0);
        int[] ai1 = this.FindTreeTop(ai[0], ai[1], ai[2]);
        if (ai1[1] != 0) {
            int i = ai1[0];
            int j = ai1[1];
            int k = ai1[2];
            this.faceLocation(i, j, k, 30.0f);
            if (j - MathHelper.func_76128_c((double)this.field_70163_u) > 2) {
                this.field_70181_x += 0.15;
            }
            int l = 0;
            int i1 = 0;
            if (this.field_70165_t < (double)i) {
                l = i - MathHelper.func_76128_c((double)this.field_70165_t);
                this.field_70159_w += 0.05;
            } else {
                l = MathHelper.func_76128_c((double)this.field_70165_t) - i;
                this.field_70159_w -= 0.05;
            }
            if (this.field_70161_v < (double)k) {
                i1 = k - MathHelper.func_76128_c((double)this.field_70161_v);
                this.field_70179_y += 0.05;
            } else {
                i1 = MathHelper.func_76128_c((double)this.field_70165_t) - k;
                this.field_70179_y -= 0.05;
            }
            double d = l + i1;
            if (d < 3.0) {
                return true;
            }
        }
        return false;
    }

    protected Item func_146068_u() {
        return Items.field_151008_G;
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_BIRD_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MoCSoundEvents.ENTITY_BIRD_HURT;
    }

    protected SoundEvent func_184639_G() {
        if (this.getType() == 1) {
            return MoCSoundEvents.ENTITY_BIRD_AMBIENT_WHITE;
        }
        if (this.getType() == 2) {
            return MoCSoundEvents.ENTITY_BIRD_AMBIENT_BLACK;
        }
        if (this.getType() == 3) {
            return MoCSoundEvents.ENTITY_BIRD_AMBIENT_GREEN;
        }
        if (this.getType() == 4) {
            return MoCSoundEvents.ENTITY_BIRD_AMBIENT_BLUE;
        }
        if (this.getType() == 5) {
            return MoCSoundEvents.ENTITY_BIRD_AMBIENT_YELLOW;
        }
        return MoCSoundEvents.ENTITY_BIRD_AMBIENT_RED;
    }

    public double func_70033_W() {
        if (this.func_184187_bx() instanceof EntityPlayer) {
            return ((EntityPlayer)this.func_184187_bx()).func_70093_af() ? 0.2 : (double)0.45f;
        }
        return super.func_70033_W();
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean onMainHand;
        Boolean tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = onMainHand = hand == EnumHand.MAIN_HAND;
        if (!stack.func_190926_b() && onMainHand && this.getPreTamed() && !this.getIsTamed() && stack.func_77973_b() == Items.field_151014_N) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
            if (!this.field_70170_p.field_72995_K) {
                MoCTools.tameWithName(player, this);
            }
            return true;
        }
        if (!this.getIsTamed()) {
            return false;
        }
        if (this.func_184187_bx() == null) {
            if (this.func_184220_m((Entity)player)) {
                this.field_70177_z = player.field_70177_z;
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.winge = this.wingb;
        this.wingd = this.wingc;
        this.wingc = (float)((double)this.wingc + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        if (this.wingc < 0.0f) {
            this.wingc = 0.0f;
        }
        if (this.wingc > 1.0f) {
            this.wingc = 1.0f;
        }
        if (!this.field_70122_E && this.wingh < 1.0f) {
            this.wingh = 1.0f;
        }
        this.wingh = (float)((double)this.wingh * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.8;
        }
        this.wingb += this.wingh * 2.0f;
        if (!this.field_70170_p.field_72995_K) {
            EntityItem entityitem;
            if (this.isMovementCeased() && this.getIsFlying()) {
                this.setIsFlying(false);
            }
            if (this.getIsFlying() && this.func_70661_as().func_75500_f() && !this.isMovementCeased() && this.func_70638_az() == null && this.field_70146_Z.nextInt(30) == 0) {
                this.wander.makeUpdate();
            }
            if (!this.getIsFlying() && !this.getIsTamed() && this.field_70146_Z.nextInt(10) == 0) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(4.0, 4.0, 4.0));
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity1 = (Entity)list.get(i);
                    if (!(entity1 instanceof EntityLivingBase) || entity1 instanceof MoCEntityBird || !(((EntityLivingBase)entity1).field_70130_N >= 0.4f) || !(((EntityLivingBase)entity1).field_70131_O >= 0.4f) || !this.func_70685_l(entity1)) continue;
                    this.setIsFlying(true);
                    this.fleeing = true;
                    this.wander.makeUpdate();
                }
            }
            if (!this.isMovementCeased() && !this.getIsFlying() && this.field_70146_Z.nextInt(this.getIsTamed() ? 1000 : 400) == 0) {
                this.setIsFlying(true);
                this.wander.makeUpdate();
            }
            if (this.getIsFlying() && this.field_70146_Z.nextInt(200) == 0) {
                this.setIsFlying(false);
            }
            if (this.fleeing && this.field_70146_Z.nextInt(50) == 0) {
                this.fleeing = false;
            }
            if (!this.fleeing && (entityitem = this.getClosestItem((Entity)this, 12.0, Items.field_151014_N, Items.field_151081_bc)) != null) {
                this.FlyToNextEntity((Entity)entityitem);
                EntityItem entityitem1 = this.getClosestItem((Entity)this, 1.0, Items.field_151014_N, Items.field_151081_bc);
                if (this.field_70146_Z.nextInt(50) == 0 && entityitem1 != null) {
                    entityitem1.func_70106_y();
                    this.setPreTamed(true);
                }
            }
            if (this.field_70146_Z.nextInt(10) == 0 && this.func_70055_a(Material.field_151586_h)) {
                this.WingFlap();
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_184187_bx() != null) {
            this.field_70177_z = this.func_184187_bx().field_70177_z;
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)this.func_184187_bx();
            this.field_70177_z = entityplayer.field_70177_z;
            entityplayer.field_70143_R = 0.0f;
            if (entityplayer.field_70181_x < -0.1) {
                entityplayer.field_70181_x *= 0.6;
            }
        }
        if (--this.jumpTimer <= 0 && this.field_70122_E && (this.field_70159_w > 0.05 || this.field_70179_y > 0.05 || this.field_70159_w < -0.05 || this.field_70179_y < -0.05)) {
            this.field_70181_x = 0.25;
            float velX = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f));
            float velZ = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
            this.field_70159_w += (double)(-0.2f * velX);
            this.field_70179_y += (double)(0.2f * velZ);
            this.jumpTimer = 15;
        }
    }

    public int[] ReturnNearestMaterialCoord(Entity entity, Material material, Double double1) {
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72321_a(double1.doubleValue(), double1.doubleValue(), double1.doubleValue());
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0));
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockPos pos = new BlockPos(k1, l1, i2);
                    IBlockState blockstate = this.field_70170_p.func_180495_p(pos);
                    if (blockstate.func_177230_c() == null || blockstate.func_177230_c().isAir(blockstate, (IBlockAccess)this.field_70170_p, pos) || blockstate.func_185904_a() != material) continue;
                    return new int[]{k1, l1, i2};
                }
            }
        }
        return new int[]{-1, 0, 0};
    }

    @Override
    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && this.getIsTamed() && this.func_110143_aJ() > 0.0f) {
            return;
        }
        super.func_70106_y();
    }

    private void WingFlap() {
        this.field_70181_x += 0.05;
        if (this.field_70146_Z.nextInt(30) == 0) {
            this.field_70159_w += 0.2;
        }
        if (this.field_70146_Z.nextInt(30) == 0) {
            this.field_70159_w -= 0.2;
        }
        if (this.field_70146_Z.nextInt(30) == 0) {
            this.field_70179_y += 0.2;
        }
        if (this.field_70146_Z.nextInt(30) == 0) {
            this.field_70179_y -= 0.2;
        }
    }

    @Override
    public int nameYOffset() {
        return -40;
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() == Items.field_151014_N || stack.func_77973_b() == Items.field_151081_bc);
    }

    @Override
    public boolean isNotScared() {
        return this.getIsTamed();
    }

    @Override
    public boolean isFlyer() {
        return true;
    }

    @Override
    public int maxFlyingHeight() {
        if (this.getIsTamed()) {
            return 4;
        }
        return 6;
    }

    @Override
    public int minFlyingHeight() {
        return 2;
    }

    @Override
    public boolean canRidePlayer() {
        return true;
    }
}

