/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.passive.MoCEntityBear;
import drzhark.mocreatures.init.MoCItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MoCEntityGrizzlyBear
extends MoCEntityBear {
    public MoCEntityGrizzlyBear(World world) {
        super(world);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            this.setType(1);
        }
        super.selectType();
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getTexture("bearbrowm.png");
    }

    @Override
    public float getBearSize() {
        return 1.2f;
    }

    @Override
    public int getMaxEdad() {
        return 120;
    }

    @Override
    public float calculateMaxHealth() {
        return 40.0f;
    }

    @Override
    public double getAttackRange() {
        int factor = 1;
        if (this.field_70170_p.func_175659_aa().func_151525_a() > 1) {
            factor = 2;
        }
        return 6.0 * (double)factor;
    }

    @Override
    public int getAttackStrength() {
        int factor = this.field_70170_p.func_175659_aa().func_151525_a();
        return 3 * factor;
    }

    @Override
    public boolean shouldAttackPlayers() {
        return this.func_70013_c() < 0.4f && super.shouldAttackPlayers();
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean onMainHand;
        Boolean tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = onMainHand = hand == EnumHand.MAIN_HAND;
        if (!stack.func_190926_b() && onMainHand && this.getEdad() < 80 && MoCTools.isItemEdibleforCarnivores(stack.func_77973_b())) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
            if (!this.getIsTamed() && !this.field_70170_p.field_72995_K) {
                MoCTools.tameWithName(player, this);
            }
            this.func_70606_j(this.func_110138_aP());
            this.eatingAnimal();
            if (!this.field_70170_p.field_72995_K && !this.getIsAdult() && this.getEdad() < 100) {
                this.setEdad(this.getEdad() + 1);
            }
            return true;
        }
        if (!stack.func_190926_b() && this.getIsTamed() && stack.func_77973_b() == MoCItems.whip) {
            if (this.getBearState() == 0) {
                this.setBearState(2);
            } else {
                this.setBearState(0);
            }
            return true;
        }
        if (!(!this.getIsRideable() || !this.getIsAdult() || this.getIsChested() && player.func_70093_af() || this.func_184207_aI())) {
            if (!this.field_70170_p.field_72995_K && player.func_184220_m((Entity)this)) {
                player.field_70177_z = this.field_70177_z;
                player.field_70125_A = this.field_70125_A;
                this.setBearState(0);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public String getOffspringClazz(IMoCTameable mate) {
        return "GrizzlyBear";
    }

    @Override
    public int getOffspringTypeInt(IMoCTameable mate) {
        return 1;
    }

    @Override
    public boolean compatibleMate(Entity mate) {
        return mate instanceof MoCEntityGrizzlyBear;
    }
}

