/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCPetData;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.ai.EntityAIHunt;
import drzhark.mocreatures.entity.ai.EntityAINearestAttackableTargetMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.inventory.MoCAnimalChest;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MoCEntityWyvern
extends MoCEntityTameableAnimal {
    public MoCAnimalChest localchest;
    public ItemStack localstack;
    public int mouthCounter;
    public int wingFlapCounter;
    public int diveCounter;
    public static final String[] wyvernNames = new String[]{"Jungle", "Swamp", "Savanna", "Sand", "Mother", "Undead", "Light", "Dark", "Arctic", "Cave", "Mountain", "Sea"};
    protected EntityAIWanderMoC2 wander;
    private int transformType;
    private int transformCounter;
    private int tCounter;
    private float fTransparency;
    private static final DataParameter<Boolean> RIDEABLE = EntityDataManager.func_187226_a(MoCEntityWyvern.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CHESTED = EntityDataManager.func_187226_a(MoCEntityWyvern.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(MoCEntityWyvern.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> GHOST = EntityDataManager.func_187226_a(MoCEntityWyvern.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(MoCEntityWyvern.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ARMOR_TYPE = EntityDataManager.func_187226_a(MoCEntityWyvern.class, (DataSerializer)DataSerializers.field_187192_b);

    public MoCEntityWyvern(World world) {
        super(world);
        this.func_70105_a(1.9f, 1.7f);
        this.setAdult(false);
        this.setTamed(false);
        this.field_70138_W = 1.0f;
        if (this.field_70146_Z.nextInt(6) == 0) {
            this.setEdad(50 + this.field_70146_Z.nextInt(50));
        } else {
            this.setEdad(80 + this.field_70146_Z.nextInt(20));
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.wander = new EntityAIWanderMoC2((EntityCreature)this, 1.0, 80);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.wander);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTargetMoC((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHunt((EntityCreature)this, (Class<? extends EntityCreature>)EntityAnimal.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RIDEABLE, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(CHESTED, (Object)false);
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(GHOST, (Object)false);
        this.field_70180_af.func_187214_a(ARMOR_TYPE, (Object)0);
    }

    @Override
    public boolean getIsFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setIsFlying(boolean flag) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flag);
    }

    @Override
    public int getArmorType() {
        return (Integer)this.field_70180_af.func_187225_a(ARMOR_TYPE);
    }

    @Override
    public void setArmorType(int i) {
        this.field_70180_af.func_187227_b(ARMOR_TYPE, (Object)i);
    }

    @Override
    public boolean getIsRideable() {
        return (Boolean)this.field_70180_af.func_187225_a(RIDEABLE);
    }

    @Override
    public void setRideable(boolean flag) {
        this.field_70180_af.func_187227_b(RIDEABLE, (Object)flag);
    }

    public boolean getIsChested() {
        return (Boolean)this.field_70180_af.func_187225_a(CHESTED);
    }

    public void setIsChested(boolean flag) {
        this.field_70180_af.func_187227_b(CHESTED, (Object)flag);
    }

    @Override
    public boolean getIsSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean flag) {
        this.field_70180_af.func_187227_b(SITTING, (Object)flag);
    }

    @Override
    public boolean getIsGhost() {
        return (Boolean)this.field_70180_af.func_187225_a(GHOST);
    }

    public void setIsGhost(boolean flag) {
        this.field_70180_af.func_187227_b(GHOST, (Object)flag);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            if (this.field_70146_Z.nextInt(5) == 0) {
                this.setType(5);
            } else {
                int i = this.field_70146_Z.nextInt(100);
                if (i <= 12) {
                    this.setType(1);
                } else if (i <= 24) {
                    this.setType(2);
                } else if (i <= 36) {
                    this.setType(3);
                } else if (i <= 48) {
                    this.setType(4);
                } else if (i <= 60) {
                    this.setType(9);
                } else if (i <= 72) {
                    this.setType(10);
                } else if (i <= 84) {
                    this.setType(11);
                } else if (i <= 95) {
                    this.setType(12);
                } else {
                    this.setType(5);
                }
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.calculateMaxHealth());
        this.func_70606_j(this.func_110138_aP());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.calculateAttackDmg());
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    public double calculateMaxHealth() {
        if (this.getType() == 6 || this.getType() == 7 || this.getType() == 8) {
            return 60.0;
        }
        if (this.getType() == 5) {
            return 80.0;
        }
        if (this.getType() == 13) {
            return 100.0;
        }
        return 40.0;
    }

    public double calculateAttackDmg() {
        if (this.getType() == 6 || this.getType() == 7 || this.getType() == 8 || this.getType() == 13) {
            return 8.0;
        }
        if (this.getType() == 5) {
            return 12.0;
        }
        return 5.0;
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.transformCounter != 0 && this.transformType > 5) {
            String newText = "wyverndark.png";
            if (this.transformType == 6) {
                newText = "wyvernundead.png";
            }
            if (this.transformType == 7) {
                newText = "wyvernlight.png";
            }
            if (this.transformType == 8) {
                newText = "wyverndark.png";
            }
            if (this.transformCounter % 5 == 0) {
                return MoCreatures.proxy.getTexture(newText);
            }
            if (this.transformCounter > 50 && this.transformCounter % 3 == 0) {
                return MoCreatures.proxy.getTexture(newText);
            }
            if (this.transformCounter > 75 && this.transformCounter % 4 == 0) {
                return MoCreatures.proxy.getTexture(newText);
            }
        }
        switch (this.getType()) {
            case 1: {
                return MoCreatures.proxy.getTexture("wyvernjungle.png");
            }
            case 2: {
                return MoCreatures.proxy.getTexture("wyvernmix.png");
            }
            case 3: {
                return MoCreatures.proxy.getTexture("wyvernsand.png");
            }
            case 4: {
                return MoCreatures.proxy.getTexture("wyvernsun.png");
            }
            case 5: {
                return MoCreatures.proxy.getTexture("wyvernmother.png");
            }
            case 6: {
                return MoCreatures.proxy.getTexture("wyvernundead.png");
            }
            case 7: {
                return MoCreatures.proxy.getTexture("wyvernlight.png");
            }
            case 8: {
                return MoCreatures.proxy.getTexture("wyverndark.png");
            }
            case 9: {
                return MoCreatures.proxy.getTexture("wyvernarctic.png");
            }
            case 10: {
                return MoCreatures.proxy.getTexture("wyverncave.png");
            }
            case 11: {
                return MoCreatures.proxy.getTexture("wyvernmountain.png");
            }
            case 12: {
                return MoCreatures.proxy.getTexture("wyvernsea.png");
            }
        }
        return MoCreatures.proxy.getTexture("wyvernsun.png");
    }

    public void transform(int tType) {
        if (!this.field_70170_p.field_72995_K) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), tType), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.transformType = tType;
        this.transformCounter = 1;
    }

    @Override
    public void func_70636_d() {
        if (this.wingFlapCounter > 0 && ++this.wingFlapCounter > 20) {
            this.wingFlapCounter = 0;
        }
        if (this.wingFlapCounter == 5 && !this.field_70170_p.field_72995_K) {
            MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_WYVERN_WINGFLAP);
        }
        if (this.transformCounter > 0) {
            if (this.transformCounter == 40) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_TRANSFORM);
            }
            if (++this.transformCounter > 100) {
                this.transformCounter = 0;
                if (this.transformType != 0) {
                    this.setType(this.transformType);
                    this.selectType();
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!this.isMovementCeased() && !this.getIsTamed() && this.field_70146_Z.nextInt(300) == 0) {
                this.setIsFlying(!this.getIsFlying());
            }
            if (this.isMovementCeased() && this.getIsFlying()) {
                this.setIsFlying(false);
            }
            if (!(this.func_70638_az() == null || this.getIsTamed() && this.func_184187_bx() == null || this.isMovementCeased() || this.field_70146_Z.nextInt(20) != 0)) {
                this.setIsFlying(true);
            }
            if (!this.getIsTamed() && this.field_71093_bK == MoCreatures.WyvernLairDimensionID && this.field_70146_Z.nextInt(50) == 0 && this.field_70163_u < 10.0) {
                this.func_70106_y();
            }
            if (this.getIsFlying() && this.func_70661_as().func_75500_f() && !this.isMovementCeased() && this.func_70638_az() == null && this.field_70146_Z.nextInt(30) == 0) {
                this.wander.makeUpdate();
            }
            if (this.field_70181_x > 0.5) {
                this.field_70181_x = 0.5;
            }
            if (this.isOnAir()) {
                float myFlyingSpeed = MoCTools.getMyMovementSpeed((Entity)this);
                int wingFlapFreq = (int)(25.0f - myFlyingSpeed * 10.0f);
                if (!this.func_184207_aI() || wingFlapFreq < 5) {
                    wingFlapFreq = 5;
                }
                if (this.field_70146_Z.nextInt(wingFlapFreq) == 0) {
                    this.wingFlap();
                }
            }
            if (this.getIsGhost() && this.getEdad() > 0 && this.getEdad() < 10 && this.field_70146_Z.nextInt(5) == 0) {
                this.setEdad(this.getEdad() + 1);
                if (this.getEdad() == 9) {
                    this.setEdad(140);
                    this.setAdult(true);
                }
            }
        } else {
            if (this.mouthCounter > 0 && ++this.mouthCounter > 30) {
                this.mouthCounter = 0;
            }
            if (this.diveCounter > 0 && ++this.diveCounter > 5) {
                this.diveCounter = 0;
            }
        }
        super.func_70636_d();
    }

    public void wingFlap() {
        if (this.wingFlapCounter == 0) {
            this.wingFlapCounter = 1;
            if (!this.field_70170_p.field_72995_K) {
                MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 3), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
            }
        }
    }

    @Override
    public float getSizeFactor() {
        return (float)this.getEdad() * 0.01f;
    }

    @Override
    public boolean isFlyingAlone() {
        return this.getIsFlying() && !this.func_184207_aI();
    }

    @Override
    public int maxFlyingHeight() {
        if (this.getIsTamed()) {
            return 5;
        }
        return 18;
    }

    @Override
    public int minFlyingHeight() {
        return 1;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean onMainHand;
        Boolean tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = onMainHand = hand == EnumHand.MAIN_HAND;
        if (!stack.func_190926_b() && stack.func_77973_b() == MoCItems.whip && this.getIsTamed() && !this.func_184207_aI()) {
            this.setSitting(!this.getIsSitting());
            return true;
        }
        if (!stack.func_190926_b() && onMainHand && !this.getIsRideable() && this.getEdad() > 90 && this.getIsTamed() && (stack.func_77973_b() == Items.field_151141_av || stack.func_77973_b() == MoCItems.horsesaddle)) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
            this.setRideable(true);
            return true;
        }
        if (!stack.func_190926_b() && onMainHand && this.getIsTamed() && this.getEdad() > 90 && stack.func_77973_b() == Items.field_151138_bX) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_ARMOR_ON);
            }
            this.dropArmor();
            this.setArmorType(1);
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
            return true;
        }
        if (!stack.func_190926_b() && onMainHand && this.getIsTamed() && this.getEdad() > 90 && stack.func_77973_b() == Items.field_151136_bY) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_ARMOR_ON);
            }
            this.dropArmor();
            this.setArmorType(2);
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
            return true;
        }
        if (!stack.func_190926_b() && onMainHand && this.getIsTamed() && this.getEdad() > 90 && stack.func_77973_b() == Items.field_151125_bZ) {
            if (this.getArmorType() == 0) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_ARMOR_ON);
            }
            this.dropArmor();
            this.setArmorType(3);
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
            return true;
        }
        if (!stack.func_190926_b() && onMainHand && this.getIsTamed() && this.getEdad() > 90 && !this.getIsChested() && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
            this.setIsChested(true);
            MoCTools.playCustomSound((Entity)this, SoundEvents.field_187665_Y);
            return true;
        }
        if (this.getIsChested() && player.func_70093_af()) {
            if (this.localchest == null) {
                this.localchest = new MoCAnimalChest("WyvernChest", 9);
            }
            if (!this.field_70170_p.field_72995_K) {
                player.func_71007_a((IInventory)this.localchest);
            }
            return true;
        }
        if (!stack.func_190926_b() && onMainHand && this.getIsGhost() && this.getIsTamed() && stack.func_77973_b() == MoCItems.amuletghost) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            if (!this.field_70170_p.field_72995_K) {
                MoCPetData petData = MoCreatures.instance.mapData.getPetData(this.func_184753_b());
                if (petData != null) {
                    petData.setInAmulet(this.getOwnerPetId(), true);
                }
                this.dropMyStuff();
                MoCTools.dropAmulet(this, 3, player);
                this.field_70128_L = true;
            }
            return true;
        }
        if (!stack.func_190926_b() && onMainHand && !this.getIsGhost() && stack.func_77973_b() == MoCItems.essencelight && this.getIsTamed() && this.getEdad() > 90 && this.getType() < 5) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (!this.field_70170_p.field_72995_K) {
                int i = this.getType() + 49;
                MoCEntityEgg entityegg = new MoCEntityEgg(this.field_70170_p, i);
                entityegg.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                player.field_70170_p.func_72838_d((Entity)entityegg);
                entityegg.field_70181_x += (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.05f);
                entityegg.field_70159_w += (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.3f);
                entityegg.field_70179_y += (double)((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.3f);
            }
            return true;
        }
        if (!stack.func_190926_b() && onMainHand && this.transformCounter == 0 && !this.getIsGhost() && this.getType() == 5 && stack.func_77973_b() == MoCItems.essenceundead && this.getIsTamed()) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (!this.field_70170_p.field_72995_K) {
                this.transform(6);
            }
            return true;
        }
        if (!stack.func_190926_b() && onMainHand && this.transformCounter == 0 && !this.getIsGhost() && this.getType() == 5 && stack.func_77973_b() == MoCItems.essencelight && this.getIsTamed()) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (!this.field_70170_p.field_72995_K) {
                this.transform(7);
            }
            return true;
        }
        if (!stack.func_190926_b() && onMainHand && this.transformCounter == 0 && !this.getIsGhost() && this.getType() == 5 && stack.func_77973_b() == MoCItems.essencedarkness && this.getIsTamed()) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151069_bo));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            if (!this.field_70170_p.field_72995_K) {
                this.transform(8);
            }
            return true;
        }
        if (!(!this.getIsRideable() || this.getEdad() <= 90 || this.getIsChested() && player.func_70093_af() || this.func_184207_aI())) {
            if (!this.field_70170_p.field_72995_K && player.func_184220_m((Entity)this)) {
                player.field_70177_z = this.field_70177_z;
                player.field_70125_A = this.field_70125_A;
                this.setSitting(false);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void dropArmor() {
        if (!this.field_70170_p.field_72995_K) {
            EntityItem entityitem;
            int i = this.getArmorType();
            if (i != 0) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_ARMOR_OFF);
            }
            if (i == 1) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Items.field_151138_bX, 1));
                entityitem.func_174867_a(10);
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (i == 2) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Items.field_151136_bY, 1));
                entityitem.func_174867_a(10);
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            if (i == 3) {
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Items.field_151125_bZ, 1));
                entityitem.func_174867_a(10);
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            this.setArmorType(0);
        }
    }

    @Override
    public boolean rideableEntity() {
        return true;
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_WYVERN_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        this.openMouth();
        return MoCSoundEvents.ENTITY_WYVERN_HURT;
    }

    protected SoundEvent func_184639_G() {
        this.openMouth();
        return MoCSoundEvents.ENTITY_WYVERN_AMBIENT;
    }

    public int func_70627_aG() {
        return 400;
    }

    @Override
    public boolean isMovementCeased() {
        return this.func_184207_aI() || this.getIsSitting();
    }

    @Override
    public boolean isFlyer() {
        return true;
    }

    public void func_180430_e(float f, float f1) {
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.85 * (double)this.getSizeFactor();
    }

    public void func_184232_k(Entity passenger) {
        double dist = (double)this.getSizeFactor() * 0.3;
        double newPosX = this.field_70165_t - dist * Math.cos(MoCTools.realAngle(this.field_70761_aq - 90.0f) / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.sin(MoCTools.realAngle(this.field_70761_aq - 90.0f) / 57.29578f);
        passenger.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), newPosZ);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (entityIn instanceof EntityPlayer && !this.shouldAttackPlayers()) {
            return false;
        }
        this.openMouth();
        return super.func_70652_k(entityIn);
    }

    protected void func_174815_a(EntityLivingBase entityLivingBaseIn, Entity entityIn) {
        if (entityIn instanceof EntityPlayer && this.field_70146_Z.nextInt(3) == 0) {
            MoCreatures.poisonPlayer((EntityPlayer)entityIn);
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 0));
        }
        super.func_174815_a(entityLivingBaseIn, entityIn);
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        Entity entity = damagesource.func_76346_g();
        if (this.func_184215_y(entity)) {
            return false;
        }
        if (super.func_70097_a(damagesource, i)) {
            if (entity != null && this.getIsTamed() && entity instanceof EntityPlayer) {
                return false;
            }
            if (entity != this && super.shouldAttackPlayers()) {
                this.func_70624_b((EntityLivingBase)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Saddle", this.getIsRideable());
        nbttagcompound.func_74757_a("Chested", this.getIsChested());
        nbttagcompound.func_74768_a("ArmorType", this.getArmorType());
        nbttagcompound.func_74757_a("isSitting", this.getIsSitting());
        nbttagcompound.func_74757_a("isGhost", this.getIsGhost());
        if (this.getIsChested() && this.localchest != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.localchest.func_70302_i_(); ++i) {
                this.localstack = this.localchest.func_70301_a(i);
                if (this.localstack == null || this.localstack.func_190926_b()) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                this.localstack.func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setRideable(nbttagcompound.func_74767_n("Saddle"));
        this.setIsChested(nbttagcompound.func_74767_n("Chested"));
        this.setArmorType(nbttagcompound.func_74762_e("ArmorType"));
        this.setSitting(nbttagcompound.func_74767_n("isSitting"));
        this.setIsGhost(nbttagcompound.func_74767_n("isGhost"));
        if (this.getIsChested()) {
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
            this.localchest = new MoCAnimalChest("WyvernChest", 14);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.localchest.func_70302_i_()) continue;
                this.localchest.func_70299_a(j, new ItemStack(nbttagcompound1));
            }
        }
    }

    @Override
    public int nameYOffset() {
        int yOff = this.getEdad() * -1;
        if (yOff < -120) {
            yOff = -120;
        }
        if (this.getIsSitting()) {
            yOff += 25;
        }
        return yOff;
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() == MoCItems.ratRaw || stack.func_77973_b() == MoCItems.rawTurkey);
    }

    private void openMouth() {
        if (!this.field_70170_p.field_72995_K) {
            this.mouthCounter = 1;
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 1) {
            this.mouthCounter = 1;
        }
        if (animationType == 2) {
            this.diveCounter = 1;
        }
        if (animationType == 3) {
            this.wingFlapCounter = 1;
        }
        if (animationType > 5 && animationType < 9) {
            this.transformType = animationType;
            this.transformCounter = 1;
        }
    }

    @Override
    public void makeEntityDive() {
        if (!this.field_70170_p.field_72995_K) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 2), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        super.makeEntityDive();
    }

    protected void func_70628_a(boolean flag, int x) {
        int chance = MoCreatures.proxy.wyvernEggDropChance;
        if (this.getType() == 5) {
            chance = MoCreatures.proxy.motherWyvernEggDropChance;
        }
        if (this.field_70146_Z.nextInt(100) < chance) {
            this.func_70099_a(new ItemStack((Item)MoCItems.mocegg, 1, this.getType() + 49), 0.0f);
        }
    }

    public boolean func_70067_L() {
        return !this.func_184207_aI();
    }

    @Override
    public void dropMyStuff() {
        if (!this.field_70170_p.field_72995_K) {
            this.dropArmor();
            MoCTools.dropSaddle(this, this.field_70170_p);
            if (this.getIsChested()) {
                MoCTools.dropInventory((Entity)this, this.localchest);
                MoCTools.dropCustomItem((Entity)this, this.field_70170_p, new ItemStack((Block)Blocks.field_150486_ae, 1));
                this.setIsChested(false);
            }
        }
    }

    @Override
    public float getAdjustedYOffset() {
        if (this.getIsSitting()) {
            return 0.4f;
        }
        return 0.0f;
    }

    @Override
    public double getCustomSpeed() {
        if (this.func_184207_aI()) {
            return 1.0;
        }
        return 0.8;
    }

    @Override
    public int getMaxEdad() {
        if (this.getType() == 5) {
            return 180;
        }
        if (this.getType() == 6 || this.getType() == 7 || this.getType() == 8) {
            return 160;
        }
        return 120;
    }

    public EnumCreatureAttribute func_70668_bt() {
        if (this.getType() == 6 || this.getIsGhost()) {
            return EnumCreatureAttribute.UNDEAD;
        }
        return super.func_70668_bt();
    }

    @Override
    public boolean isReadyToHunt() {
        return !this.isMovementCeased() && !this.func_184207_aI();
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        return !(entity instanceof MoCEntityWyvern) && (double)entity.field_70131_O <= 1.0 && (double)entity.field_70130_N <= 1.0;
    }

    @Override
    protected double flyerThrust() {
        return 0.6;
    }

    public float func_70689_ay() {
        if (this.getIsFlying()) {
            return 0.4f;
        }
        return super.func_70689_ay();
    }

    @Override
    protected float flyerFriction() {
        if (this.getType() == 5) {
            return 0.96f;
        }
        if (this.getType() == 6 || this.getType() == 7 || this.getType() == 8 || this.getIsGhost()) {
            return 0.96f;
        }
        return 0.94f;
    }

    @Override
    public void makeEntityJump() {
        this.wingFlap();
        super.makeEntityJump();
    }

    @Override
    public boolean shouldAttackPlayers() {
        return !this.getIsTamed() && super.shouldAttackPlayers();
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getType() == 6) {
                MoCTools.spawnMaggots(this.field_70170_p, (Entity)this);
            }
            if (!this.getIsGhost() && this.getIsTamed() && this.field_70146_Z.nextInt(4) == 0) {
                MoCEntityWyvern entitywyvern = new MoCEntityWyvern(this.field_70170_p);
                entitywyvern.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)entitywyvern);
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_MAGIC_APPEAR);
                entitywyvern.setOwnerId(this.func_184753_b());
                entitywyvern.setTamed(true);
                EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 24.0);
                if (entityplayer != null) {
                    MoCTools.tameWithName(entityplayer, entitywyvern);
                }
                entitywyvern.setAdult(false);
                entitywyvern.setEdad(1);
                entitywyvern.setType(this.getType());
                entitywyvern.selectType();
                entitywyvern.setIsGhost(true);
            }
        }
        super.func_70645_a(damagesource);
    }

    public float tFloat() {
        if (++this.tCounter > 30) {
            this.tCounter = 0;
            this.fTransparency = this.field_70146_Z.nextFloat() * 0.2f + 0.15f;
        }
        if (this.getEdad() < 10) {
            return 0.0f;
        }
        return this.fTransparency;
    }

    @Override
    protected boolean canBeTrappedInNet() {
        return this.getIsTamed() && !this.getIsGhost();
    }
}

