/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIController;
import codechicken.nei.SaveLoadButton;
import codechicken.nei.VisibilityData;
import codechicken.nei.api.API;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.config.KeyBindings;
import codechicken.nei.gui.GuiExtendedCreativeInv;
import codechicken.nei.guihook.IContainerDrawHandler;
import codechicken.nei.guihook.IContainerObjectHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.guihook.IInputHandler;
import codechicken.nei.handler.KeyManager;
import codechicken.nei.handler.NEIClientEventHandler;
import codechicken.nei.layout.LayoutStyle;
import codechicken.nei.layout.LayoutStyleMinecraft;
import codechicken.nei.layout.LayoutStyleTMIOld;
import codechicken.nei.network.NEIClientPacketHandler;
import codechicken.nei.util.ItemList;
import codechicken.nei.util.NEIClientUtils;
import codechicken.nei.util.helper.GuiHelper;
import codechicken.nei.widget.Button;
import codechicken.nei.widget.ButtonCycled;
import codechicken.nei.widget.ItemPanel;
import codechicken.nei.widget.Label;
import codechicken.nei.widget.SearchField;
import codechicken.nei.widget.SubsetWidget;
import codechicken.nei.widget.TextField;
import codechicken.nei.widget.Widget;
import codechicken.nei.widget.WidgetZOrder;
import codechicken.nei.widget.action.NEIActions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class LayoutManager
implements IInputHandler,
IContainerTooltipHandler,
IContainerDrawHandler,
IContainerObjectHandler,
KeyManager.IKeyStateTracker {
    private static LayoutManager instance;
    private static Widget inputFocused;
    private static TreeSet<Widget> drawWidgets;
    private static TreeSet<Widget> controlWidgets;
    private static boolean showItemPanel;
    public static ItemPanel itemPanel;
    public static SubsetWidget dropDown;
    public static TextField searchField;
    public static Button options;
    public static Button prev;
    public static Button next;
    public static Label pageLabel;
    public static Button more;
    public static Button less;
    public static ItemQuantityField quantity;
    public static SaveLoadButton[] stateButtons;
    public static Button[] deleteButtons;
    public static Button delete;
    public static ButtonCycled gamemode;
    public static Button rain;
    public static Button magnet;
    public static Button[] timeButtons;
    public static Button heal;
    public static HashMap<Integer, LayoutStyle> layoutStyles;

    public static void load() {
        API.addLayoutStyle(0, new LayoutStyleMinecraft());
        API.addLayoutStyle(1, new LayoutStyleTMIOld());
        instance = new LayoutManager();
        KeyManager.trackers.add(instance);
        NEIClientEventHandler.addInputHandler(instance);
        NEIClientEventHandler.addTooltipHandler(instance);
        NEIClientEventHandler.addDrawHandler(instance);
        NEIClientEventHandler.addObjectHandler(instance);
        LayoutManager.init();
    }

    @Override
    public void onMouseClicked(GuiScreen gui, int mouseX, int mouseY, int button) {
        if (NEIClientConfig.isHidden()) {
            return;
        }
        for (Widget widget : controlWidgets) {
            widget.onGuiClick(mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(GuiScreen gui, int mouseX, int mouseY, int button) {
        if (NEIClientConfig.isHidden()) {
            return false;
        }
        if (!NEIClientConfig.isEnabled()) {
            return options.contains(mouseX, mouseY) && options.handleClick(mouseX, mouseY, button);
        }
        for (Widget widget : controlWidgets) {
            widget.onGuiClick(mouseX, mouseY);
            if (!(widget.contains(mouseX, mouseY) ? widget.handleClick(mouseX, mouseY, button) : widget.handleClickExt(mouseX, mouseY, button))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean objectUnderMouse(GuiContainer gui, int mousex, int mousey) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : controlWidgets) {
                if (!widget.contains(mousex, mousey)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyTyped(GuiScreen gui, char keyChar, int keyID) {
        if (NEIClientConfig.isEnabled() && !NEIClientConfig.isHidden()) {
            if (inputFocused != null) {
                return inputFocused.handleKeyPress(keyID, keyChar);
            }
            for (Widget widget : controlWidgets) {
                if (!widget.handleKeyPress(keyID, keyChar)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onKeyTyped(GuiScreen gui, char keyChar, int keyID) {
    }

    @Override
    public boolean lastKeyTyped(GuiScreen gui, char keyChar, int keyID) {
        if (KeyBindings.get("nei.options.keys.gui.hide").isActiveAndMatches(keyID)) {
            NEIClientConfig.toggleBooleanSetting("inventory.hidden");
            return true;
        }
        if (NEIClientConfig.isEnabled() && !NEIClientConfig.isHidden()) {
            for (Widget widget : controlWidgets) {
                if (inputFocused != null) continue;
                widget.lastKeyTyped(keyID, keyChar);
            }
        }
        return false;
    }

    @Override
    public void onMouseUp(GuiScreen gui, int mouseX, int mouseY, int button) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : controlWidgets) {
                widget.mouseUp(mouseX, mouseY, button);
            }
        }
    }

    @Override
    public void onMouseDragged(GuiScreen gui, int mouseX, int mouseY, int button, long heldTime) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : controlWidgets) {
                widget.mouseDragged(mouseX, mouseY, button, heldTime);
            }
        }
    }

    @Override
    public ItemStack getStackUnderMouse(GuiContainer gui, int mousex, int mousey) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : controlWidgets) {
                ItemStack stack = widget.getStackMouseOver(mousex, mousey);
                if (stack.func_190926_b()) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void renderObjects(GuiContainer gui, int mousex, int mousey) {
        if (!NEIClientConfig.isHidden()) {
            LayoutManager.layout(gui);
            if (NEIClientConfig.isEnabled()) {
                LayoutManager.getLayoutStyle().drawBackground(gui);
                for (Widget widget : drawWidgets) {
                    widget.draw(mousex, mousey);
                }
            } else {
                options.draw(mousex, mousey);
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179097_i();
        } else {
            showItemPanel = false;
        }
    }

    @Override
    public void postRenderObjects(GuiContainer gui, int mousex, int mousey) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled()) {
            for (Widget widget : drawWidgets) {
                widget.postDraw(mousex, mousey);
            }
        }
    }

    @Override
    public void handleTooltip(GuiScreen gui, int mousex, int mousey, List<String> currenttip) {
        if (!NEIClientConfig.isHidden() && NEIClientConfig.isEnabled() && GuiHelper.shouldShowTooltip(gui)) {
            for (Widget widget : controlWidgets) {
                widget.handleTooltip(mousex, mousey, currenttip);
            }
        }
    }

    @Override
    public void handleItemDisplayName(GuiScreen gui, ItemStack stack, List<String> currenttip) {
    }

    public static void layout(GuiContainer gui) {
        VisibilityData visiblity = new VisibilityData();
        if (NEIClientConfig.isHidden()) {
            visiblity.showNEI = false;
        }
        if (gui.field_146295_m - gui.getYSize() <= 40) {
            visiblity.showSearchSection = false;
        }
        if (gui.getGuiLeft() - 4 < 76) {
            visiblity.showWidgets = false;
        }
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            handler.modifyVisibility(gui, visiblity);
        }
        visiblity.translateDependancies();
        LayoutManager.getLayoutStyle().layout(gui, visiblity);
        LayoutManager.updateWidgetVisiblities(gui, visiblity);
    }

    private static void init() {
        int i;
        itemPanel = new ItemPanel();
        dropDown = new SubsetWidget();
        searchField = new SearchField("search");
        options = new Button("Options"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientConfig.getOptionList().openGui((GuiScreen)NEIClientUtils.getGuiContainer(), false);
                    return true;
                }
                return false;
            }

            @Override
            public String getRenderLabel() {
                return NEIClientUtils.translate("inventory.options", new Object[0]);
            }
        };
        prev = new Button("Prev"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    itemPanel.scroll(-1);
                    return true;
                }
                return false;
            }

            @Override
            public String getRenderLabel() {
                return NEIClientUtils.translate("inventory.prev", new Object[0]);
            }
        };
        next = new Button("Next"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    itemPanel.scroll(1);
                    return true;
                }
                return false;
            }

            @Override
            public String getRenderLabel() {
                return NEIClientUtils.translate("inventory.next", new Object[0]);
            }
        };
        pageLabel = new Label("(0/0)", true);
        more = new Button("+"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                int modifier = NEIClientUtils.controlKey() ? 64 : (NEIClientUtils.shiftKey() ? 10 : 1);
                int quantity = NEIClientConfig.getItemQuantity() + modifier;
                if (quantity < 0) {
                    quantity = 0;
                }
                NEIClientUtils.setItemQuantity(quantity);
                return true;
            }
        };
        less = new Button("-"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                int modifier = NEIClientUtils.controlKey() ? -64 : (NEIClientUtils.shiftKey() ? -10 : -1);
                int quantity = NEIClientConfig.getItemQuantity() + modifier;
                if (quantity < 0) {
                    quantity = 0;
                }
                NEIClientUtils.setItemQuantity(quantity);
                return true;
            }
        };
        quantity = new ItemQuantityField("quantity");
        stateButtons = new SaveLoadButton[7];
        deleteButtons = new Button[7];
        for (i = 0; i < 7; ++i) {
            final int savestate = i;
            LayoutManager.stateButtons[i] = new SaveLoadButton(""){

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (NEIClientConfig.isStateSaved(savestate)) {
                        NEIClientConfig.loadState(savestate);
                    } else {
                        NEIClientConfig.saveState(savestate);
                    }
                    return true;
                }

                @Override
                public void onTextChange() {
                    NBTTagCompound statelist = NEIClientConfig.global.nbt.func_74775_l("statename");
                    NEIClientConfig.global.nbt.func_74782_a("statename", (NBTBase)statelist);
                    statelist.func_74778_a("" + savestate, this.label);
                    NEIClientConfig.global.saveNBT();
                }
            };
            LayoutManager.deleteButtons[i] = new Button("x"){

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (!rightclick) {
                        NEIClientConfig.clearState(savestate);
                        return true;
                    }
                    return false;
                }
            };
        }
        delete = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if ((this.state & 3) == 2) {
                    return false;
                }
                ItemStack held = NEIClientUtils.getHeldItem();
                if (!held.func_190926_b()) {
                    if (NEIClientUtils.shiftKey()) {
                        NEIClientUtils.deleteHeldItem();
                        NEIClientUtils.deleteItemsOfType(held);
                    } else if (rightclick) {
                        NEIClientUtils.decreaseSlotStack(-999);
                    } else {
                        NEIClientUtils.deleteHeldItem();
                    }
                } else if (NEIClientUtils.shiftKey()) {
                    NEIClientUtils.deleteEverything();
                } else {
                    NEIController.toggleDeleteMode();
                }
                return true;
            }

            @Override
            public String getButtonTip() {
                if ((this.state & 3) != 2) {
                    if (NEIClientUtils.shiftKey()) {
                        return NEIClientUtils.translate("inventory.delete.inv", new Object[0]);
                    }
                    if (NEIController.canUseDeleteMode()) {
                        return LayoutManager.getStateTip("delete", this.state);
                    }
                }
                return null;
            }

            @Override
            public void postDraw(int mousex, int mousey) {
                if (this.contains(mousex, mousey) && !NEIClientUtils.getHeldItem().func_190926_b() && (this.state & 3) != 2) {
                    GuiDraw.drawTip((int)(mousex + 9), (int)mousey, (String)NEIClientUtils.translate("inventory.delete." + (NEIClientUtils.shiftKey() ? "all" : "one"), GuiHelper.itemDisplayNameShort(NEIClientUtils.getHeldItem())));
                }
            }
        };
        gamemode = new ButtonCycled(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientUtils.cycleGamemode();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return NEIClientUtils.translate("inventory.gamemode." + NEIClientUtils.getNextGamemode(), new Object[0]);
            }
        };
        LayoutManager.gamemode.icons = new Rectangle4i[3];
        rain = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (LayoutManager.handleDisabledButtonPress("rain", rightclick)) {
                    return true;
                }
                if (!rightclick) {
                    NEIClientUtils.toggleRaining();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return LayoutManager.getStateTip("rain", this.state);
            }
        };
        magnet = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientUtils.toggleMagnetMode();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return LayoutManager.getStateTip("magnet", this.state);
            }
        };
        for (i = 0; i < 4; ++i) {
            final int zone = i;
            LayoutManager.timeButtons[i] = new Button(){

                @Override
                public boolean onButtonPress(boolean rightclick) {
                    if (LayoutManager.handleDisabledButtonPress(NEIActions.timeZones[zone], rightclick)) {
                        return true;
                    }
                    if (!rightclick) {
                        NEIClientUtils.setHourForward(zone * 6);
                        return true;
                    }
                    return false;
                }

                @Override
                public String getButtonTip() {
                    return LayoutManager.getTimeTip(NEIActions.timeZones[zone], this.state);
                }
            };
        }
        heal = new Button(){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    NEIClientUtils.healPlayer();
                    return true;
                }
                return false;
            }

            @Override
            public String getButtonTip() {
                return NEIClientUtils.translate("inventory.heal", new Object[0]);
            }
        };
        LayoutManager.delete.state |= 4;
        LayoutManager.gamemode.state |= 4;
        LayoutManager.rain.state |= 4;
        LayoutManager.magnet.state |= 4;
    }

    private static String getStateTip(String name, int state) {
        String sfx = (state & 3) == 2 ? "enable" : ((state & 3) == 1 ? "0" : "1");
        return NEIClientUtils.translate("inventory." + name + "." + sfx, new Object[0]);
    }

    private static String getTimeTip(String name, int state) {
        String sfx = (state & 3) == 2 ? "enable" : "set";
        return NEIClientUtils.translate("inventory." + name + "." + sfx, new Object[0]);
    }

    private static boolean handleDisabledButtonPress(String ident, boolean rightclick) {
        if (!NEIActions.canDisable.contains(ident)) {
            return false;
        }
        if (rightclick != NEIClientConfig.disabledActions.contains(ident)) {
            return LayoutManager.setPropertyDisabled(ident, rightclick);
        }
        return false;
    }

    private static boolean setPropertyDisabled(String ident, boolean disable) {
        if (disable && NEIActions.base(ident).equals("time")) {
            int count = 0;
            for (int i = 0; i < 4; ++i) {
                if (!NEIClientConfig.disabledActions.contains(NEIActions.timeZones[i])) continue;
                ++count;
            }
            if (count == 3) {
                return false;
            }
        }
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEIClientPacketHandler.sendActionDisableStateChange(ident, disable);
        }
        return true;
    }

    @Override
    public void load(GuiContainer gui) {
        if (NEIClientConfig.isEnabled()) {
            LayoutManager.setInputFocused(null);
            ItemList.loadItems.restart();
            LayoutManager.getLayoutStyle().init();
            LayoutManager.layout(gui);
        }
        NEIController.load(gui);
        if (this.checkCreativeInv(gui) && gui.field_146297_k.field_71462_r instanceof GuiContainerCreative) {
            gui.field_146297_k.func_147108_a(null);
        }
    }

    @Override
    public void refresh(GuiContainer gui) {
    }

    public boolean checkCreativeInv(GuiContainer gui) {
        if (gui instanceof GuiContainerCreative && NEIClientConfig.invCreativeMode()) {
            NEIClientPacketHandler.sendCreativeInv(true);
            return true;
        }
        if (gui instanceof GuiExtendedCreativeInv && !NEIClientConfig.invCreativeMode()) {
            NEIClientPacketHandler.sendCreativeInv(false);
            return true;
        }
        return false;
    }

    public static void updateWidgetVisiblities(GuiContainer gui, VisibilityData visiblity) {
        HashSet<Widget> newWidgets = new HashSet<Widget>();
        if (!visiblity.showNEI) {
            return;
        }
        newWidgets.add(options);
        showItemPanel = visiblity.showItemPanel;
        if (visiblity.showItemPanel) {
            newWidgets.add(itemPanel);
            newWidgets.add(prev);
            newWidgets.add(next);
            newWidgets.add(pageLabel);
            if (NEIClientConfig.canPerformAction("item")) {
                newWidgets.add(more);
                newWidgets.add(less);
                newWidgets.add(quantity);
            }
        }
        if (visiblity.showSearchSection) {
            newWidgets.add(dropDown);
            newWidgets.add(searchField);
        }
        if (NEIClientConfig.canPerformAction("item") && NEIClientConfig.hasSMPCounterPart() && visiblity.showStateButtons) {
            for (int i = 0; i < 7; ++i) {
                newWidgets.add(stateButtons[i]);
                if (!NEIClientConfig.isStateSaved(i)) continue;
                newWidgets.add(deleteButtons[i]);
            }
        }
        if (visiblity.showUtilityButtons) {
            if (NEIClientConfig.canPerformAction("time")) {
                newWidgets.addAll(Arrays.asList(timeButtons).subList(0, 4));
            }
            if (NEIClientConfig.canPerformAction("rain")) {
                newWidgets.add(rain);
            }
            if (NEIClientConfig.canPerformAction("heal")) {
                newWidgets.add(heal);
            }
            if (NEIClientConfig.canPerformAction("magnet")) {
                newWidgets.add(magnet);
            }
            if (NEIClientUtils.isValidGamemode("creative") || NEIClientUtils.isValidGamemode("creative+") || NEIClientUtils.isValidGamemode("adventure")) {
                newWidgets.add(gamemode);
            }
            if (NEIClientConfig.canPerformAction("delete")) {
                newWidgets.add(delete);
            }
        }
        TreeSet<Widget> newDrawWidgets = new TreeSet<Widget>(new WidgetZOrder(false));
        TreeSet<Widget> newControlWidgets = new TreeSet<Widget>(new WidgetZOrder(true));
        newDrawWidgets.addAll(newWidgets);
        newControlWidgets.addAll(newWidgets);
        drawWidgets = newDrawWidgets;
        controlWidgets = newControlWidgets;
    }

    public static LayoutStyle getLayoutStyle(int id) {
        LayoutStyle style = layoutStyles.get(id);
        if (style == null) {
            style = layoutStyles.get(0);
        }
        return style;
    }

    public static LayoutStyle getLayoutStyle() {
        return LayoutManager.getLayoutStyle(NEIClientConfig.getLayoutStyle());
    }

    @Deprecated
    private static void addWidget(Widget widget) {
        drawWidgets.add(widget);
        controlWidgets.add(widget);
    }

    @Override
    public void guiTick(GuiContainer gui) {
        if (this.checkCreativeInv(gui)) {
            return;
        }
        if (!NEIClientConfig.isEnabled()) {
            return;
        }
        for (Widget widget : controlWidgets) {
            widget.update();
        }
    }

    @Override
    public boolean mouseScrolled(GuiScreen gui, int mouseX, int mouseY, int scrolled) {
        if (NEIClientConfig.isHidden() || !NEIClientConfig.isEnabled()) {
            return false;
        }
        for (Widget widget : controlWidgets) {
            if (!widget.onMouseWheel(scrolled, mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldShowTooltip(GuiScreen gui) {
        return LayoutManager.itemPanel.draggedStack.func_190926_b() && gui instanceof GuiContainer;
    }

    public static Widget getInputFocused() {
        return inputFocused;
    }

    public static void setInputFocused(Widget widget) {
        if (inputFocused != null) {
            inputFocused.loseFocus();
        }
        if ((inputFocused = widget) != null) {
            inputFocused.gainFocus();
        }
    }

    @Override
    public void renderSlotOverlay(GuiContainer window, Slot slot) {
        ItemStack item = slot.func_75211_c();
        if (NEIClientConfig.world.nbt.func_74767_n("searchinventories") && (item == null ? !NEIClientConfig.getSearchExpression().equals("") : !ItemList.getItemListFilter().matches(item))) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)350.0f);
            GuiDraw.drawRect((int)slot.field_75223_e, (int)slot.field_75221_f, (int)16, (int)16, (int)Integer.MIN_VALUE);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-350.0f);
            GlStateManager.func_179145_e();
        }
    }

    public static void drawIcon(int x, int y, Rectangle4i image) {
        TextureUtils.changeTexture((String)"nei:textures/nei_sprites.png");
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)image.x, (int)image.y, (int)image.w, (int)image.h);
        GlStateManager.func_179084_k();
    }

    public static void drawButtonBackground(int x, int y, int w, int h, boolean edges, int type) {
        int wtiles = 0;
        int ew = w;
        if (w / 2 > 100) {
            wtiles = (w - 200) / 50 + 1;
            ew = 200;
        }
        int w1 = ew / 2;
        int h1 = h / 2;
        int w2 = (ew + 1) / 2;
        int h2 = (h + 1) / 2;
        int x2 = x + w - w2;
        int y2 = y + h - h2;
        int ty = 46 + type * 20;
        int te = edges ? 0 : 1;
        int ty1 = ty + te;
        int tx1 = te;
        int tx3 = 75;
        int ty2 = ty + 20 - h2 - te;
        int tx2 = 200 - w2 - te;
        TextureUtils.changeTexture((String)"textures/gui/widgets.png");
        GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)tx1, (int)ty1, (int)w1, (int)h1);
        GuiDraw.drawTexturedModalRect((int)x, (int)y2, (int)tx1, (int)ty2, (int)w1, (int)h2);
        for (int tile = 0; tile < wtiles; ++tile) {
            int tilex = x + w1 + 50 * tile;
            GuiDraw.drawTexturedModalRect((int)tilex, (int)y, (int)tx3, (int)ty1, (int)50, (int)h1);
            GuiDraw.drawTexturedModalRect((int)tilex, (int)y2, (int)tx3, (int)ty2, (int)50, (int)h2);
        }
        GuiDraw.drawTexturedModalRect((int)x2, (int)y, (int)tx2, (int)ty1, (int)w2, (int)h1);
        GuiDraw.drawTexturedModalRect((int)x2, (int)y2, (int)tx2, (int)ty2, (int)w2, (int)h2);
    }

    public static LayoutManager instance() {
        return instance;
    }

    @Override
    public void tickKeyStates() {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if (KeyBindings.get("nei.options.keys.world.dawn").func_151468_f()) {
            timeButtons[0].onButtonPress(false);
        }
        if (KeyBindings.get("nei.options.keys.world.noon").func_151468_f()) {
            timeButtons[1].onButtonPress(false);
        }
        if (KeyBindings.get("nei.options.keys.world.dusk").func_151468_f()) {
            timeButtons[2].onButtonPress(false);
        }
        if (KeyBindings.get("nei.options.keys.world.midnight").func_151468_f()) {
            timeButtons[3].onButtonPress(false);
        }
        if (KeyBindings.get("nei.options.keys.world.rain").func_151468_f()) {
            rain.onButtonPress(false);
        }
        if (KeyBindings.get("nei.options.keys.world.heal").func_151468_f()) {
            heal.onButtonPress(false);
        }
        if (KeyBindings.get("nei.options.keys.world.creative").func_151468_f()) {
            gamemode.onButtonPress(false);
        }
    }

    public static boolean isItemPanelActive() {
        return showItemPanel;
    }

    static {
        drawWidgets = new TreeSet<Widget>(new WidgetZOrder(false));
        controlWidgets = new TreeSet<Widget>(new WidgetZOrder(true));
        timeButtons = new Button[4];
        layoutStyles = new HashMap();
    }
}

