/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.handler;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.PlayerSave;
import codechicken.nei.network.NEIServerPacketHandler;
import codechicken.nei.util.NEIClientUtils;
import codechicken.nei.util.NEIServerUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MagnetModeHandler {
    public static final MagnetModeHandler INSTANCE = new MagnetModeHandler();
    private List<EntityItem> clientMagnetItems = new ArrayList<EntityItem>();
    public static final float DISTANCE_XZ = 16.0f;
    public static final float DISTANCE_Y = 8.0f;
    public static final double MAX_SPEED_XZ = 0.5;
    public static final double MAX_SPEED_Y = 0.5;
    public static final double SPEED_XZ = 0.05;
    public static final double SPEED_Y = 0.07;

    public void trackMagnetItem(int entityID, World world) {
        Entity e = world.func_73045_a(entityID);
        if (e instanceof EntityItem) {
            this.clientMagnetItems.add((EntityItem)e);
        }
    }

    public void nukeClientMagnetTracker() {
        this.clientMagnetItems.clear();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END || Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        if (!NEIClientConfig.isMagnetModeEnabled()) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Iterator<EntityItem> iterator = this.clientMagnetItems.iterator();
        while (iterator.hasNext()) {
            double rationspeedy;
            EntityItem item = iterator.next();
            if (item.func_174874_s()) continue;
            if (item.field_70128_L) {
                iterator.remove();
            }
            if (!NEIClientUtils.canItemFitInInventory((EntityPlayer)player, item.func_92059_d())) continue;
            double dx = player.field_70165_t - item.field_70165_t;
            double dy = player.field_70163_u + (double)player.func_70047_e() - item.field_70163_u;
            double dz = player.field_70161_v - item.field_70161_v;
            double absxz = Math.sqrt(dx * dx + dz * dz);
            double absy = Math.abs(dy);
            if (absxz > 16.0 || absy > 8.0) continue;
            if (absxz > 1.0) {
                dx /= absxz;
                dz /= absxz;
            }
            if (absy > 1.0) {
                dy /= absy;
            }
            double vx = item.field_70159_w + 0.05 * dx;
            double vy = item.field_70181_x + 0.07 * dy;
            double vz = item.field_70179_y + 0.05 * dz;
            double absvxz = Math.sqrt(vx * vx + vz * vz);
            double absvy = Math.abs(vy);
            double rationspeedxz = absvxz / 0.5;
            if (rationspeedxz > 1.0) {
                vx /= rationspeedxz;
                vz /= rationspeedxz;
            }
            if ((rationspeedy = absvy / 0.5) > 1.0) {
                vy /= rationspeedy;
            }
            if (absvxz < 0.2 && absxz < 0.2) {
                item.func_70106_y();
            }
            item.func_70016_h(vx, vy, vz);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void tickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            PlayerSave save = NEIServerConfig.getSaveForPlayer(player.func_70005_c_());
            if (save == null) {
                return;
            }
            if (!save.isActionEnabled("magnet") || player.field_70128_L) {
                return;
            }
            List items = player.field_70170_p.func_72872_a(EntityItem.class, player.func_174813_aQ().func_72314_b(16.0, 8.0, 16.0));
            for (EntityItem item : items) {
                if (item.func_174874_s() || !NEIServerUtils.canItemFitInInventory((EntityPlayer)player, item.func_92059_d())) continue;
                if (save.magneticItems.add(item)) {
                    NEIServerPacketHandler.sendTrackedMagnetItem(player, item);
                }
                double dx = player.field_70165_t - item.field_70165_t;
                double dy = player.field_70163_u + (double)player.func_70047_e() - item.field_70163_u;
                double dz = player.field_70161_v - item.field_70161_v;
                double absxz = Math.sqrt(dx * dx + dz * dz);
                double absy = Math.abs(dy);
                if (absxz > 16.0) continue;
                if (absxz < 1.0) {
                    item.func_70100_b_((EntityPlayer)player);
                }
                if (absxz > 1.0) {
                    dx /= absxz;
                    dz /= absxz;
                }
                if (absy > 1.0) {
                    dy /= absy;
                }
                double vx = item.field_70159_w + 0.05 * dx;
                double vy = item.field_70181_x + 0.07 * dy;
                double vz = item.field_70179_y + 0.05 * dz;
                double absvxz = Math.sqrt(vx * vx + vz * vz);
                double absvy = Math.abs(vy);
                double rationspeedxz = absvxz / 0.5;
                if (rationspeedxz > 1.0) {
                    vx /= rationspeedxz;
                    vz /= rationspeedxz;
                }
                double rationspeedy = absvy / 0.5;
                if (absvy > 1.0) {
                    vy /= rationspeedy;
                }
                item.field_70159_w = vx;
                item.field_70181_x = vy;
                item.field_70179_y = vz;
            }
        }
    }
}

