/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.util.helper.potion;

import codechicken.nei.util.LogHelper;
import codechicken.nei.util.helper.potion.IPotionRecipe;
import codechicken.nei.util.helper.potion.PotionTypeRecipe;
import codechicken.nei.util.helper.potion.PotionUpgradeRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;

public class PotionRecipeHelper {
    private static ArrayList<IPotionRecipe> allRecipes = new ArrayList();
    private static ArrayList<IPotionRecipe> normalRecipes = new ArrayList();
    private static ArrayList<IPotionRecipe> splashRecipes = new ArrayList();
    private static ArrayList<IPotionRecipe> lingeringRecipes = new ArrayList();

    public static void addNormalRecipe(Item potionItem, PotionType input, Ingredient ingredient, PotionType output) {
        PotionTypeRecipe recipe = new PotionTypeRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack(potionItem), (PotionType)input), ingredient, output);
        normalRecipes.add(recipe);
        allRecipes.add(recipe);
    }

    public static void addNormalRecipe(IPotionRecipe recipe) {
        normalRecipes.add(recipe);
    }

    public static void addSplashRecipe(Item potionItem, PotionType input, Ingredient ingredient, PotionType output) {
        PotionTypeRecipe recipe = new PotionTypeRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack(potionItem), (PotionType)input), ingredient, output);
        splashRecipes.add(recipe);
        allRecipes.add(recipe);
    }

    public static void addSplashRecipe(IPotionRecipe recipe) {
        splashRecipes.add(recipe);
    }

    public static void addLingeringRecipe(Item potionItem, PotionType input, Ingredient ingredient, PotionType output) {
        PotionTypeRecipe recipe = new PotionTypeRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack(potionItem), (PotionType)input), ingredient, output);
        lingeringRecipes.add(recipe);
        allRecipes.add(recipe);
    }

    public static void addLingeringRecipe(IPotionRecipe recipe) {
        lingeringRecipes.add(recipe);
    }

    public static void init() {
        LogHelper.trace("Loading portion recipes..");
        try {
            PotionUpgradeRecipe upgradeRecipe;
            for (PotionHelper.MixPredicate entry : PotionHelper.field_185213_a) {
                PotionType input = (PotionType)entry.field_185198_a;
                Ingredient ingredient = entry.field_185199_b;
                PotionType output = (PotionType)entry.field_185200_c;
                PotionRecipeHelper.addNormalRecipe((Item)Items.field_151068_bn, input, ingredient, output);
                PotionRecipeHelper.addSplashRecipe((Item)Items.field_185155_bH, input, ingredient, output);
                PotionRecipeHelper.addLingeringRecipe((Item)Items.field_185156_bI, input, ingredient, output);
            }
            for (IPotionRecipe recipe : normalRecipes) {
                upgradeRecipe = new PotionUpgradeRecipe(recipe.getRecipeOutput(), Ingredient.func_193368_a((Item[])new Item[]{Items.field_151016_H}), (Item)Items.field_185155_bH);
                allRecipes.add(upgradeRecipe);
            }
            for (IPotionRecipe recipe : splashRecipes) {
                upgradeRecipe = new PotionUpgradeRecipe(recipe.getRecipeOutput(), Ingredient.func_193368_a((Item[])new Item[]{Items.field_185157_bK}), (Item)Items.field_185156_bI);
                allRecipes.add(upgradeRecipe);
            }
        }
        catch (Exception e) {
            LogHelper.error("Unable to load potion recipes!");
            e.printStackTrace();
        }
    }

    public static List<IPotionRecipe> getRecipes() {
        return allRecipes;
    }

    public static PotionType getPotionTypeFromStack(ItemStack itemStack) {
        String potion;
        PotionType type;
        NBTTagCompound tagCompound;
        if (itemStack.func_77942_o() && (tagCompound = itemStack.func_77978_p()).func_74764_b("Potion") && (type = PotionType.func_185168_a((String)(potion = tagCompound.func_74779_i("Potion")))) != null) {
            return type;
        }
        return null;
    }
}

