/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc;

import java.util.Arrays;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.damage.CapabilityDamageResistance;
import net.dries007.tfc.api.capability.damage.DamageType;
import net.dries007.tfc.api.capability.egg.CapabilityEgg;
import net.dries007.tfc.api.capability.egg.EggHandler;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodData;
import net.dries007.tfc.api.capability.food.FoodHandler;
import net.dries007.tfc.api.capability.food.FoodStatsTFC;
import net.dries007.tfc.api.capability.food.IFoodStatsTFC;
import net.dries007.tfc.api.capability.food.IItemFoodTFC;
import net.dries007.tfc.api.capability.forge.CapabilityForgeable;
import net.dries007.tfc.api.capability.forge.ForgeableHeatableHandler;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.capability.metal.CapabilityMetalItem;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.capability.player.IPlayerData;
import net.dries007.tfc.api.capability.player.PlayerDataHandler;
import net.dries007.tfc.api.capability.size.CapabilityItemSize;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.capability.worldtracker.CapabilityWorldTracker;
import net.dries007.tfc.api.capability.worldtracker.WorldTracker;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.ICreatureTFC;
import net.dries007.tfc.api.types.IPredator;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.compat.patchouli.TFCPatchouliPlugin;
import net.dries007.tfc.network.PacketCalendarUpdate;
import net.dries007.tfc.network.PacketPlayerDataUpdate;
import net.dries007.tfc.objects.blocks.BlockFluidTFC;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.devices.BlockQuern;
import net.dries007.tfc.objects.blocks.metal.BlockAnvilTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockRaw;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.blocks.stone.BlockStoneAnvil;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.objects.blocks.wood.BlockSupport;
import net.dries007.tfc.objects.container.CapabilityContainerListener;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.items.ItemQuiver;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.objects.potioneffects.PotionEffectsTFC;
import net.dries007.tfc.util.DamageSourcesTFC;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.MonsterEquipment;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.CalendarWorldData;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.util.skills.SmithingSkill;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.GameRuleChangeEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="tfc")
public final class CommonEventHandler {
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";

    @SubscribeEvent
    public static void onEntityUseItem(LivingEntityUseItemEvent.Finish event) {
        EntityPlayerMP player;
        ItemStack usedItem = event.getItem();
        if ((usedItem.func_77973_b() == Items.field_151117_aB || PotionUtils.func_185191_c((ItemStack)usedItem) == PotionTypes.field_185230_b) && event.getEntityLiving() instanceof EntityPlayerMP && (player = (EntityPlayerMP)event.getEntityLiving()).func_71024_bL() instanceof FoodStatsTFC) {
            ((FoodStatsTFC)player.func_71024_bL()).addThirst(40.0f);
        }
    }

    @SubscribeEvent
    public static void breakEvent(BlockEvent.BreakEvent event) {
        IPlayerData cap;
        EntityPlayer player = event.getPlayer();
        ItemStack heldItem = player == null ? ItemStack.field_190927_a : player.func_184614_ca();
        IBlockState state = event.getState();
        Block block = state.func_177230_c();
        if (player != null && (cap = (IPlayerData)player.getCapability(CapabilityPlayerData.CAPABILITY, null)) != null) {
            cap.setHarvestingTool(player.func_184614_ca());
        }
    }

    @SubscribeEvent
    public static void onBlockHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        ItemStack stackAt;
        EntityPlayer player = event.getHarvester();
        ItemStack heldItem = player == null ? ItemStack.field_190927_a : player.func_184614_ca();
        IBlockState state = event.getState();
        Block block = state.func_177230_c();
        if (!event.isSilkTouching() && block instanceof BlockLeaves) {
            double chance = ConfigTFC.General.TREE.leafStickDropChance;
            if (!heldItem.func_190926_b() && Helpers.containsAnyOfCaseInsensitive(heldItem.func_77973_b().getToolClasses(heldItem), ConfigTFC.General.TREE.leafStickDropChanceBonusClasses)) {
                chance = ConfigTFC.General.TREE.leafStickDropChanceBonus;
            }
            if ((double)Constants.RNG.nextFloat() < chance) {
                event.getDrops().add(new ItemStack(Items.field_151055_y));
            }
        }
        if (OreDictionaryHelper.doesStackMatchOre(stackAt = new ItemStack(Item.func_150898_a((Block)state.func_177230_c()), 1, state.func_177230_c().func_180651_a(state)), "blockGlass")) {
            event.getDrops().add(new ItemStack(ItemsTFC.GLASS_SHARD));
        }
        if (player != null) {
            float skillModifier;
            ItemStack tool = ItemStack.field_190927_a;
            IPlayerData cap = (IPlayerData)player.getCapability(CapabilityPlayerData.CAPABILITY, null);
            if (cap != null) {
                tool = cap.getHarvestingTool();
            }
            if (!tool.func_190926_b() && (skillModifier = SmithingSkill.getSkillBonus(tool, SmithingSkill.Type.TOOLS) / 2.0f) > 0.0f && Constants.RNG.nextFloat() < skillModifier) {
                player.func_184611_a(EnumHand.MAIN_HAND, tool);
            }
        }
    }

    @SubscribeEvent
    public static void onBreakProgressEvent(PlayerEvent.BreakSpeed event) {
        ItemStack stack;
        float skillModifier;
        EntityPlayer player = event.getEntityPlayer();
        if (player != null && (skillModifier = SmithingSkill.getSkillBonus(stack = player.func_184614_ca(), SmithingSkill.Type.TOOLS)) > 0.0f) {
            event.setNewSpeed(event.getNewSpeed() + event.getNewSpeed() * skillModifier);
        }
        if (event.getState().func_177230_c() instanceof BlockRockVariant) {
            event.setNewSpeed((float)((double)event.getNewSpeed() / ConfigTFC.General.MISC.rockMiningTimeModifier));
        }
        if (event.getState().func_177230_c() instanceof BlockLogTFC) {
            event.setNewSpeed((float)((double)event.getNewSpeed() / ConfigTFC.General.MISC.logMiningTimeModifier));
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = event.getItemStack();
        EntityPlayer player = event.getEntityPlayer();
        if (state.func_177230_c() instanceof BlockAnvilTFC || state.func_177230_c() instanceof BlockStoneAnvil || state.func_177230_c() instanceof BlockQuern || state.func_177230_c() instanceof BlockSupport) {
            event.setUseBlock(Event.Result.ALLOW);
        }
        if (!player.func_184812_l_() && stack.func_190926_b() && player.func_71024_bL() instanceof IFoodStatsTFC && event.getHand() == EnumHand.MAIN_HAND) {
            IFoodStatsTFC foodStats = (IFoodStatsTFC)player.func_71024_bL();
            RayTraceResult result = Helpers.rayTrace(event.getWorld(), player, true);
            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState waterState = world.func_180495_p(result.func_178782_a());
                boolean isFreshWater = BlocksTFC.isFreshWater(waterState);
                boolean isSaltWater = BlocksTFC.isSaltWater(waterState);
                if (isFreshWater && foodStats.attemptDrink(10.0f, true) || isSaltWater && foodStats.attemptDrink(-1.0f, true)) {
                    if (!world.field_72995_K) {
                        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187664_bz, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        if (isFreshWater) {
                            foodStats.attemptDrink(10.0f, false);
                        } else {
                            foodStats.attemptDrink(-1.0f, false);
                        }
                    } else {
                        foodStats.resetCooldown();
                    }
                    event.setCancellationResult(EnumActionResult.SUCCESS);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onUseHoe(UseHoeEvent event) {
        BlockRockVariant blockRock;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        if (ConfigTFC.General.OVERRIDES.enableHoeing && state.func_177230_c() instanceof BlockRockVariant && ((blockRock = (BlockRockVariant)state.func_177230_c()).getType() == Rock.Type.GRASS || blockRock.getType() == Rock.Type.DIRT)) {
            if (!world.field_72995_K) {
                world.func_184133_a(null, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_175656_a(pos, BlockRockVariant.get(blockRock.getRock(), Rock.Type.FARMLAND).func_176223_P());
            }
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        EntityPlayer player;
        EntityLivingBase damager;
        ItemStack stack;
        float skillModifier;
        float actualDamage = event.getAmount();
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityLivingBase && (skillModifier = SmithingSkill.getSkillBonus(stack = (damager = (EntityLivingBase)entity).func_184614_ca(), SmithingSkill.Type.WEAPONS)) > 0.0f) {
            actualDamage *= 1.0f + skillModifier / 2.0f;
        }
        actualDamage *= DamageType.getModifier(event.getSource(), event.getEntityLiving());
        if (event.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntityLiving()).func_71024_bL() instanceof IFoodStatsTFC) {
            float healthModifier = ((IFoodStatsTFC)player.func_71024_bL()).getHealthModifier();
            if ((double)healthModifier < ConfigTFC.General.PLAYER.minHealthModifier) {
                healthModifier = (float)ConfigTFC.General.PLAYER.minHealthModifier;
            }
            if ((double)healthModifier > ConfigTFC.General.PLAYER.maxHealthModifier) {
                healthModifier = (float)ConfigTFC.General.PLAYER.maxHealthModifier;
            }
            actualDamage /= healthModifier;
        }
        event.setAmount(actualDamage);
    }

    @SubscribeEvent
    public static void attachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        Item item = stack.func_77973_b();
        if (!stack.func_190926_b()) {
            ICapabilityProvider damageResistance;
            ICapabilityProvider heatHandler;
            ICapabilityProvider metalCapability;
            Object foodHandler;
            if (CapabilityItemSize.getIItemSize(stack) == null) {
                int prevStackSize;
                ICapabilityProvider sizeHandler = CapabilityItemSize.getCustomSize(stack);
                event.addCapability(CapabilityItemSize.KEY, sizeHandler);
                if (sizeHandler instanceof IItemSize && (prevStackSize = stack.func_77976_d()) != 1) {
                    item.func_77625_d(((IItemSize)sizeHandler).getStackSize(stack));
                }
            }
            if ((foodHandler = CapabilityFood.getCustomFood(stack)) != null || stack.func_77973_b() instanceof ItemFood) {
                if (stack.func_77973_b() instanceof IItemFoodTFC) {
                    foodHandler = ((IItemFoodTFC)stack.func_77973_b()).getCustomFoodHandler();
                }
                if (foodHandler == null) {
                    foodHandler = new FoodHandler(stack.func_77978_p(), new FoodData());
                }
                event.addCapability(CapabilityFood.KEY, foodHandler);
            }
            ICapabilityProvider forgeHandler = CapabilityForgeable.getCustomForgeable(stack);
            boolean isForgeable = false;
            boolean isHeatable = false;
            if (forgeHandler != null) {
                isForgeable = true;
                event.addCapability(CapabilityForgeable.KEY, forgeHandler);
                isHeatable = forgeHandler instanceof IItemHeat;
            }
            if ((metalCapability = CapabilityMetalItem.getCustomMetalItem(stack)) != null) {
                IMetalItem cap;
                Metal metal;
                event.addCapability(CapabilityMetalItem.KEY, metalCapability);
                if (!isForgeable && (metal = (cap = (IMetalItem)metalCapability).getMetal(stack)) != null) {
                    event.addCapability(CapabilityForgeable.KEY, (ICapabilityProvider)new ForgeableHeatableHandler(null, metal.getSpecificHeat(), metal.getMeltTemp()));
                    isHeatable = true;
                }
            }
            if (!isHeatable && (heatHandler = CapabilityItemHeat.getCustomHeat(stack)) != null) {
                event.addCapability(CapabilityItemHeat.KEY, heatHandler);
            }
            if (item instanceof ItemArmor && (damageResistance = CapabilityDamageResistance.getCustomDamageResistance(stack)) != null) {
                event.addCapability(CapabilityDamageResistance.KEY, damageResistance);
            }
            if (stack.func_77973_b() == Items.field_151110_aK) {
                event.addCapability(CapabilityEgg.KEY, (ICapabilityProvider)new EggHandler());
            }
        }
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        EntityPlayer player;
        if (event.getObject() instanceof EntityPlayer && !(player = (EntityPlayer)event.getObject()).hasCapability(CapabilityPlayerData.CAPABILITY, null)) {
            event.addCapability(CapabilityPlayerData.KEY, (ICapabilityProvider)new PlayerDataHandler(player));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            IPlayerData playerData;
            NBTTagCompound nbt;
            MinecraftServer server;
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            CapabilityContainerListener.addTo(player.field_71069_bz, player);
            FoodStatsTFC.replaceFoodStats((EntityPlayer)player);
            if (player.func_71024_bL() instanceof IFoodStatsTFC && (server = player.field_70170_p.func_73046_m()) != null && (nbt = server.func_184103_al().getPlayerNBT(player)) != null) {
                player.field_71100_bB.func_75112_a(nbt);
            }
            if ((playerData = (IPlayerData)player.getCapability(CapabilityPlayerData.CAPABILITY, null)) != null) {
                if (Loader.isModLoaded((String)"patchouli") && !playerData.hasBook() && ConfigTFC.General.MISC.giveBook) {
                    TFCPatchouliPlugin.giveBookToPlayer((EntityPlayer)player);
                    playerData.setHasBook(true);
                }
                TerraFirmaCraft.getNetwork().sendTo((IMessage)new PacketPlayerDataUpdate((NBTTagCompound)playerData.serializeNBT()), player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            CapabilityContainerListener.removeFrom((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            CapabilityContainerListener.addTo(player.field_71069_bz, player);
            FoodStatsTFC.replaceFoodStats((EntityPlayer)player);
            IPlayerData cap = (IPlayerData)player.getCapability(CapabilityPlayerData.CAPABILITY, null);
            if (cap != null) {
                if (Loader.isModLoaded((String)"patchouli") && !event.isEndConquered() && !player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && ConfigTFC.General.MISC.giveBook) {
                    TFCPatchouliPlugin.giveBookToPlayer((EntityPlayer)player);
                    cap.setHasBook(true);
                }
                TerraFirmaCraft.getNetwork().sendTo((IMessage)new PacketPlayerDataUpdate((NBTTagCompound)cap.serializeNBT()), player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            IPlayerData newSkills = (IPlayerData)player.getCapability(CapabilityPlayerData.CAPABILITY, null);
            IPlayerData originalSkills = (IPlayerData)event.getOriginal().getCapability(CapabilityPlayerData.CAPABILITY, null);
            if (newSkills != null && originalSkills != null) {
                newSkills.deserializeNBT(originalSkills.serializeNBT());
            }
        }
    }

    @SubscribeEvent
    public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            CapabilityContainerListener.addTo(player.field_71069_bz, player);
            FoodStatsTFC.replaceFoodStats((EntityPlayer)player);
            IPlayerData skills = (IPlayerData)player.getCapability(CapabilityPlayerData.CAPABILITY, null);
            if (skills != null) {
                TerraFirmaCraft.getNetwork().sendTo((IMessage)new PacketPlayerDataUpdate((NBTTagCompound)skills.serializeNBT()), player);
            }
        }
    }

    @SubscribeEvent
    public static void onContainerOpen(PlayerContainerEvent.Open event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            CapabilityContainerListener.addTo(event.getContainer(), (EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public static void onLivingSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        World world = event.getWorld();
        BlockPos pos = new BlockPos((double)event.getX(), (double)event.getY(), (double)event.getZ());
        if (world.func_175624_G() == TerraFirmaCraft.getWorldType() && event.getWorld().field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            int maxY;
            int minY;
            ChunkDataTFC data;
            if (ConfigTFC.General.SPAWN_PROTECTION.preventMobs && event.getEntity().isCreatureType(EnumCreatureType.MONSTER, false)) {
                data = ChunkDataTFC.get(event.getWorld(), pos);
                minY = ConfigTFC.General.SPAWN_PROTECTION.minYMobs;
                maxY = ConfigTFC.General.SPAWN_PROTECTION.maxYMobs;
                if (data.isSpawnProtected() && minY <= maxY && event.getY() >= (float)minY && event.getY() <= (float)maxY) {
                    event.setResult(Event.Result.DENY);
                }
            }
            if (ConfigTFC.General.SPAWN_PROTECTION.preventPredators && event.getEntity() instanceof IPredator) {
                data = ChunkDataTFC.get(event.getWorld(), pos);
                minY = ConfigTFC.General.SPAWN_PROTECTION.minYPredators;
                maxY = ConfigTFC.General.SPAWN_PROTECTION.maxYPredators;
                if (data.isSpawnProtected() && minY <= maxY && event.getY() >= (float)minY && event.getY() <= (float)maxY) {
                    event.setResult(Event.Result.DENY);
                }
            }
            if (event.getEntity() instanceof EntitySquid && world.func_180495_p(pos).func_177230_c() instanceof BlockFluidTFC) {
                Fluid fluid = ((BlockFluidTFC)world.func_180495_p(pos).func_177230_c()).getFluid();
                if (FluidsTFC.SALT_WATER.get() != fluid) {
                    event.setResult(Event.Result.DENY);
                }
            }
            if (event.getEntity() instanceof ICreatureTFC) {
                ICreatureTFC creature = (ICreatureTFC)event.getEntity();
                float rainfall = ChunkDataTFC.getRainfall(world, pos);
                float temperature = ClimateTFC.getAvgTemp(world, pos);
                float floraDensity = ChunkDataTFC.getFloraDensity(world, pos);
                float floraDiversity = ChunkDataTFC.getFloraDiversity(world, pos);
                Biome biome = world.func_180494_b(pos);
                if (creature.getSpawnWeight(biome, temperature, rainfall, floraDensity, floraDiversity) <= 0) {
                    event.setResult(Event.Result.DENY);
                }
            }
            if (ConfigTFC.General.DIFFICULTY.preventMobsOnSurface && Helpers.shouldPreventOnSurface(event.getEntity())) {
                int maximumY = 127;
                if (pos.func_177956_o() >= maximumY || world.func_175678_i(pos)) {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
        if (event.getWorld().func_180495_p(pos).func_177230_c() == BlocksTFC.THATCH || event.getWorld().func_180495_p(pos.func_177984_a()).func_177230_c() == BlocksTFC.THATCH) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        EntityItem entityItem;
        ItemStack stack2;
        IItemHeat heatCap;
        Entity entity = event.getEntity();
        if (event.getWorld().func_175624_G() == TerraFirmaCraft.getWorldType() && event.getWorld().field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            MonsterEquipment equipment;
            Entity rider;
            if (entity instanceof EntityMob && entity.func_184218_aH() && (rider = entity.func_184187_bx()) instanceof EntityChicken) {
                entity.func_184174_b(false);
                entity.func_70106_y();
                rider.func_184174_b(false);
                rider.func_70106_y();
                event.setCanceled(true);
            }
            if (entity instanceof EntityChicken) {
                entity.func_184174_b(false);
                entity.func_70106_y();
                event.setCanceled(true);
            }
            if (ConfigTFC.General.OVERRIDES.forceReplaceVanillaAnimals && Helpers.isVanillaAnimal(entity)) {
                Entity TFCReplacement = Helpers.getTFCReplacement(entity);
                if (TFCReplacement != null) {
                    TFCReplacement.func_70080_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                    event.getWorld().func_72838_d(TFCReplacement);
                }
                event.setCanceled(true);
            }
            if (ConfigTFC.General.DIFFICULTY.giveVanillaMobsEquipment && (equipment = MonsterEquipment.get(entity)) != null) {
                for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                    equipment.getEquipment(slot, Constants.RNG).ifPresent(stack -> entity.func_184201_a(slot, stack));
                }
            }
        }
        if (ConfigTFC.Devices.TEMPERATURE.coolHeatablesInWorld && entity instanceof EntityItem && (heatCap = (IItemHeat)(stack2 = (entityItem = (EntityItem)entity).func_92059_d()).getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null)) != null) {
            entityItem.func_184211_a("TFCHeatableItem");
            entityItem.lifespan = ConfigTFC.Devices.TEMPERATURE.ticksBeforeAttemptToCool;
        }
    }

    @SubscribeEvent
    public static void onItemEntityExpire(ItemExpireEvent event) {
        IItemHeat heatCap;
        EntityItem entityItem = event.getEntityItem();
        ItemStack stack = entityItem.func_92059_d();
        if (ConfigTFC.Devices.TEMPERATURE.coolHeatablesInWorld && entityItem.func_184216_O().contains("TFCHeatableItem") && (heatCap = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null)) != null) {
            int lifespan = stack.func_77973_b().getEntityLifespan(stack, entityItem.field_70170_p);
            if (entityItem.lifespan >= lifespan) {
                return;
            }
            float itemTemp = heatCap.getTemperature();
            if (itemTemp > 0.0f) {
                float rand = Constants.RNG.nextFloat();
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos((int)entityItem.field_70165_t, (int)entityItem.field_70163_u, (int)entityItem.field_70161_v);
                IBlockState state = entityItem.field_70170_p.func_180495_p((BlockPos)pos);
                if (state.func_177230_c() instanceof BlockFluidBase) {
                    int fluidTemp = ((BlockFluidBase)state.func_177230_c()).getFluid().getTemperature();
                    if (fluidTemp <= 300) {
                        heatCap.setTemperature(Math.max(0.0f, Math.min(itemTemp, itemTemp - 350.0f + (float)fluidTemp)));
                        entityItem.field_70170_p.func_184133_a(null, (BlockPos)pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 0.8f + rand * 0.4f);
                        ((WorldServer)entityItem.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, 42, 0.0, 0.15, 0.0, 0.08, new int[0]);
                        if (rand <= 0.001f) {
                            entityItem.field_70170_p.func_180501_a((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), 2);
                        }
                    }
                    event.setExtraLife(ConfigTFC.Devices.TEMPERATURE.ticksBeforeAttemptToCool);
                    event.setCanceled(true);
                    entityItem.func_174868_q();
                    return;
                }
                if (state.func_177227_a().contains(BlockSnow.field_176315_a)) {
                    heatCap.setTemperature(Math.max(0.0f, itemTemp - 70.0f));
                    entityItem.field_70170_p.func_184133_a(null, (BlockPos)pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.55f, 0.8f + rand * 0.4f);
                    ((WorldServer)entityItem.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, 42, 0.0, 0.15, 0.0, 0.08, new int[0]);
                    if (rand <= 0.1f) {
                        if ((Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a) > 1) {
                            entityItem.field_70170_p.func_180501_a((BlockPos)pos, state.func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a) - 1)), 2);
                        } else {
                            entityItem.field_70170_p.func_180501_a((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), 2);
                        }
                    }
                }
                pos.func_185336_p(pos.func_177956_o() - 1);
                state = entityItem.field_70170_p.func_180495_p((BlockPos)pos);
                if (state.func_185904_a() == Material.field_151597_y || state.func_185904_a() == Material.field_151596_z) {
                    heatCap.setTemperature(Math.max(0.0f, itemTemp - 75.0f));
                    entityItem.field_70170_p.func_184133_a(null, (BlockPos)pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.65f, 0.8f + rand * 0.4f);
                    ((WorldServer)entityItem.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, 42, 0.0, 0.15, 0.0, 0.08, new int[0]);
                    if (rand <= 0.01f) {
                        entityItem.field_70170_p.func_180501_a((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                } else if (state.func_185904_a() == Material.field_151588_w) {
                    heatCap.setTemperature(Math.max(0.0f, itemTemp - 100.0f));
                    entityItem.field_70170_p.func_184133_a(null, (BlockPos)pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.8f, 0.8f + rand * 0.4f);
                    ((WorldServer)entityItem.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, 42, 0.0, 0.15, 0.0, 0.08, new int[0]);
                    if (rand <= 0.01f) {
                        entityItem.field_70170_p.func_180501_a((BlockPos)pos, FluidsTFC.FRESH_WATER.get().getBlock().func_176223_P(), 2);
                    }
                } else if (state.func_185904_a() == Material.field_151598_x) {
                    heatCap.setTemperature(Math.max(0.0f, itemTemp - 125.0f));
                    entityItem.field_70170_p.func_184133_a(null, (BlockPos)pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 0.8f + rand * 0.4f);
                    ((WorldServer)entityItem.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, 42, 0.0, 0.15, 0.0, 0.08, new int[0]);
                    if (rand <= 0.005f) {
                        entityItem.field_70170_p.func_180501_a((BlockPos)pos, FluidsTFC.FRESH_WATER.get().getBlock().func_176223_P(), 2);
                    }
                }
                event.setExtraLife(itemTemp == 0.0f ? lifespan : ConfigTFC.Devices.TEMPERATURE.ticksBeforeAttemptToCool);
                entityItem.func_174868_q();
            } else {
                event.setExtraLife(lifespan);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpactEvent(ProjectileImpactEvent.Throwable event) {
        if (event.getThrowable() instanceof EntityEgg) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGameRuleChange(GameRuleChangeEvent event) {
        GameRules rules = event.getRules();
        if ("naturalRegeneration".equals(event.getRuleName()) && ConfigTFC.General.OVERRIDES.forceNoVanillaNaturalRegeneration) {
            event.getRules().func_82764_b("naturalRegeneration", "false");
            TerraFirmaCraft.getLog().warn("Something tried to set natural regeneration to true, reverting!");
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world.field_73011_w.getDimension() == 0 && !world.field_72995_K) {
            CalendarWorldData data = CalendarWorldData.get(world);
            CalendarTFC.INSTANCE.resetTo(data.getCalendar());
            TerraFirmaCraft.getNetwork().sendToAll((IMessage)new PacketCalendarUpdate(CalendarTFC.INSTANCE));
        }
        if (ConfigTFC.General.OVERRIDES.forceNoVanillaNaturalRegeneration) {
            event.getWorld().func_82736_K().func_82764_b("naturalRegeneration", "false");
            TerraFirmaCraft.getLog().warn("Updating gamerule naturalRegeneration to false!");
        }
    }

    @SubscribeEvent
    public static void onCreateSpawn(WorldEvent.CreateSpawnPosition event) {
        event.getSettings().field_77169_g = false;
        TerraFirmaCraft.getLog().info("Disabling bonus chest, you cheaty cheater!");
    }

    @SubscribeEvent
    public static void onFluidPlaceBlock(BlockEvent.FluidPlaceBlockEvent event) {
        if (ConfigTFC.General.OVERRIDES.enableLavaWaterPlacesTFCBlocks) {
            if (event.getNewState().func_177230_c() == Blocks.field_150348_b) {
                event.setNewState(BlockRockVariant.get(Rock.BASALT, Rock.Type.RAW).func_176223_P().func_177226_a((IProperty)BlockRockRaw.CAN_FALL, (Comparable)Boolean.valueOf(false)));
            }
            if (event.getNewState().func_177230_c() == Blocks.field_150347_e) {
                event.setNewState(BlockRockVariant.get(Rock.RHYOLITE, Rock.Type.RAW).func_176223_P().func_177226_a((IProperty)BlockRockRaw.CAN_FALL, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.field_70173_aa % 100 == 0) {
            BlockPos basePos = new BlockPos((Entity)event.player);
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    BlockPos chunkPos = basePos.func_177982_a(16 * i, 0, 16 * j);
                    ChunkDataTFC data = ChunkDataTFC.get(event.player.func_130014_f_(), chunkPos);
                    data.addSpawnProtection(1);
                }
            }
        }
        if (event.phase == TickEvent.Phase.START && !event.player.func_184812_l_() && event.player.field_70173_aa % 20 == 0) {
            int hugeHeavyCount = CommonEventHandler.countPlayerOverburdened(event.player.field_71071_by);
            if (hugeHeavyCount >= 1) {
                event.player.func_71020_j(0.016666668f);
            }
            if (hugeHeavyCount >= 2) {
                event.player.func_70690_d(new PotionEffect(PotionEffectsTFC.OVERBURDENED, 25, 125, false, false));
            }
        }
        if (event.phase == TickEvent.Phase.START && event.player.field_71070_bA != null && event.player instanceof EntityPlayerMP) {
            CapabilityContainerListener.syncCapabilityOnlyChanges(event.player.field_71070_bA, (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void checkArrowFill(ArrowNockEvent event) {
        EntityPlayer player;
        if (!event.hasAmmo() && event.getAction() == null && (player = event.getEntityPlayer()) != null && !player.field_71075_bZ.field_75098_d && ItemQuiver.replenishArrow(player)) {
            event.setAction(new ActionResult(EnumActionResult.PASS, (Object)event.getBow()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void pickupQuiverItems(EntityItemPickupEvent event) {
        if (!event.isCanceled() && ItemQuiver.pickupAmmo(event)) {
            event.setResult(Event.Result.ALLOW);
            event.getItem().func_92059_d().func_190920_e(0);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ResourceLocation entityType = EntityList.func_191301_a((Entity)event.getTarget());
        Entity target = event.getTarget();
        EntityPlayer player = event.getEntityPlayer();
        if (entityType != null && target.field_70172_ad == 0 && !target.func_130014_f_().field_72995_K && player.func_184614_ca().func_190926_b() && player.func_70093_af() && Arrays.asList(ConfigTFC.General.MISC.pluckableEntities).contains(entityType.toString())) {
            target.func_145779_a(Items.field_151008_G, 1);
            target.func_70097_a(DamageSourcesTFC.PLUCKING, (float)ConfigTFC.General.MISC.damagePerFeather);
            if (target instanceof IAnimalTFC) {
                ((IAnimalTFC)target).setFamiliarity(((EntityAnimalTFC)target).getFamiliarity() - 0.04f);
            }
        }
    }

    @SubscribeEvent
    public static void attachWorldCapabilities(AttachCapabilitiesEvent<World> event) {
        event.addCapability(CapabilityWorldTracker.KEY, (ICapabilityProvider)new WorldTracker());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        WorldTracker tracker;
        if (event.phase == TickEvent.Phase.START && (tracker = (WorldTracker)event.world.getCapability(CapabilityWorldTracker.CAPABILITY, null)) != null) {
            tracker.tick(event.world);
        }
    }

    @SubscribeEvent
    public static void onServerChatEvent(ServerChatEvent event) {
        long intoxicatedTicks;
        IPlayerData cap = (IPlayerData)event.getPlayer().getCapability(CapabilityPlayerData.CAPABILITY, null);
        if (cap != null && (intoxicatedTicks = cap.getIntoxicatedTime() - 6000L) > 0L) {
            float drunkChance = MathHelper.func_76131_a((float)((float)intoxicatedTicks / 36000.0f), (float)0.0f, (float)0.7f);
            String originalMessage = event.getMessage();
            CharSequence[] words = originalMessage.split(" ");
            for (int i = 0; i < words.length; ++i) {
                int pos;
                String word = words[i];
                if (word.length() == 0) continue;
                if (Constants.RNG.nextFloat() < drunkChance && word.length() >= 2) {
                    pos = Constants.RNG.nextInt(word.length() - 1);
                    word = word.substring(0, pos) + word.charAt(pos + 1) + word.charAt(pos) + word.substring(pos + 2);
                }
                if (Constants.RNG.nextFloat() < drunkChance) {
                    pos = Constants.RNG.nextInt(word.length());
                    char repeat = word.charAt(pos);
                    int amount = 1 + Constants.RNG.nextInt(3);
                    word = word.substring(0, pos) + new String(new char[amount]).replace('\u0000', repeat) + (pos + 1 < word.length() ? word.substring(pos + 1) : "");
                }
                if (Constants.RNG.nextFloat() < drunkChance) {
                    pos = Constants.RNG.nextInt(word.length());
                    char replacement = ALPHABET.charAt(Constants.RNG.nextInt(ALPHABET.length()));
                    if (Character.isUpperCase(word.charAt(Constants.RNG.nextInt(word.length())))) {
                        replacement = Character.toUpperCase(replacement);
                    }
                    word = word.substring(0, pos) + replacement + (pos + 1 < word.length() ? word.substring(pos + 1) : "");
                }
                words[i] = word;
            }
            event.setComponent((ITextComponent)new TextComponentTranslation("<" + event.getUsername() + "> " + String.join((CharSequence)" ", words), new Object[0]));
        }
    }

    private static int countPlayerOverburdened(InventoryPlayer inventory) {
        int hugeHeavyCount = 0;
        for (ItemStack stack : inventory.field_70462_a) {
            if (!CapabilityItemSize.checkItemSize(stack, Size.HUGE, Weight.VERY_HEAVY) || ++hugeHeavyCount < 2) continue;
            return hugeHeavyCount;
        }
        for (ItemStack stack : inventory.field_70460_b) {
            if (!CapabilityItemSize.checkItemSize(stack, Size.HUGE, Weight.VERY_HEAVY) || ++hugeHeavyCount < 2) continue;
            return hugeHeavyCount;
        }
        for (ItemStack stack : inventory.field_184439_c) {
            if (!CapabilityItemSize.checkItemSize(stack, Size.HUGE, Weight.VERY_HEAVY) || ++hugeHeavyCount < 2) continue;
            return hugeHeavyCount;
        }
        return hugeHeavyCount;
    }
}

