/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.food;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FoodTrait {
    public static final FoodTrait SALTED;
    public static final FoodTrait BRINED;
    public static final FoodTrait PICKLED;
    public static final FoodTrait PRESERVED;
    public static final FoodTrait VINEGAR;
    public static final FoodTrait CHARCOAL_GRILLED;
    public static final FoodTrait WOOD_GRILLED;
    public static final FoodTrait BURNT_TO_A_CRISP;
    private static final Map<String, FoodTrait> TRAITS;
    private final String name;
    private final float decayModifier;
    private final boolean hasTooltip;

    public static Map<String, FoodTrait> getTraits() {
        return TRAITS;
    }

    public FoodTrait(@Nonnull String name, float decayModifier) {
        this(name, decayModifier, true);
    }

    public FoodTrait(@Nonnull String name, float decayModifier, boolean hasTooltip) {
        this.name = name;
        this.decayModifier = decayModifier;
        this.hasTooltip = hasTooltip;
        if (TRAITS.containsKey(name)) {
            throw new IllegalStateException("There is already a trait with the name '" + name + "'");
        }
        TRAITS.put(name, this);
    }

    public float getDecayModifier() {
        return this.decayModifier;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public void addTraitInfo(@Nonnull ItemStack stack, @Nonnull List<String> text) {
        if (this.hasTooltip) {
            text.add(I18n.func_135052_a((String)("tfc.food_traits." + this.getName()), (Object[])new Object[0]));
        }
    }

    static {
        TRAITS = new HashMap<String, FoodTrait>();
        BRINED = new FoodTrait("brined", 1.0f);
        SALTED = new FoodTrait("salted", 0.5f);
        PICKLED = new FoodTrait("pickled", 0.5f);
        PRESERVED = new FoodTrait("preserved", 0.5f);
        VINEGAR = new FoodTrait("vinegar", 0.1f);
        CHARCOAL_GRILLED = new FoodTrait("charcoal_grilled", 1.25f);
        WOOD_GRILLED = new FoodTrait("wood_grilled", 0.8f);
        BURNT_TO_A_CRISP = new FoodTrait("burnt_to_a_crisp", 2.5f);
    }
}

