/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.food;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.food.FoodData;
import net.dries007.tfc.api.capability.food.FoodTrait;
import net.dries007.tfc.api.capability.food.Nutrient;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.calendar.ICalendarFormatted;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IFood
extends INBTSerializable<NBTTagCompound> {
    public long getCreationDate();

    public void setCreationDate(long var1);

    public long getRottenDate();

    default public boolean isRotten() {
        return this.getRottenDate() < CalendarTFC.PLAYER_TIME.getTicks();
    }

    @Nonnull
    public FoodData getData();

    public float getDecayDateModifier();

    public void setNonDecaying();

    @Nonnull
    public List<FoodTrait> getTraits();

    @SideOnly(value=Side.CLIENT)
    default public void addTooltipInfo(@Nonnull ItemStack stack, @Nonnull List<String> text, @Nullable EntityPlayer player) {
        if (this.isRotten()) {
            text.add(TextFormatting.RED + I18n.func_135052_a((String)"tfc.tooltip.food_rotten", (Object[])new Object[0]));
        } else {
            long rottenDate = this.getRottenDate();
            if (rottenDate == Long.MAX_VALUE) {
                text.add(TextFormatting.GOLD + I18n.func_135052_a((String)"tfc.tooltip.food_infinite_expiry", (Object[])new Object[0]));
            } else {
                long rottenCalendarTime = rottenDate - CalendarTFC.PLAYER_TIME.getTicks() + CalendarTFC.CALENDAR_TIME.getTicks();
                long daysToRotInTicks = rottenCalendarTime - CalendarTFC.CALENDAR_TIME.getTicks();
                switch (ConfigTFC.Client.TOOLTIP.decayTooltipMode) {
                    case HIDE: {
                        break;
                    }
                    case EXPIRATION_ONLY: {
                        text.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tfc.tooltip.food_expiry_date", (Object[])new Object[]{ICalendarFormatted.getTimeAndDate(rottenCalendarTime, CalendarTFC.CALENDAR_TIME.getDaysInMonth())}));
                        break;
                    }
                    case TIME_REMAINING_ONLY: {
                        text.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tfc.tooltip.food_expiry_date.days", (Object[])new Object[]{String.valueOf(ICalendar.getTotalDays(daysToRotInTicks))}));
                        break;
                    }
                    case ALL_INFO: {
                        text.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tfc.tooltip.food_expiry_date", (Object[])new Object[]{ICalendarFormatted.getTimeAndDate(rottenCalendarTime, CalendarTFC.CALENDAR_TIME.getDaysInMonth())}));
                        text.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tfc.tooltip.food_expiry_date.days", (Object[])new Object[]{String.valueOf(ICalendar.getTotalDays(daysToRotInTicks))}));
                    }
                }
            }
        }
        if (ConfigTFC.General.DEBUG.enable) {
            text.add("Created at " + this.getCreationDate());
        }
        if (GuiScreen.func_146272_n()) {
            float water;
            text.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tfc.tooltip.nutrition", (Object[])new Object[0]));
            float saturation = this.getData().getSaturation();
            if (saturation > 0.0f) {
                text.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tfc.tooltip.nutrition_saturation", (Object[])new Object[]{String.format("%d", (int)(saturation * 5.0f))}));
            }
            if ((water = this.getData().getWater()) > 0.0f) {
                text.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tfc.tooltip.nutrition_water", (Object[])new Object[]{String.format("%d", (int)water)}));
            }
            for (Nutrient nutrient : Nutrient.values()) {
                float value = this.getData().getNutrients()[nutrient.ordinal()];
                if (!(value > 0.0f)) continue;
                text.add(nutrient.getColor() + I18n.func_135052_a((String)"tfc.tooltip.nutrition_nutrient", (Object[])new Object[]{I18n.func_135052_a((String)Helpers.getEnumName(nutrient), (Object[])new Object[0]), String.format("%.1f", Float.valueOf(value))}));
            }
        } else {
            text.add(TextFormatting.ITALIC + I18n.func_135052_a((String)"tfc.tooltip.hold_shift_for_nutrition_info", (Object[])new Object[0]));
        }
        for (FoodTrait trait : this.getTraits()) {
            trait.addTraitInfo(stack, text);
        }
    }
}

