/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.metal;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.DumbStorage;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.capability.metal.MetalItemHandler;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.oredict.OreDictionary;

public final class CapabilityMetalItem {
    public static final ResourceLocation KEY = new ResourceLocation("tfc", "metal_object");
    public static final Map<IIngredient<ItemStack>, Supplier<ICapabilityProvider>> CUSTOM_METAL_ITEMS = new HashMap<IIngredient<ItemStack>, Supplier<ICapabilityProvider>>();
    public static final Map<String, Metal.ItemType> ORE_DICT_METAL_ITEMS = new LinkedHashMap<String, Metal.ItemType>();
    @CapabilityInject(value=IMetalItem.class)
    public static Capability<IMetalItem> METAL_OBJECT_CAPABILITY;

    public static void preInit() {
        CapabilityManager.INSTANCE.register(IMetalItem.class, new DumbStorage(), MetalItemHandler::new);
        ORE_DICT_METAL_ITEMS.put("ingotDouble", Metal.ItemType.DOUBLE_INGOT);
        ORE_DICT_METAL_ITEMS.put("ingot", Metal.ItemType.INGOT);
        ORE_DICT_METAL_ITEMS.put("sheetDouble", Metal.ItemType.DOUBLE_SHEET);
        ORE_DICT_METAL_ITEMS.put("sheet", Metal.ItemType.SHEET);
        ORE_DICT_METAL_ITEMS.put("scrap", Metal.ItemType.SCRAP);
        ORE_DICT_METAL_ITEMS.put("dust", Metal.ItemType.DUST);
        ORE_DICT_METAL_ITEMS.put("nugget", Metal.ItemType.NUGGET);
    }

    public static void init() {
        CUSTOM_METAL_ITEMS.put(IIngredient.of(Blocks.field_150411_aY), () -> new MetalItemHandler(Metal.WROUGHT_IRON, 25, true));
    }

    @Nullable
    public static IMetalItem getMetalItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            IMetalItem metal = (IMetalItem)stack.getCapability(METAL_OBJECT_CAPABILITY, null);
            if (metal != null) {
                return metal;
            }
            if (stack.func_77973_b() instanceof IMetalItem) {
                return (IMetalItem)stack.func_77973_b();
            }
            if (stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof IMetalItem) {
                return (IMetalItem)((ItemBlock)stack.func_77973_b()).func_179223_d();
            }
        }
        return null;
    }

    @Nullable
    public static ICapabilityProvider getCustomMetalItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            int[] ids;
            Set<IIngredient<ItemStack>> itemItemSet = CUSTOM_METAL_ITEMS.keySet();
            for (IIngredient<ItemStack> ingredient : itemItemSet) {
                if (!ingredient.testIgnoreCount(stack)) continue;
                return CUSTOM_METAL_ITEMS.get(ingredient).get();
            }
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                ICapabilityProvider handler = CapabilityMetalItem.getMetalItemFromOreDict(OreDictionary.getOreName((int)id));
                if (handler == null) continue;
                return handler;
            }
        }
        return null;
    }

    @Nullable
    private static ICapabilityProvider getMetalItemFromOreDict(String oreDict) {
        for (String oreName : ORE_DICT_METAL_ITEMS.keySet()) {
            if (!oreDict.startsWith(oreName)) continue;
            return TFCRegistries.METALS.getValuesCollection().stream().filter(metal -> oreDict.equals(OreDictionaryHelper.toString(oreName, metal.getRegistryName().func_110623_a()))).findFirst().map(metal -> {
                Metal.ItemType type = ORE_DICT_METAL_ITEMS.get(oreName);
                return new MetalItemHandler((Metal)((Object)metal), type.getSmeltAmount(), true);
            }).orElse(null);
        }
        return null;
    }
}

