/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.capability.worldtracker;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class CollapseData
implements INBTSerializable<NBTTagCompound> {
    final List<BlockPos> nextPositions;
    BlockPos centerPos;
    double radiusSquared;

    public CollapseData(BlockPos centerPos, List<BlockPos> nextPositions, double radiusSquared) {
        this.centerPos = centerPos;
        this.nextPositions = nextPositions;
        this.radiusSquared = radiusSquared;
    }

    public CollapseData(NBTTagCompound nbt) {
        this.nextPositions = new ArrayList<BlockPos>();
        this.deserializeNBT(nbt);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("centerPos", this.centerPos.func_177986_g());
        NBTTagList list = new NBTTagList();
        for (BlockPos pos : this.nextPositions) {
            NBTTagCompound posTag = new NBTTagCompound();
            posTag.func_74768_a("x", pos.func_177958_n());
            posTag.func_74768_a("y", pos.func_177956_o());
            posTag.func_74768_a("z", pos.func_177952_p());
            list.func_74742_a((NBTBase)posTag);
        }
        nbt.func_74780_a("radiusSquared", this.radiusSquared);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            this.centerPos = BlockPos.func_177969_a((long)nbt.func_74763_f("centerPos"));
            NBTTagList list = nbt.func_150295_c("nextPositions", 10);
            this.nextPositions.clear();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound posTag = list.func_150305_b(i);
                this.nextPositions.add(new BlockPos(posTag.func_74762_e("x"), posTag.func_74762_e("y"), posTag.func_74762_e("z")));
            }
            this.radiusSquared = nbt.func_74769_h("radiusSquared");
        }
    }
}

