/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes;

import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.metal.CapabilityMetalItem;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.items.metal.ItemIngot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlastFurnaceRecipe
extends IForgeRegistryEntry.Impl<BlastFurnaceRecipe> {
    protected Metal output;
    protected Metal input;
    protected IIngredient<ItemStack> additive;

    @Nullable
    public static BlastFurnaceRecipe get(ItemStack inputItem) {
        return TFCRegistries.BLAST_FURNACE.getValuesCollection().stream().filter(x -> x.isValidInput(inputItem)).findFirst().orElse(null);
    }

    @Nullable
    public static BlastFurnaceRecipe get(Metal inputMetal) {
        return TFCRegistries.BLAST_FURNACE.getValuesCollection().stream().filter(x -> x.input == inputMetal).findFirst().orElse(null);
    }

    public BlastFurnaceRecipe(Metal output, Metal input, IIngredient<ItemStack> additive) {
        this.output = output;
        this.input = input;
        this.additive = additive;
        this.setRegistryName(input.getRegistryName());
    }

    @Nullable
    public FluidStack getOutput(ItemStack stack) {
        IMetalItem metal = CapabilityMetalItem.getMetalItem(stack);
        int value = metal != null && metal.getMetal(stack) == this.input ? metal.getSmeltAmount(stack) : 0;
        return value > 0 ? new FluidStack(FluidsTFC.getFluidFromMetal(this.output), value) : null;
    }

    public boolean isValidInput(ItemStack stack) {
        IMetalItem metal = CapabilityMetalItem.getMetalItem(stack);
        return metal != null && metal.getMetal(stack) == this.input;
    }

    public boolean isValidAdditive(ItemStack stack) {
        return this.additive.testIgnoreCount(stack);
    }

    public ItemStack getOutput() {
        return new ItemStack(ItemIngot.get(this.output, Metal.ItemType.INGOT));
    }
}

