/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes;

import javax.annotation.Nullable;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.compat.jei.IJEISimpleRecipe;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LoomRecipe
extends IForgeRegistryEntry.Impl<LoomRecipe>
implements IJEISimpleRecipe {
    private final IIngredient<ItemStack> inputItem;
    private final ItemStack outputItem;
    private final int stepCount;
    private final ResourceLocation inProgressTexture;

    @Nullable
    public static LoomRecipe get(ItemStack item) {
        return TFCRegistries.LOOM.getValuesCollection().stream().filter(x -> x.isValidInput(item)).findFirst().orElse(null);
    }

    public LoomRecipe(ResourceLocation name, IIngredient<ItemStack> input, ItemStack output, int stepsRequired, ResourceLocation inProgressTexture) {
        this.inputItem = input;
        this.outputItem = output;
        this.stepCount = stepsRequired;
        this.inProgressTexture = inProgressTexture;
        if (this.inputItem == null || input.getAmount() == 0 || this.outputItem == null || stepsRequired == 0) {
            throw new IllegalArgumentException("Input and output are not allowed to be empty");
        }
        this.setRegistryName(name);
    }

    public int getInputCount() {
        return this.inputItem.getAmount();
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public ItemStack getOutputItem() {
        return this.outputItem.func_77946_l();
    }

    public ResourceLocation getInProgressTexture() {
        return this.inProgressTexture;
    }

    @Override
    public NonNullList<IIngredient<ItemStack>> getIngredients() {
        return NonNullList.func_191197_a((int)1, this.inputItem);
    }

    @Override
    public NonNullList<ItemStack> getOutputs() {
        return NonNullList.func_191197_a((int)1, (Object)this.outputItem);
    }

    private boolean isValidInput(ItemStack inputItem) {
        return this.inputItem.testIgnoreCount(inputItem);
    }
}

