/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes.anvil;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.forge.CapabilityForgeable;
import net.dries007.tfc.api.capability.forge.IForgeable;
import net.dries007.tfc.api.capability.forge.IForgeableMeasurableMetal;
import net.dries007.tfc.api.recipes.anvil.AnvilRecipe;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.util.forge.ForgeRule;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
public class AnvilRecipeMeasurable
extends AnvilRecipe {
    public AnvilRecipeMeasurable(ResourceLocation name, IIngredient<ItemStack> input, ItemStack output, Metal.Tier minTier, ForgeRule ... rules) throws IllegalArgumentException {
        super(name, input, output, minTier, null, rules);
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getOutput(ItemStack input) {
        if (this.matches(input)) {
            NonNullList<ItemStack> out = super.getOutput(input);
            IForgeable inputCap = (IForgeable)input.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
            IForgeable outputCap = (IForgeable)((ItemStack)out.get(0)).getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
            if (inputCap instanceof IForgeableMeasurableMetal && outputCap instanceof IForgeableMeasurableMetal) {
                ((IForgeableMeasurableMetal)outputCap).setMetalAmount(((IForgeableMeasurableMetal)inputCap).getMetalAmount());
                ((IForgeableMeasurableMetal)outputCap).setMetal(((IForgeableMeasurableMetal)inputCap).getMetal());
            }
            return out;
        }
        return EMPTY;
    }
}

