/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes.barrel;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.util.Helpers;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BarrelRecipe
extends IForgeRegistryEntry.Impl<BarrelRecipe> {
    protected final IIngredient<ItemStack> inputStack;
    protected final IIngredient<FluidStack> inputFluid;
    private final FluidStack outputFluid;
    private final ItemStack outputStack;
    private final int duration;

    @Nullable
    public static BarrelRecipe get(ItemStack stack, FluidStack fluidStack) {
        return TFCRegistries.BARREL.getValuesCollection().stream().filter(x -> x.isValidInput(fluidStack, stack) && x.getDuration() != 0).findFirst().orElse(null);
    }

    @Nullable
    public static BarrelRecipe getInstant(ItemStack stack, FluidStack fluidStack) {
        return TFCRegistries.BARREL.getValuesCollection().stream().filter(x -> x.isValidInput(fluidStack, stack) && x.getDuration() == 0).findFirst().orElse(null);
    }

    public static boolean isBarrelFluid(FluidStack fluidStack) {
        return TFCRegistries.BARREL.getValuesCollection().stream().filter(x -> x.inputFluid.testIgnoreCount(fluidStack)).findFirst().orElse(null) != null;
    }

    public BarrelRecipe(@Nonnull IIngredient<FluidStack> inputFluid, @Nonnull IIngredient<ItemStack> inputStack, @Nullable FluidStack outputFluid, @Nonnull ItemStack outputStack, int duration) {
        this.inputStack = inputStack;
        this.inputFluid = inputFluid;
        this.outputFluid = outputFluid;
        this.outputStack = outputStack;
        this.duration = duration;
    }

    public boolean isValidInput(@Nullable FluidStack inputFluid, ItemStack inputStack) {
        return this.inputFluid.test(inputFluid) && this.inputStack.test(inputStack);
    }

    public boolean isValidInputInstant(ItemStack inputStack, @Nullable FluidStack inputFluid) {
        return inputFluid == null || inputFluid.amount / this.inputFluid.getAmount() <= inputStack.func_190916_E() / this.inputStack.getAmount();
    }

    public int getDuration() {
        return this.duration;
    }

    @Nullable
    public FluidStack getOutputFluid() {
        return this.outputFluid != null ? this.outputFluid.copy() : null;
    }

    @Nonnull
    public ItemStack getOutputStack() {
        return this.outputStack;
    }

    @Nonnull
    public IIngredient<ItemStack> getItemIngredient() {
        return this.inputStack;
    }

    @Nonnull
    public IIngredient<FluidStack> getFluidIngredient() {
        return this.inputFluid;
    }

    @Nullable
    public FluidStack getOutputFluid(FluidStack inputFluid, ItemStack inputStack) {
        int multiplier = this.getMultiplier(inputFluid, inputStack);
        if (this.outputFluid != null) {
            int outputAmount = Math.min(multiplier * this.outputFluid.amount, ConfigTFC.Devices.BARREL.tank);
            return new FluidStack(this.outputFluid.getFluid(), outputAmount);
        }
        int retainAmount = inputFluid.amount - multiplier * this.inputFluid.getAmount();
        if (retainAmount > 0) {
            return new FluidStack(inputFluid.getFluid(), inputFluid.amount - multiplier * this.inputFluid.getAmount());
        }
        return null;
    }

    @Nonnull
    public List<ItemStack> getOutputItem(FluidStack inputFluid, ItemStack inputStack) {
        int multiplier = this.getMultiplier(inputFluid, inputStack);
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        if (!this.outputStack.func_190926_b()) {
            int count;
            int outputCount = multiplier * this.outputStack.func_190916_E();
            do {
                count = Math.min(outputCount, this.outputStack.func_77976_d());
                ItemStack output = this.outputStack.func_77946_l();
                output.func_190920_e(count);
                outputList.add(output);
            } while ((outputCount -= count) > 0);
        } else {
            int retainCount = inputStack.func_190916_E() - multiplier * this.inputStack.getAmount();
            if (retainCount > 0) {
                inputStack.func_190920_e(retainCount);
                outputList.add(inputStack);
            } else {
                outputList.add(ItemStack.field_190927_a);
            }
        }
        return outputList;
    }

    public void onRecipeComplete(World world, BlockPos pos) {
    }

    public void onBarrelSealed(FluidStack inputFluid, ItemStack inputStack) {
    }

    @Nullable
    public FluidStack getOutputFluidOnUnseal(FluidStack inputFluid, ItemStack inputStack) {
        return inputFluid;
    }

    @Nonnull
    public List<ItemStack> getOutputItemOnUnseal(FluidStack inputFluid, ItemStack inputStack) {
        return Helpers.listOf(inputStack);
    }

    @SideOnly(value=Side.CLIENT)
    public String getResultName() {
        ItemStack resultStack = this.getOutputStack();
        if (!resultStack.func_190926_b()) {
            return resultStack.func_82833_r();
        }
        FluidStack fluid = this.getOutputFluid();
        if (fluid == null) {
            return "???";
        }
        return fluid.getFluid().getLocalizedName(fluid);
    }

    protected int getMultiplier(FluidStack inputFluid, ItemStack inputStack) {
        if (this.isValidInput(inputFluid, inputStack)) {
            if (this.inputFluid.getAmount() == 0) {
                return inputStack.func_190916_E() / this.inputStack.getAmount();
            }
            if (this.inputStack.getAmount() == 0) {
                return inputFluid.amount / this.inputFluid.getAmount();
            }
            return Math.min(inputFluid.amount / this.inputFluid.getAmount(), inputStack.func_190916_E() / this.inputStack.getAmount());
        }
        return 0;
    }
}

