/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes.barrel;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodTrait;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.inventory.ingredient.IngredientItemFoodTrait;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BarrelRecipeFoodPreservation
extends BarrelRecipe {
    private final FoodTrait trait;
    private final String tooltipName;

    public static BarrelRecipe vinegar(@Nonnull IIngredient<ItemStack> inputStack) {
        return new BarrelRecipeFoodPreservation(IIngredient.of(FluidsTFC.VINEGAR.get(), 125), new IngredientItemFoodTrait(inputStack, FoodTrait.PICKLED), FoodTrait.VINEGAR, "barrel_recipe_vinegar");
    }

    private BarrelRecipeFoodPreservation(@Nonnull IIngredient<FluidStack> inputFluid, @Nonnull IIngredient<ItemStack> inputStack, FoodTrait trait, String tooltipName) {
        super(inputFluid, inputStack, null, ItemStack.field_190927_a, -1);
        this.trait = trait;
        this.tooltipName = tooltipName;
    }

    @Override
    public boolean isValidInput(@Nullable FluidStack inputFluid, ItemStack inputStack) {
        return super.isValidInput(inputFluid, inputStack) && (inputFluid == null || inputFluid.amount / this.inputFluid.getAmount() >= inputStack.func_190916_E() / this.inputStack.getAmount());
    }

    @Override
    @Nonnull
    public List<ItemStack> getOutputItem(FluidStack inputFluid, ItemStack inputStack) {
        return Helpers.listOf(inputStack);
    }

    @Override
    public void onBarrelSealed(FluidStack inputFluid, ItemStack inputStack) {
        CapabilityFood.applyTrait(inputStack, this.trait);
    }

    @Override
    @Nonnull
    public List<ItemStack> getOutputItemOnUnseal(FluidStack inputFluid, ItemStack inputStack) {
        CapabilityFood.removeTrait(inputStack, this.trait);
        return Helpers.listOf(inputStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getResultName() {
        return I18n.func_135052_a((String)("tfc.tooltip." + this.tooltipName), (Object[])new Object[0]);
    }
}

