/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes.heat;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.recipes.heat.HeatRecipeSimple;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.compat.jei.IJEISimpleRecipe;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ParametersAreNonnullByDefault
public abstract class HeatRecipe
extends IForgeRegistryEntry.Impl<HeatRecipe>
implements IJEISimpleRecipe {
    protected final IIngredient<ItemStack> ingredient;
    private final float transformTemp;
    private final Metal.Tier minTier;

    @Nullable
    public static HeatRecipe get(ItemStack stack) {
        return HeatRecipe.get(stack, Metal.Tier.TIER_VI);
    }

    @Nullable
    public static HeatRecipe get(ItemStack stack, Metal.Tier tier) {
        return TFCRegistries.HEAT.getValuesCollection().stream().filter(r -> r.isValidInput(stack, tier)).findFirst().orElse(null);
    }

    public static HeatRecipeSimple destroy(IIngredient<ItemStack> ingredient, float destroyTemperature) {
        return new HeatRecipeSimple(ingredient, ItemStack.field_190927_a, destroyTemperature, 0.0f, Metal.Tier.TIER_0);
    }

    protected HeatRecipe(IIngredient<ItemStack> ingredient, float transformTemp) {
        this(ingredient, transformTemp, Metal.Tier.TIER_0);
    }

    protected HeatRecipe(IIngredient<ItemStack> ingredient, float transformTemp, Metal.Tier minTier) {
        this.ingredient = ingredient;
        this.transformTemp = transformTemp;
        this.minTier = minTier;
    }

    public boolean isValidInput(ItemStack input, Metal.Tier tier) {
        return tier.isAtLeast(this.minTier) && this.ingredient.test(input);
    }

    public boolean isValidTemperature(float temperature) {
        return temperature >= this.transformTemp;
    }

    @Nonnull
    public ItemStack getOutputStack(ItemStack input) {
        return ItemStack.field_190927_a;
    }

    @Nullable
    public FluidStack getOutputFluid(ItemStack input) {
        return null;
    }

    @Override
    public NonNullList<IIngredient<ItemStack>> getIngredients() {
        return NonNullList.func_191196_a();
    }

    @Override
    public NonNullList<ItemStack> getOutputs() {
        return NonNullList.func_191196_a();
    }

    public float getTransformTemp() {
        return this.transformTemp;
    }
}

