/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes.heat;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.recipes.heat.HeatRecipe;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

@ParametersAreNonnullByDefault
public class HeatRecipeSimple
extends HeatRecipe {
    private final ItemStack output;
    private final float maxTemp;

    public HeatRecipeSimple(IIngredient<ItemStack> ingredient, ItemStack output, float transformTemp) {
        this(ingredient, output, transformTemp, Float.MAX_VALUE, Metal.Tier.TIER_0);
    }

    public HeatRecipeSimple(IIngredient<ItemStack> ingredient, ItemStack output, float transformTemp, float maxTemp) {
        this(ingredient, output, transformTemp, maxTemp, Metal.Tier.TIER_0);
    }

    public HeatRecipeSimple(IIngredient<ItemStack> ingredient, ItemStack output, float transformTemp, Metal.Tier minTier) {
        this(ingredient, output, transformTemp, Float.MAX_VALUE, minTier);
    }

    public HeatRecipeSimple(IIngredient<ItemStack> ingredient, ItemStack output, float transformTemp, float maxTemp, Metal.Tier minTier) {
        super(ingredient, transformTemp, minTier);
        this.output = output;
        this.maxTemp = maxTemp;
    }

    @Override
    @Nonnull
    public ItemStack getOutputStack(ItemStack input) {
        IItemHeat heat = (IItemHeat)input.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
        if (heat != null && heat.getTemperature() <= this.maxTemp) {
            ItemStack outputStack = this.output.func_77946_l();
            IItemHeat outputHeat = (IItemHeat)outputStack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
            if (outputHeat != null) {
                outputHeat.setTemperature(heat.getTemperature());
            }
            return CapabilityFood.updateFoodFromPrevious(input, outputStack);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NonNullList<IIngredient<ItemStack>> getIngredients() {
        return NonNullList.func_191197_a((int)1, (Object)this.ingredient);
    }

    @Override
    public NonNullList<ItemStack> getOutputs() {
        return NonNullList.func_191197_a((int)1, (Object)this.output);
    }
}

