/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes.quern;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.compat.jei.IJEISimpleRecipe;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class QuernRecipe
extends IForgeRegistryEntry.Impl<QuernRecipe>
implements IJEISimpleRecipe {
    protected IIngredient<ItemStack> inputItem;
    protected ItemStack outputItem;

    @Nullable
    public static QuernRecipe get(ItemStack item) {
        return TFCRegistries.QUERN.getValuesCollection().stream().filter(x -> x.isValidInput(item)).findFirst().orElse(null);
    }

    public QuernRecipe(IIngredient<ItemStack> input, ItemStack output) {
        this.inputItem = input;
        this.outputItem = output;
        if (this.inputItem == null || this.outputItem == null) {
            throw new IllegalArgumentException("Input and output are not allowed to be empty");
        }
    }

    @Nonnull
    public ItemStack getOutputItem(ItemStack stack) {
        return CapabilityFood.updateFoodFromPrevious(stack, this.outputItem.func_77946_l());
    }

    @Override
    public NonNullList<IIngredient<ItemStack>> getIngredients() {
        return NonNullList.func_191197_a((int)1, this.inputItem);
    }

    @Override
    public NonNullList<ItemStack> getOutputs() {
        return NonNullList.func_191197_a((int)1, (Object)this.outputItem);
    }

    private boolean isValidInput(ItemStack inputItem) {
        return this.inputItem.test(inputItem);
    }
}

