/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.types;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.types.ICreatureTFC;
import net.dries007.tfc.objects.entity.animal.AnimalFood;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;

public interface IAnimalTFC
extends ICreatureTFC {
    public Gender getGender();

    public void setGender(Gender var1);

    public int getBirthDay();

    public void setBirthDay(int var1);

    default public float getAdultFamiliarityCap() {
        return 0.0f;
    }

    public float getFamiliarity();

    public void setFamiliarity(float var1);

    public boolean isFertilized();

    public void setFertilized(boolean var1);

    default public void onFertilized(@Nonnull IAnimalTFC male) {
        this.setFertilized(true);
    }

    default public double getPercentToAdulthood() {
        long deltaDays = CalendarTFC.PLAYER_TIME.getTotalDays() - (long)this.getBirthDay();
        long adulthoodDay = this.getDaysToAdulthood();
        return Math.max(0.0, Math.min(1.0, (double)deltaDays / (double)adulthoodDay));
    }

    default public Age getAge() {
        long deltaDays = CalendarTFC.PLAYER_TIME.getTotalDays() - (long)this.getBirthDay();
        long adulthoodDay = this.getDaysToAdulthood();
        long elderlyDay = this.getDaysToElderly() + this.getDaysToAdulthood();
        if (this.getCreatureType() == ICreatureTFC.CreatureType.LIVESTOCK && this.getDaysToElderly() > 0 && deltaDays > elderlyDay) {
            return Age.OLD;
        }
        if (deltaDays > adulthoodDay) {
            return Age.ADULT;
        }
        return Age.CHILD;
    }

    public int getDaysToAdulthood();

    public int getDaysToElderly();

    default public boolean isReadyToMate() {
        return this.getAge() == Age.ADULT && !(this.getFamiliarity() < 0.3f) && !this.isFertilized() && !this.isHungry();
    }

    default public boolean isFood(@Nonnull ItemStack stack) {
        AnimalFood food = AnimalFood.get(this.getClass());
        if (food != null) {
            return food.isFood(stack);
        }
        return false;
    }

    public boolean isHungry();

    public Type getType();

    default public boolean isReadyForAnimalProduct() {
        return false;
    }

    default public List<ItemStack> getProducts() {
        return Collections.emptyList();
    }

    default public void setProductsCooldown() {
    }

    default public long getProductsCooldown() {
        return 0L;
    }

    default public TextComponentTranslation getTooltip() {
        return null;
    }

    public TextComponentTranslation getAnimalName();

    public static enum Type {
        MAMMAL,
        OVIPAROUS;

    }

    public static enum Gender {
        MALE,
        FEMALE;


        public static Gender valueOf(boolean value) {
            return value ? MALE : FEMALE;
        }

        public boolean toBool() {
            return this == MALE;
        }
    }

    public static enum Age {
        CHILD,
        ADULT,
        OLD;

    }
}

