/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.recipes.knapping.KnappingType;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.util.IRockObject;
import net.dries007.tfc.client.gui.GuiAnvilPlan;
import net.dries007.tfc.client.gui.GuiAnvilTFC;
import net.dries007.tfc.client.gui.GuiBarrel;
import net.dries007.tfc.client.gui.GuiBlastFurnace;
import net.dries007.tfc.client.gui.GuiCalendar;
import net.dries007.tfc.client.gui.GuiCharcoalForge;
import net.dries007.tfc.client.gui.GuiChestTFC;
import net.dries007.tfc.client.gui.GuiContainerTFC;
import net.dries007.tfc.client.gui.GuiCrucible;
import net.dries007.tfc.client.gui.GuiFirePit;
import net.dries007.tfc.client.gui.GuiInventoryCrafting;
import net.dries007.tfc.client.gui.GuiKnapping;
import net.dries007.tfc.client.gui.GuiLargeVessel;
import net.dries007.tfc.client.gui.GuiLiquidTransfer;
import net.dries007.tfc.client.gui.GuiNutrition;
import net.dries007.tfc.client.gui.GuiPowderkeg;
import net.dries007.tfc.client.gui.GuiSalad;
import net.dries007.tfc.client.gui.GuiSkills;
import net.dries007.tfc.objects.blocks.wood.BlockChestTFC;
import net.dries007.tfc.objects.container.ContainerAnvilPlan;
import net.dries007.tfc.objects.container.ContainerAnvilTFC;
import net.dries007.tfc.objects.container.ContainerBarrel;
import net.dries007.tfc.objects.container.ContainerBlastFurnace;
import net.dries007.tfc.objects.container.ContainerCharcoalForge;
import net.dries007.tfc.objects.container.ContainerChestTFC;
import net.dries007.tfc.objects.container.ContainerCrucible;
import net.dries007.tfc.objects.container.ContainerFirePit;
import net.dries007.tfc.objects.container.ContainerInventoryCrafting;
import net.dries007.tfc.objects.container.ContainerKnapping;
import net.dries007.tfc.objects.container.ContainerLargeVessel;
import net.dries007.tfc.objects.container.ContainerLiquidTransfer;
import net.dries007.tfc.objects.container.ContainerLogPile;
import net.dries007.tfc.objects.container.ContainerNestBox;
import net.dries007.tfc.objects.container.ContainerPowderKeg;
import net.dries007.tfc.objects.container.ContainerQuiver;
import net.dries007.tfc.objects.container.ContainerSalad;
import net.dries007.tfc.objects.container.ContainerSimple;
import net.dries007.tfc.objects.container.ContainerSmallVessel;
import net.dries007.tfc.objects.items.ItemQuiver;
import net.dries007.tfc.objects.items.ceramics.ItemMold;
import net.dries007.tfc.objects.items.ceramics.ItemSmallVessel;
import net.dries007.tfc.objects.items.rock.ItemRock;
import net.dries007.tfc.objects.te.TEAnvilTFC;
import net.dries007.tfc.objects.te.TEBarrel;
import net.dries007.tfc.objects.te.TEBlastFurnace;
import net.dries007.tfc.objects.te.TECharcoalForge;
import net.dries007.tfc.objects.te.TECrucible;
import net.dries007.tfc.objects.te.TEFirePit;
import net.dries007.tfc.objects.te.TELargeVessel;
import net.dries007.tfc.objects.te.TELogPile;
import net.dries007.tfc.objects.te.TENestBox;
import net.dries007.tfc.objects.te.TEPowderKeg;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class TFCGuiHandler
implements IGuiHandler {
    public static final ResourceLocation SMALL_INVENTORY_BACKGROUND = new ResourceLocation("tfc", "textures/gui/small_inventory.png");
    public static final ResourceLocation CLAY_TEXTURE = new ResourceLocation("tfc", "textures/gui/knapping/clay_button.png");
    public static final ResourceLocation FIRE_CLAY_TEXTURE = new ResourceLocation("tfc", "textures/gui/knapping/clay_button_fire.png");
    public static final ResourceLocation LEATHER_TEXTURE = new ResourceLocation("tfc", "textures/gui/knapping/leather_button.png");
    public static final ResourceLocation QUIVER_BACKGROUND = new ResourceLocation("tfc", "textures/gui/quiver_inventory.png");
    public static final ResourceLocation CLAY_DISABLED_TEXTURE = new ResourceLocation("tfc", "textures/gui/knapping/clay_button_disabled.png");
    public static final ResourceLocation FIRE_CLAY_DISABLED_TEXTURE = new ResourceLocation("tfc", "textures/gui/knapping/clay_button_fire_disabled.png");

    public static void openGui(World world, BlockPos pos, EntityPlayer player, Type type) {
        player.openGui((Object)TerraFirmaCraft.getInstance(), type.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void openGui(World world, EntityPlayer player, Type type) {
        player.openGui((Object)TerraFirmaCraft.getInstance(), type.ordinal(), world, 0, 0, 0);
    }

    @Nullable
    public Container getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        ItemStack stack = player.func_184614_ca();
        Type type = Type.valueOf(ID);
        switch (type) {
            case NEST_BOX: {
                TENestBox teNestBox = Helpers.getTE((IBlockAccess)world, pos, TENestBox.class);
                return teNestBox == null ? null : new ContainerNestBox(player.field_71071_by, teNestBox);
            }
            case LOG_PILE: {
                TELogPile teLogPile = Helpers.getTE((IBlockAccess)world, pos, TELogPile.class);
                return teLogPile == null ? null : new ContainerLogPile(player.field_71071_by, teLogPile);
            }
            case SMALL_VESSEL: {
                return new ContainerSmallVessel(player.field_71071_by, stack.func_77973_b() instanceof ItemSmallVessel ? stack : player.func_184592_cb());
            }
            case SMALL_VESSEL_LIQUID: {
                return new ContainerLiquidTransfer(player.field_71071_by, stack.func_77973_b() instanceof ItemSmallVessel ? stack : player.func_184592_cb());
            }
            case MOLD: {
                return new ContainerLiquidTransfer(player.field_71071_by, stack.func_77973_b() instanceof ItemMold ? stack : player.func_184592_cb());
            }
            case FIRE_PIT: {
                return new ContainerFirePit(player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TEFirePit.class));
            }
            case BARREL: {
                return new ContainerBarrel(player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TEBarrel.class));
            }
            case CHARCOAL_FORGE: {
                return new ContainerCharcoalForge(player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TECharcoalForge.class));
            }
            case ANVIL: {
                return new ContainerAnvilTFC(player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TEAnvilTFC.class));
            }
            case ANVIL_PLAN: {
                return new ContainerAnvilPlan(player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TEAnvilTFC.class));
            }
            case KNAPPING_STONE: {
                return new ContainerKnapping(KnappingType.STONE, player.field_71071_by, stack.func_77973_b() instanceof ItemRock ? stack : player.func_184592_cb());
            }
            case KNAPPING_CLAY: {
                return new ContainerKnapping(KnappingType.CLAY, player.field_71071_by, OreDictionaryHelper.doesStackMatchOre(stack, "clay") ? stack : player.func_184592_cb());
            }
            case KNAPPING_LEATHER: {
                return new ContainerKnapping(KnappingType.LEATHER, player.field_71071_by, OreDictionaryHelper.doesStackMatchOre(stack, "leather") ? stack : player.func_184592_cb());
            }
            case KNAPPING_FIRE_CLAY: {
                return new ContainerKnapping(KnappingType.FIRE_CLAY, player.field_71071_by, OreDictionaryHelper.doesStackMatchOre(stack, "fireClay") ? stack : player.func_184592_cb());
            }
            case CRUCIBLE: {
                return new ContainerCrucible(player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TECrucible.class));
            }
            case LARGE_VESSEL: {
                return new ContainerLargeVessel(player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TELargeVessel.class));
            }
            case POWDERKEG: {
                return new ContainerPowderKeg(player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TEPowderKeg.class));
            }
            case CALENDAR: 
            case SKILLS: 
            case NUTRITION: {
                return new ContainerSimple(player.field_71071_by);
            }
            case BLAST_FURNACE: {
                return new ContainerBlastFurnace(player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TEBlastFurnace.class));
            }
            case CRAFTING: {
                return new ContainerInventoryCrafting(player.field_71071_by, player.field_70170_p);
            }
            case QUIVER: {
                return new ContainerQuiver(player.field_71071_by, stack.func_77973_b() instanceof ItemQuiver ? stack : player.func_184592_cb());
            }
            case CHEST: {
                if (world.func_180495_p(pos).func_177230_c() instanceof BlockChestTFC) {
                    ILockableContainer chestContainer = ((BlockChestTFC)world.func_180495_p(pos).func_177230_c()).func_180676_d(world, pos);
                    return new ContainerChestTFC((IInventory)player.field_71071_by, (IInventory)chestContainer, player);
                }
                return null;
            }
            case SALAD: {
                return new ContainerSalad(player.field_71071_by);
            }
        }
        return null;
    }

    @Nullable
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        Container container = this.getServerGuiElement(ID, player, world, x, y, z);
        Type type = Type.valueOf(ID);
        BlockPos pos = new BlockPos(x, y, z);
        switch (type) {
            case NEST_BOX: 
            case LOG_PILE: 
            case SMALL_VESSEL: {
                return new GuiContainerTFC(container, player.field_71071_by, SMALL_INVENTORY_BACKGROUND);
            }
            case SMALL_VESSEL_LIQUID: {
                return new GuiLiquidTransfer(container, player, player.func_184614_ca().func_77973_b() instanceof ItemSmallVessel);
            }
            case MOLD: {
                return new GuiLiquidTransfer(container, player, player.func_184614_ca().func_77973_b() instanceof ItemMold);
            }
            case FIRE_PIT: {
                return new GuiFirePit(container, player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TEFirePit.class));
            }
            case BARREL: {
                return new GuiBarrel(container, player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TEBarrel.class), world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().func_149739_a());
            }
            case CHARCOAL_FORGE: {
                return new GuiCharcoalForge(container, player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TECharcoalForge.class));
            }
            case ANVIL: {
                return new GuiAnvilTFC(container, player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TEAnvilTFC.class));
            }
            case ANVIL_PLAN: {
                return new GuiAnvilPlan(container, player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TEAnvilTFC.class));
            }
            case KNAPPING_STONE: {
                ItemStack stack = player.func_184614_ca();
                Rock rock = stack.func_77973_b() instanceof IRockObject ? ((IRockObject)stack.func_77973_b()).getRock(stack) : ((IRockObject)player.func_184592_cb().func_77973_b()).getRock(player.func_184592_cb());
                return new GuiKnapping(container, player, KnappingType.STONE, rock.getTexture());
            }
            case KNAPPING_CLAY: {
                return new GuiKnapping(container, player, KnappingType.CLAY, CLAY_TEXTURE);
            }
            case KNAPPING_LEATHER: {
                return new GuiKnapping(container, player, KnappingType.LEATHER, LEATHER_TEXTURE);
            }
            case KNAPPING_FIRE_CLAY: {
                return new GuiKnapping(container, player, KnappingType.FIRE_CLAY, FIRE_CLAY_TEXTURE);
            }
            case CRUCIBLE: {
                return new GuiCrucible(container, player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TECrucible.class));
            }
            case LARGE_VESSEL: {
                return new GuiLargeVessel(container, player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TELargeVessel.class), world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().func_149739_a());
            }
            case POWDERKEG: {
                return new GuiPowderkeg(container, player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TEPowderKeg.class), world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().func_149739_a());
            }
            case CALENDAR: {
                return new GuiCalendar(container, player.field_71071_by);
            }
            case NUTRITION: {
                return new GuiNutrition(container, player.field_71071_by);
            }
            case SKILLS: {
                return new GuiSkills(container, player.field_71071_by);
            }
            case BLAST_FURNACE: {
                return new GuiBlastFurnace(container, player.field_71071_by, Helpers.getTE((IBlockAccess)world, pos, TEBlastFurnace.class));
            }
            case CRAFTING: {
                return new GuiInventoryCrafting(container);
            }
            case QUIVER: {
                return new GuiContainerTFC(container, player.field_71071_by, QUIVER_BACKGROUND);
            }
            case CHEST: {
                if (container instanceof ContainerChestTFC) {
                    return new GuiChestTFC((ContainerChestTFC)container, player.field_71071_by);
                }
                return null;
            }
            case SALAD: {
                return new GuiSalad(container, player.field_71071_by);
            }
        }
        return null;
    }

    public static enum Type {
        NEST_BOX,
        LOG_PILE,
        SMALL_VESSEL,
        SMALL_VESSEL_LIQUID,
        MOLD,
        FIRE_PIT,
        BARREL,
        KNAPPING_STONE,
        KNAPPING_CLAY,
        KNAPPING_FIRE_CLAY,
        KNAPPING_LEATHER,
        CHARCOAL_FORGE,
        ANVIL,
        ANVIL_PLAN,
        CRUCIBLE,
        BLAST_FURNACE,
        LARGE_VESSEL,
        POWDERKEG,
        CALENDAR,
        NUTRITION,
        SKILLS,
        CHEST,
        SALAD,
        INVENTORY,
        CRAFTING,
        QUIVER,
        NULL;

        private static final Type[] values;

        @Nonnull
        public static Type valueOf(int id) {
            return id < 0 || id >= values.length ? NULL : values[id];
        }

        static {
            values = Type.values();
        }
    }
}

