/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.animal;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@ParametersAreNonnullByDefault
public class ModelParrotTFC
extends ModelBase {
    private final ModelRenderer body;
    private final ModelRenderer tail;
    private final ModelRenderer wingLeft;
    private final ModelRenderer wingRight;
    private final ModelRenderer head;
    private final ModelRenderer feather;
    private final ModelRenderer legLeft;
    private final ModelRenderer legRight;
    private State state = State.STANDING;

    public ModelParrotTFC() {
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.body = new ModelRenderer((ModelBase)this, 2, 8);
        this.body.func_78789_a(-1.5f, 0.0f, -1.5f, 3, 6, 3);
        this.body.func_78793_a(0.0f, 16.5f, -3.0f);
        this.tail = new ModelRenderer((ModelBase)this, 22, 1);
        this.tail.func_78789_a(-1.5f, -1.0f, -1.0f, 3, 4, 1);
        this.tail.func_78793_a(0.0f, 21.07f, 1.16f);
        this.wingLeft = new ModelRenderer((ModelBase)this, 19, 8);
        this.wingLeft.func_78789_a(-0.5f, 0.0f, -1.5f, 1, 5, 3);
        this.wingLeft.func_78793_a(1.5f, 16.94f, -2.76f);
        this.wingRight = new ModelRenderer((ModelBase)this, 19, 8);
        this.wingRight.func_78789_a(-0.5f, 0.0f, -1.5f, 1, 5, 3);
        this.wingRight.func_78793_a(-1.5f, 16.94f, -2.76f);
        this.head = new ModelRenderer((ModelBase)this, 2, 2);
        this.head.func_78789_a(-1.0f, -1.5f, -1.0f, 2, 3, 2);
        this.head.func_78793_a(0.0f, 15.69f, -2.76f);
        ModelRenderer head2 = new ModelRenderer((ModelBase)this, 10, 0);
        head2.func_78789_a(-1.0f, -0.5f, -2.0f, 2, 1, 4);
        head2.func_78793_a(0.0f, -2.0f, -1.0f);
        this.head.func_78792_a(head2);
        ModelRenderer beak1 = new ModelRenderer((ModelBase)this, 11, 7);
        beak1.func_78789_a(-0.5f, -1.0f, -0.5f, 1, 2, 1);
        beak1.func_78793_a(0.0f, -0.5f, -1.5f);
        this.head.func_78792_a(beak1);
        ModelRenderer beak2 = new ModelRenderer((ModelBase)this, 16, 7);
        beak2.func_78789_a(-0.5f, 0.0f, -0.5f, 1, 2, 1);
        beak2.func_78793_a(0.0f, -1.75f, -2.45f);
        this.head.func_78792_a(beak2);
        this.feather = new ModelRenderer((ModelBase)this, 2, 18);
        this.feather.func_78789_a(0.0f, -4.0f, -2.0f, 0, 5, 4);
        this.feather.func_78793_a(0.0f, -2.15f, 0.15f);
        this.head.func_78792_a(this.feather);
        this.legLeft = new ModelRenderer((ModelBase)this, 14, 18);
        this.legLeft.func_78789_a(-0.5f, 0.0f, -0.5f, 1, 2, 1);
        this.legLeft.func_78793_a(1.0f, 22.0f, -1.05f);
        this.legRight = new ModelRenderer((ModelBase)this, 14, 18);
        this.legRight.func_78789_a(-0.5f, 0.0f, -0.5f, 1, 2, 1);
        this.legRight.func_78793_a(-1.0f, 22.0f, -1.05f);
    }

    public void func_78088_a(@Nonnull Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entity);
        if (((EntityAnimal)entity).func_70631_g_()) {
            double ageScale = 1.0;
            double percent = 1.0;
            if (entity instanceof IAnimalTFC) {
                percent = ((IAnimalTFC)entity).getPercentToAdulthood();
                ageScale = 1.0 / (2.0 - percent);
            }
            GlStateManager.func_179139_a((double)ageScale, (double)ageScale, (double)ageScale);
            GlStateManager.func_179137_b((double)0.0, (double)(1.5 - 1.5 * percent), (double)0.0);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)1.0);
        this.body.func_78785_a(scale);
        this.wingLeft.func_78785_a(scale);
        this.wingRight.func_78785_a(scale);
        this.tail.func_78785_a(scale);
        this.head.func_78785_a(scale);
        this.legLeft.func_78785_a(scale);
        this.legRight.func_78785_a(scale);
        GlStateManager.func_179121_F();
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        float f = ageInTicks * 0.3f;
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78808_h = 0.0f;
        this.head.field_78800_c = 0.0f;
        this.body.field_78800_c = 0.0f;
        this.tail.field_78800_c = 0.0f;
        this.wingRight.field_78800_c = -1.5f;
        this.wingLeft.field_78800_c = 1.5f;
        if (this.state != State.FLYING) {
            if (this.state == State.SITTING) {
                return;
            }
            if (this.state == State.PARTY) {
                float f1 = MathHelper.func_76134_b((float)entityIn.field_70173_aa);
                float f2 = MathHelper.func_76126_a((float)entityIn.field_70173_aa);
                this.head.field_78800_c = f1;
                this.head.field_78797_d = 15.69f + f2;
                this.head.field_78795_f = 0.0f;
                this.head.field_78796_g = 0.0f;
                this.head.field_78808_h = MathHelper.func_76126_a((float)entityIn.field_70173_aa) * 0.4f;
                this.body.field_78800_c = f1;
                this.body.field_78797_d = 16.5f + f2;
                this.wingLeft.field_78808_h = -0.0873f - ageInTicks;
                this.wingLeft.field_78800_c = 1.5f + f1;
                this.wingLeft.field_78797_d = 16.94f + f2;
                this.wingRight.field_78808_h = 0.0873f + ageInTicks;
                this.wingRight.field_78800_c = -1.5f + f1;
                this.wingRight.field_78797_d = 16.94f + f2;
                this.tail.field_78800_c = f1;
                this.tail.field_78797_d = 21.07f + f2;
                return;
            }
            ModelRenderer var10000 = this.legLeft;
            var10000.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            var10000 = this.legRight;
            var10000.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        this.head.field_78797_d = 15.69f + f;
        this.tail.field_78795_f = 1.015f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 0.3f * limbSwingAmount;
        this.tail.field_78797_d = 21.07f + f;
        this.body.field_78797_d = 16.5f + f;
        this.wingLeft.field_78808_h = -0.0873f - ageInTicks;
        this.wingLeft.field_78797_d = 16.94f + f;
        this.wingRight.field_78808_h = 0.0873f + ageInTicks;
        this.wingRight.field_78797_d = 16.94f + f;
        this.legLeft.field_78797_d = 22.0f + f;
        this.legRight.field_78797_d = 22.0f + f;
    }

    public void func_78086_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.feather.field_78795_f = -0.2214f;
        this.body.field_78795_f = 0.4937f;
        this.wingLeft.field_78795_f = -0.69813174f;
        this.wingLeft.field_78796_g = (float)(-Math.PI);
        this.wingRight.field_78795_f = -0.69813174f;
        this.wingRight.field_78796_g = (float)(-Math.PI);
        this.legLeft.field_78795_f = -0.0299f;
        this.legRight.field_78795_f = -0.0299f;
        this.legLeft.field_78797_d = 22.0f;
        this.legRight.field_78797_d = 22.0f;
        if (entitylivingbaseIn instanceof EntityParrot) {
            EntityParrot entityparrot = (EntityParrot)entitylivingbaseIn;
            if (entityparrot.func_192004_dr()) {
                this.legLeft.field_78808_h = -0.34906584f;
                this.legRight.field_78808_h = 0.34906584f;
                this.state = State.PARTY;
                return;
            }
            if (entityparrot.func_70906_o()) {
                this.head.field_78797_d = 17.59f;
                this.tail.field_78795_f = 1.5388988f;
                this.tail.field_78797_d = 22.97f;
                this.body.field_78797_d = 18.4f;
                this.wingLeft.field_78808_h = -0.0873f;
                this.wingLeft.field_78797_d = 18.84f;
                this.wingRight.field_78808_h = 0.0873f;
                this.wingRight.field_78797_d = 18.84f;
                this.legLeft.field_78797_d += 1.0f;
                this.legRight.field_78797_d += 1.0f;
                this.legLeft.field_78795_f += 1.0f;
                this.legRight.field_78795_f += 1.0f;
                this.state = State.SITTING;
            } else if (entityparrot.func_192002_a()) {
                ModelRenderer var10000 = this.legLeft;
                var10000.field_78795_f += 0.69813174f;
                var10000 = this.legRight;
                var10000.field_78795_f += 0.69813174f;
                this.state = State.FLYING;
            } else {
                this.state = State.STANDING;
            }
            this.legLeft.field_78808_h = 0.0f;
            this.legRight.field_78808_h = 0.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    static enum State {
        FLYING,
        STANDING,
        SITTING,
        PARTY;

    }
}

