/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.animal;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import net.dries007.tfc.client.model.animal.ModelHorseTFC;
import net.dries007.tfc.objects.entity.animal.EntityDonkeyTFC;
import net.dries007.tfc.objects.entity.animal.EntityMuleTFC;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderAbstractHorseTFC
extends RenderLiving<AbstractHorse> {
    private static final Map<Class<?>, ResourceLocation> MAP = Maps.newHashMap();
    private final float scale;

    public RenderAbstractHorseTFC(RenderManager manager) {
        this(manager, 1.0f);
    }

    public RenderAbstractHorseTFC(RenderManager renderManagerIn, float scaleIn) {
        super(renderManagerIn, (ModelBase)new ModelHorseTFC(), 0.75f);
        this.scale = scaleIn;
    }

    protected void preRenderCallback(@Nonnull AbstractHorse entitylivingbaseIn, float partialTickTime) {
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
        super.func_77041_b((EntityLivingBase)entitylivingbaseIn, partialTickTime);
    }

    protected ResourceLocation getEntityTexture(AbstractHorse entity) {
        return MAP.get(entity.getClass());
    }

    static {
        MAP.put(EntityDonkeyTFC.class, new ResourceLocation("textures/entity/horse/donkey.png"));
        MAP.put(EntityMuleTFC.class, new ResourceLocation("textures/entity/horse/mule.png"));
    }
}

