/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.animal;

import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.client.model.animal.ModelChickenTFC;
import net.dries007.tfc.objects.entity.animal.EntityChickenTFC;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@ParametersAreNonnullByDefault
public class RenderChickenTFC
extends RenderLiving<EntityChickenTFC> {
    private static final ResourceLocation CHICKEN_YOUNG = new ResourceLocation("tfc", "textures/entity/animal/livestock/chicken_young.png");
    private static final ResourceLocation CHICKEN_OLD = new ResourceLocation("tfc", "textures/entity/animal/livestock/chicken_old.png");
    private static final ResourceLocation ROOSTER_YOUNG = new ResourceLocation("tfc", "textures/entity/animal/livestock/rooster_young.png");
    private static final ResourceLocation ROOSTER_OLD = new ResourceLocation("tfc", "textures/entity/animal/livestock/rooster_old.png");
    private static final ResourceLocation CHICK_TEXTURE = new ResourceLocation("tfc", "textures/entity/animal/livestock/chick.png");

    public RenderChickenTFC(RenderManager manager) {
        super(manager, (ModelBase)new ModelChickenTFC(), 0.3f);
    }

    public void doRender(EntityChickenTFC chicken, double par2, double par4, double par6, float par8, float par9) {
        this.field_76989_e = (float)((double)0.15f + chicken.getPercentToAdulthood() * (double)0.15f);
        super.func_76986_a((EntityLiving)chicken, par2, par4, par6, par8, par9);
    }

    protected ResourceLocation getEntityTexture(EntityChickenTFC chicken) {
        float percent = (float)chicken.getPercentToAdulthood();
        if (percent < 0.65f) {
            return CHICK_TEXTURE;
        }
        if (chicken.getGender() == IAnimalTFC.Gender.MALE) {
            return chicken.getAge() == IAnimalTFC.Age.OLD ? ROOSTER_OLD : ROOSTER_YOUNG;
        }
        return chicken.getAge() == IAnimalTFC.Age.OLD ? CHICKEN_OLD : CHICKEN_YOUNG;
    }

    protected float handleRotationFloat(EntityChickenTFC livingBase, float partialTicks) {
        float f = livingBase.oFlap + (livingBase.wingRotation - livingBase.oFlap) * partialTicks;
        float f1 = livingBase.oFlapSpeed + (livingBase.destPos - livingBase.oFlapSpeed) * partialTicks;
        return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
    }

    protected void preRenderCallback(EntityChickenTFC bear, float par2) {
        GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
    }
}

