/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.animal;

import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.client.model.animal.ModelDuckTFC;
import net.dries007.tfc.objects.entity.animal.EntityDuckTFC;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@ParametersAreNonnullByDefault
public class RenderDuckTFC
extends RenderLiving<EntityDuckTFC> {
    private static final ResourceLocation DUCK_OLD = new ResourceLocation("tfc", "textures/entity/animal/livestock/duck_old.png");
    private static final ResourceLocation DUCK_YOUNG = new ResourceLocation("tfc", "textures/entity/animal/livestock/duck_young.png");
    private static final ResourceLocation DRAKE_OLD = new ResourceLocation("tfc", "textures/entity/animal/livestock/drake_old.png");
    private static final ResourceLocation DRAKE_YOUNG = new ResourceLocation("tfc", "textures/entity/animal/livestock/drake_young.png");
    private static final ResourceLocation DUCKLING_TEXTURE = new ResourceLocation("tfc", "textures/entity/animal/livestock/duckling.png");

    public RenderDuckTFC(RenderManager manager) {
        super(manager, (ModelBase)new ModelDuckTFC(), 0.3f);
    }

    public void doRender(EntityDuckTFC duck, double par2, double par4, double par6, float par8, float par9) {
        this.field_76989_e = (float)((double)0.15f + duck.getPercentToAdulthood() * (double)0.15f);
        super.func_76986_a((EntityLiving)duck, par2, par4, par6, par8, par9);
    }

    protected ResourceLocation getEntityTexture(EntityDuckTFC duck) {
        float percent = (float)duck.getPercentToAdulthood();
        if (percent < 0.65f) {
            return DUCKLING_TEXTURE;
        }
        if (duck.getGender() == IAnimalTFC.Gender.MALE) {
            return duck.getAge() == IAnimalTFC.Age.OLD ? DRAKE_OLD : DRAKE_YOUNG;
        }
        return duck.getAge() == IAnimalTFC.Age.OLD ? DUCK_OLD : DUCK_YOUNG;
    }

    protected float handleRotationFloat(EntityDuckTFC livingBase, float partialTicks) {
        float f = livingBase.oFlap + (livingBase.wingRotation - livingBase.oFlap) * partialTicks;
        float f1 = livingBase.oFlapSpeed + (livingBase.destPos - livingBase.oFlapSpeed) * partialTicks;
        return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
    }

    protected void preRenderCallback(EntityDuckTFC bear, float par2) {
        GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
    }
}

