/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.command;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class CommandDebugInfo
extends CommandBase {
    private static final Logger LOGGER = LogManager.getLogger((String)"tfc-infodump");

    @Nonnull
    public String func_71517_b() {
        return "tfcdebuginfodump";
    }

    @Nonnull
    public String func_71518_a(ICommandSender sender) {
        return "tfc.command.debuginfo.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        World world = sender.func_130014_f_();
        BlockPos pos = sender.func_180425_c();
        ChunkDataTFC chunkData = ChunkDataTFC.get(world, pos);
        LOGGER.info("ROCK LAYER DATA");
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                LOGGER.info("Pos: {} {} - Rock 1: {}, Rock 2: {}, Rock 3: {}", (Object)x, (Object)z, (Object)chunkData.getRock1(x, z), (Object)chunkData.getRock2(x, z), (Object)chunkData.getRock3(x, z));
            }
        }
        LOGGER.info("RAW CHUNK DATA VIEW");
        NBTBase nbt = ChunkDataProvider.CHUNK_DATA_CAPABILITY.writeNBT((Object)chunkData, null);
        LOGGER.info(nbt == null ? "writeNBT returned null" : nbt.toString());
        LOGGER.info("ROCK REGISTRY");
        for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
            LOGGER.info("Rock: {} -> Id: {}", (Object)rock.getRegistryName().func_110623_a(), (Object)((ForgeRegistry)TFCRegistries.ROCKS).getID((IForgeRegistryEntry)rock));
        }
    }
}

