/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.command;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.food.FoodData;
import net.dries007.tfc.api.capability.food.FoodStatsTFC;
import net.dries007.tfc.api.capability.food.IFoodStatsTFC;
import net.dries007.tfc.api.capability.food.Nutrient;
import net.dries007.tfc.api.capability.food.NutritionStats;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.skills.Skill;
import net.dries007.tfc.util.skills.SkillType;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

@ParametersAreNonnullByDefault
public class CommandPlayerTFC
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "playertfc";
    }

    @Nonnull
    public String func_71518_a(ICommandSender sender) {
        return "tfc.command.playertfc.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender.func_174793_f() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender.func_174793_f();
            if (args.length < 1) {
                throw new WrongUsageException("tfc.command.playertfc.usage_expected_first_argument", new Object[0]);
            }
            ExecuteType executeType = ExecuteType.parse(args[0]);
            if (args.length < 2) {
                throw new WrongUsageException("tfc.command.playertfc.usage_expected_second_argument", new Object[]{args[0]});
            }
            switch (args[1]) {
                case "nutrition": {
                    this.executeNutrient(sender, player, executeType);
                    break;
                }
                case "skill": {
                    this.executeSkill(sender, player, args, executeType);
                    break;
                }
                case "food": {
                    this.executeFood(sender, player, args, executeType);
                    break;
                }
                case "saturation": {
                    this.executeSaturation(sender, player, args, executeType);
                    break;
                }
                case "water": {
                    this.executeWater(sender, player, args, executeType);
                    break;
                }
                default: {
                    throw new WrongUsageException("tfc.command.playertfc.usage_expected_second_argument", new Object[]{args[0]});
                }
            }
        } else {
            throw new WrongUsageException("tfc.command.playertfc.usage_needs_player", new Object[0]);
        }
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandPlayerTFC.func_71530_a((String[])args, (String[])new String[]{"get", "set", "reset", "add"});
        }
        if (args.length == 2) {
            return CommandPlayerTFC.func_71530_a((String[])args, (String[])new String[]{"nutrition", "skill", "food", "saturation", "water"});
        }
        if (args.length == 3 && "skill".equals(args[2])) {
            return CommandPlayerTFC.func_175762_a((String[])args, (Collection)SkillType.getSkills().stream().map(s -> s.getName().toLowerCase()).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    private void executeNutrient(ICommandSender sender, EntityPlayer player, ExecuteType executeType) throws CommandException {
        NutritionStats nutritionStats = ((IFoodStatsTFC)player.func_71024_bL()).getNutrition();
        if (executeType == ExecuteType.SET || executeType == ExecuteType.ADD) {
            throw new WrongUsageException("tfc.command.playertfc.usage_cant_set_add_nutrients", new Object[0]);
        }
        if (executeType == ExecuteType.RESET) {
            nutritionStats.reset();
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.reset_nutrients", new Object[0]));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.get_nutrients", new Object[]{String.format("%.2f", Float.valueOf(nutritionStats.getAverageNutrition()))}));
            for (Nutrient nutrient : Nutrient.values()) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.get_nutrients_nutrient", new Object[]{new TextComponentTranslation(Helpers.getEnumName(nutrient), new Object[0]), String.format("%.2f", Float.valueOf(nutritionStats.getNutrient(nutrient)))}));
            }
            FoodData lastRecord = nutritionStats.getMostRecentRecord();
            if (lastRecord != null) {
                float[] nutrients = lastRecord.getNutrients();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.get_nutrients_last_eaten", new Object[]{lastRecord.getHunger(), String.format("%.2f", Float.valueOf(lastRecord.getSaturation())), String.format("%.2f", Float.valueOf(lastRecord.getDecayModifier()))}));
                for (Nutrient nutrient : Nutrient.values()) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.get_nutrients_last_eaten_nutrient", new Object[]{new TextComponentTranslation(Helpers.getEnumName(nutrient), new Object[0]), String.format("%.2f", Float.valueOf(nutrients[nutrient.ordinal()]))}));
                }
            }
        }
    }

    private void executeSkill(ICommandSender sender, EntityPlayer player, String[] args, ExecuteType executeType) throws CommandException {
        if (args.length < 3) {
            throw new WrongUsageException("tfc.command.playertfc.usage_expected_id", new Object[]{args[0] + " " + args[1]});
        }
        SkillType<Skill> inputSkill = SkillType.get(args[2].toLowerCase(), Skill.class);
        if (inputSkill == null) {
            throw new WrongUsageException("tfc.command.playertfc.usage_unknown_skill", new Object[]{args[2]});
        }
        Skill skill = CapabilityPlayerData.getSkill(player, inputSkill);
        if (skill != null) {
            if (executeType == ExecuteType.GET) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.get_skill", new Object[]{inputSkill.getName(), Float.valueOf(skill.getTotalLevel()), new TextComponentTranslation(Helpers.getEnumName(skill.getTier()), new Object[0]), Float.valueOf(skill.getLevel())}));
            } else if (executeType == ExecuteType.RESET) {
                skill.setTotalLevel(0.0);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.set_skill", new Object[]{inputSkill.getName(), 0}));
            } else {
                if (args.length < 4) {
                    throw new WrongUsageException("tfc.command.playertfc.usage_expected_value", new Object[]{args[0] + " " + args[1] + " " + args[2]});
                }
                double level = CommandPlayerTFC.func_175756_a((String)args[3], (double)0.0, (double)4.0);
                if (executeType == ExecuteType.ADD) {
                    skill.addTotalLevel(level / 4.0);
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.add_skill", new Object[]{level, inputSkill.getName()}));
                } else {
                    skill.setTotalLevel(level / 4.0);
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.set_skill", new Object[]{inputSkill.getName(), level}));
                }
            }
        }
    }

    private void executeFood(ICommandSender sender, EntityPlayer player, String[] args, ExecuteType executeType) throws CommandException {
        FoodStats foodStats = player.func_71024_bL();
        if (executeType == ExecuteType.GET) {
            int food = foodStats.func_75116_a();
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.get_food", new Object[]{food}));
        } else if (executeType == ExecuteType.RESET) {
            foodStats.func_75114_a(20);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.set_food", new Object[]{20}));
        } else {
            if (args.length < 3) {
                throw new WrongUsageException("tfc.command.playertfc.usage_expected_value", new Object[]{args[0] + " " + args[1]});
            }
            int value = CommandPlayerTFC.func_175764_a((String)args[2], (int)0, (int)20);
            if (executeType == ExecuteType.SET) {
                foodStats.func_75114_a(value);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.set_food", new Object[]{value}));
            } else if (executeType == ExecuteType.ADD) {
                value += foodStats.func_75116_a();
                value = MathHelper.func_76125_a((int)value, (int)0, (int)20);
                foodStats.func_75114_a(value);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.set_food", new Object[]{value}));
            }
        }
    }

    private void executeSaturation(ICommandSender sender, EntityPlayer player, String[] args, ExecuteType executeType) throws CommandException {
        FoodStatsTFC foodStats = (FoodStatsTFC)player.func_71024_bL();
        if (executeType == ExecuteType.GET) {
            float saturation = foodStats.func_75115_e();
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.get_saturation", new Object[]{Float.valueOf(saturation)}));
        } else if (executeType == ExecuteType.RESET) {
            foodStats.setSaturation(0.0f);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.set_saturation", new Object[]{0}));
        } else {
            if (args.length < 3) {
                throw new WrongUsageException("tfc.command.playertfc.usage_expected_value", new Object[]{args[0] + " " + args[1]});
            }
            int value = CommandPlayerTFC.func_175764_a((String)args[2], (int)0, (int)20);
            if (executeType == ExecuteType.SET) {
                foodStats.setSaturation(value);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.set_saturation", new Object[]{value}));
            } else if (executeType == ExecuteType.ADD) {
                value = (int)((float)value + foodStats.func_75115_e());
                value = MathHelper.func_76125_a((int)value, (int)0, (int)20);
                foodStats.setSaturation(value);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.set_saturation", new Object[]{value}));
            }
        }
    }

    private void executeWater(ICommandSender sender, EntityPlayer player, String[] args, ExecuteType executeType) throws CommandException {
        IFoodStatsTFC foodStats = (IFoodStatsTFC)player.func_71024_bL();
        if (executeType == ExecuteType.GET) {
            float thirst = foodStats.getThirst();
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.get_water", new Object[]{Float.valueOf(thirst)}));
        } else if (executeType == ExecuteType.RESET) {
            foodStats.setThirst(100.0f);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.set_water", new Object[]{100}));
        } else {
            if (args.length < 3) {
                throw new WrongUsageException("tfc.command.playertfc.usage_expected_value", new Object[]{args[0] + " " + args[1]});
            }
            float value = (float)CommandPlayerTFC.func_175756_a((String)args[2], (double)0.0, (double)100.0);
            if (executeType == ExecuteType.SET) {
                foodStats.setThirst(value);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.set_water", new Object[]{Float.valueOf(value)}));
            } else if (executeType == ExecuteType.ADD) {
                foodStats.addThirst(value);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.playertfc.set_water", new Object[]{Float.valueOf(value)}));
            }
        }
    }

    private static enum ExecuteType {
        SET,
        RESET,
        ADD,
        GET;


        static ExecuteType parse(String text) throws CommandException {
            try {
                return ExecuteType.valueOf(text.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new WrongUsageException("tfc.command.playertfc.usage_expected_first_argument", new Object[0]);
            }
        }
    }
}

