/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import net.dries007.tfc.api.recipes.AlloyRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.terrafirmacraft.Alloy")
@ZenRegister
public class CTAlloy {
    @ZenMethod
    public static CTAlloyRecipeBuilder addAlloy(String metal) {
        Metal result = TFCRegistries.METALS.getValuesCollection().stream().filter(x -> x.getRegistryName().func_110623_a().equalsIgnoreCase(metal)).findFirst().orElse(null);
        if (result == null) {
            throw new IllegalArgumentException("Metal specified not found!");
        }
        AlloyRecipe recipe = (AlloyRecipe)TFCRegistries.ALLOYS.getValue(result.getRegistryName());
        if (recipe != null) {
            throw new IllegalStateException("Alloy already has a recipe!");
        }
        return new CTAlloyRecipeBuilder(result);
    }

    @ZenMethod
    public static void removeAlloy(String metal) {
        Metal result = TFCRegistries.METALS.getValuesCollection().stream().filter(x -> x.getRegistryName().func_110623_a().equalsIgnoreCase(metal)).findFirst().orElse(null);
        if (result == null) {
            throw new IllegalArgumentException("Metal specified not found!");
        }
        final AlloyRecipe recipe = (AlloyRecipe)TFCRegistries.ALLOYS.getValue(result.getRegistryName());
        if (recipe != null) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.ALLOYS;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing alloy recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }

    @ZenClass(value="mods.terrafirmacraft.AlloyRecipeBuilder")
    public static class CTAlloyRecipeBuilder {
        private AlloyRecipe.Builder internal;

        public CTAlloyRecipeBuilder(Metal result) {
            this.internal = new AlloyRecipe.Builder(result);
        }

        @ZenMethod
        public CTAlloyRecipeBuilder addMetal(String metal, double min, double max) {
            Metal result = TFCRegistries.METALS.getValuesCollection().stream().filter(x -> x.getRegistryName().func_110623_a().equalsIgnoreCase(metal)).findFirst().orElse(null);
            if (result == null) {
                throw new IllegalArgumentException("Metal specified not found!");
            }
            this.internal = this.internal.add(result, min, max);
            return this;
        }

        @ZenMethod
        public void build() {
            final AlloyRecipe recipe = this.internal.build();
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    TFCRegistries.ALLOYS.register((IForgeRegistryEntry)recipe);
                }

                public String describe() {
                    return "Adding alloy recipe for " + recipe.getResult().getRegistryName().func_110623_a();
                }
            });
        }
    }
}

