/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import net.dries007.tfc.api.recipes.LoomRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.compat.crafttweaker.CTHelper;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.terrafirmacraft.Loom")
@ZenRegister
public class CTLoom {
    @ZenMethod
    public static void addRecipe(String registryName, crafttweaker.api.item.IIngredient input, IItemStack output, int steps, String loomTexture) {
        if (output == null || input == null) {
            throw new IllegalArgumentException("Input and output are not allowed to be empty");
        }
        if (input instanceof ILiquidStack) {
            throw new IllegalArgumentException("There is a fluid where it's supposed to be an item!");
        }
        IIngredient ingredient = CTHelper.getInternalIngredient(input);
        ItemStack outputStack = (ItemStack)output.getInternal();
        final LoomRecipe recipe = new LoomRecipe(new ResourceLocation(registryName), ingredient, outputStack, steps, new ResourceLocation(loomTexture));
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                TFCRegistries.LOOM.register((IForgeRegistryEntry)recipe);
            }

            public String describe() {
                return "Adding loom recipe " + recipe.getRegistryName().toString();
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (output == null) {
            throw new IllegalArgumentException("Output not allowed to be empty");
        }
        ItemStack item = (ItemStack)output.getInternal();
        ArrayList removeList = new ArrayList();
        TFCRegistries.LOOM.getValuesCollection().stream().filter(x -> ((ItemStack)x.getOutputs().get(0)).func_77969_a(item)).forEach(removeList::add);
        for (final LoomRecipe rem : removeList) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.LOOM;
                    modRegistry.remove(rem.getRegistryName());
                }

                public String describe() {
                    return "Removing loom recipe " + rem.getRegistryName().toString();
                }
            });
        }
    }

    @ZenMethod
    public static void removeRecipe(String registryName) {
        final LoomRecipe recipe = (LoomRecipe)TFCRegistries.LOOM.getValue(new ResourceLocation(registryName));
        if (recipe != null) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.LOOM;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing loom recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }
}

