/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.dries007.tfc.api.recipes.knapping.KnappingRecipe;
import net.dries007.tfc.api.recipes.knapping.KnappingRecipeStone;
import net.dries007.tfc.api.recipes.knapping.KnappingType;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.items.rock.ItemRock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.terrafirmacraft.StoneKnapping")
@ZenRegister
public class CTStoneKnapping {
    @ZenMethod
    public static void addRecipe(final String registryName, IItemStack[] output, String[] rocks, String ... pattern) {
        Function<Rock, ItemStack> rockOutputMapper;
        if (output == null) {
            throw new IllegalArgumentException("Input not allowed to be empty");
        }
        if (rocks == null || rocks.length != output.length) {
            throw new IllegalArgumentException("You must specify an output for each rock!");
        }
        if (pattern.length < 1 || pattern.length > 5) {
            throw new IllegalArgumentException("Pattern must be between 1 and 5 in length!");
        }
        if ("all".equalsIgnoreCase(rocks[0])) {
            ItemStack outputStack = (ItemStack)output[0].getInternal();
            rockOutputMapper = rockIn -> outputStack.func_77946_l();
        } else {
            HashMap<Rock, ItemStack> outputMap = new HashMap<Rock, ItemStack>(output.length);
            for (int i = 0; i < output.length; ++i) {
                Rock rock = (Rock)TFCRegistries.ROCKS.getValue(new ResourceLocation(rocks[i]));
                if (rock == null) {
                    rock = (Rock)TFCRegistries.ROCKS.getValue(new ResourceLocation("tfc", rocks[i]));
                }
                if (rock == null) {
                    throw new IllegalArgumentException("Unknown rock '" + (Object)((Object)rock) + "'.");
                }
                ItemStack outputStack = (ItemStack)output[i].getInternal();
                outputMap.put(rock, outputStack.func_77946_l());
            }
            rockOutputMapper = rockIn -> outputMap.getOrDefault(rockIn, ItemStack.field_190927_a);
        }
        final KnappingRecipe recipe = (KnappingRecipe)new KnappingRecipeStone(KnappingType.STONE, rockOutputMapper, pattern).setRegistryName(registryName);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                TFCRegistries.KNAPPING.register((IForgeRegistryEntry)recipe);
            }

            public String describe() {
                return "Registered stone knapping recipe with name " + registryName;
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (output == null) {
            throw new IllegalArgumentException("Output not allowed to be empty");
        }
        ItemStack item = (ItemStack)output.getInternal();
        List removeList = TFCRegistries.KNAPPING.getValuesCollection().stream().filter(x -> {
            if (x.getType() != KnappingType.STONE) {
                return false;
            }
            for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
                ItemStack outputStack = x.getOutput(new ItemStack((Item)ItemRock.get(rock)));
                if (outputStack == ItemStack.field_190927_a || !outputStack.func_77969_a(item)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        for (final KnappingRecipe rem : removeList) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.KNAPPING;
                    modRegistry.remove(rem.getRegistryName());
                }

                public String describe() {
                    return "Removing stone knapping recipe " + rem.getRegistryName().toString();
                }
            });
        }
    }

    @ZenMethod
    public static void removeRecipe(String registryName) {
        final KnappingRecipe recipe = (KnappingRecipe)TFCRegistries.KNAPPING.getValue(new ResourceLocation(registryName));
        if (recipe != null) {
            CraftTweakerAPI.apply((IAction)new IAction(){

                public void apply() {
                    IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.KNAPPING;
                    modRegistry.remove(recipe.getRegistryName());
                }

                public String describe() {
                    return "Removing stone knapping recipe " + recipe.getRegistryName().toString();
                }
            });
        }
    }
}

