/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.categories;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.dries007.tfc.compat.jei.BaseRecipeCategory;
import net.dries007.tfc.compat.jei.wrappers.BarrelRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class BarrelCategory
extends BaseRecipeCategory<BarrelRecipeWrapper> {
    private static final ResourceLocation ICONS = new ResourceLocation("tfc", "textures/gui/icons/jei.png");
    private static final ResourceLocation BARREL_TEXTURES = new ResourceLocation("tfc", "textures/gui/barrel.png");
    private final IDrawableStatic fluidSlotBackgroound;
    private final IDrawableStatic fluidSlot;
    private final IDrawableStatic slot;
    private final IDrawableStatic arrow;
    private final IDrawableAnimated arrowAnimated;

    public BarrelCategory(IGuiHelper helper, String Uid) {
        super((IDrawable)helper.createBlankDrawable(122, 62), Uid);
        this.fluidSlotBackgroound = helper.createDrawable(BARREL_TEXTURES, 7, 15, 18, 60);
        this.fluidSlot = helper.createDrawable(BARREL_TEXTURES, 176, 0, 18, 53);
        this.arrow = helper.createDrawable(ICONS, 0, 14, 22, 16);
        IDrawableStatic arrowAnimated = helper.createDrawable(ICONS, 22, 14, 22, 16);
        this.arrowAnimated = helper.createAnimatedDrawable(arrowAnimated, 80, IDrawableAnimated.StartDirection.LEFT, false);
        this.slot = helper.getSlotDrawable();
    }

    public void drawExtras(Minecraft minecraft) {
        this.fluidSlotBackgroound.draw(minecraft, 1, 1);
        this.fluidSlot.draw(minecraft, 1, 5);
        this.slot.draw(minecraft, 25, 22);
        this.arrow.draw(minecraft, 50, 22);
        this.arrowAnimated.draw(minecraft, 50, 22);
        this.slot.draw(minecraft, 79, 22);
        this.fluidSlotBackgroound.draw(minecraft, 103, 1);
        this.fluidSlot.draw(minecraft, 103, 5);
    }

    public void setRecipe(IRecipeLayout recipeLayout, BarrelRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputFluid;
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStackGroup = recipeLayout.getFluidStacks();
        int fluidSlot = 0;
        int itemSlot = 0;
        if (ingredients.getInputs(VanillaTypes.FLUID).size() > 0) {
            inputFluid = (List)ingredients.getInputs(VanillaTypes.FLUID).get(0);
            fluidStackGroup.init(fluidSlot, true, 6, 6, 8, 50, ((FluidStack)inputFluid.get((int)0)).amount, false, null);
            fluidStackGroup.set(fluidSlot, inputFluid);
            ++fluidSlot;
        }
        if (recipeWrapper.isFluidMixing()) {
            inputFluid = (List)ingredients.getInputs(VanillaTypes.FLUID).get(1);
            fluidStackGroup.init(fluidSlot, true, 26, 23, 16, 16, ((FluidStack)inputFluid.get((int)0)).amount, false, null);
            fluidStackGroup.set(fluidSlot, inputFluid);
            ++fluidSlot;
        } else {
            itemStackGroup.init(itemSlot, true, 25, 22);
            if (ingredients.getInputs(VanillaTypes.ITEM).size() > 0) {
                itemStackGroup.set(itemSlot, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
            }
            ++itemSlot;
        }
        if (ingredients.getOutputs(VanillaTypes.FLUID).size() > 0) {
            List outputFluid = (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0);
            fluidStackGroup.init(fluidSlot, false, 108, 6, 8, 50, ((FluidStack)outputFluid.get((int)0)).amount, false, null);
            fluidStackGroup.set(fluidSlot, outputFluid);
        }
        itemStackGroup.init(itemSlot, false, 79, 22);
        if (ingredients.getOutputs(VanillaTypes.ITEM).size() > 0) {
            itemStackGroup.set(itemSlot, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
    }
}

