/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.categories;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.dries007.tfc.compat.jei.BaseRecipeCategory;
import net.dries007.tfc.compat.jei.wrappers.SimpleRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
public class HeatCategory
extends BaseRecipeCategory<SimpleRecipeWrapper> {
    private static final ResourceLocation ICONS = new ResourceLocation("tfc", "textures/gui/icons/jei.png");
    private final IDrawableStatic slot;
    private final IDrawableStatic fire;
    private final IDrawableAnimated fireAnimated;

    public HeatCategory(IGuiHelper helper, String Uid) {
        super((IDrawable)helper.createBlankDrawable(120, 38), Uid);
        this.fire = helper.createDrawable(ICONS, 0, 0, 14, 14);
        IDrawableStatic arrowAnimated = helper.createDrawable(ICONS, 14, 0, 14, 14);
        this.fireAnimated = helper.createAnimatedDrawable(arrowAnimated, 160, IDrawableAnimated.StartDirection.TOP, true);
        this.slot = helper.getSlotDrawable();
    }

    public void drawExtras(Minecraft minecraft) {
        this.fire.draw(minecraft, 54, 16);
        this.fireAnimated.draw(minecraft, 54, 16);
        this.slot.draw(minecraft, 20, 16);
        this.slot.draw(minecraft, 84, 16);
    }

    public void setRecipe(IRecipeLayout recipeLayout, SimpleRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        itemStackGroup.init(0, true, 20, 16);
        itemStackGroup.init(1, false, 84, 16);
        itemStackGroup.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemStackGroup.set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

