/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.wrappers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.dries007.tfc.api.recipes.BloomeryRecipe;
import net.dries007.tfc.compat.jei.TFCJEIPlugin;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
public class BloomeryRecipeWrapper
implements IRecipeWrapper {
    private final List<ItemStack> ingredients = new ArrayList<ItemStack>();
    private final List<ItemStack> additives = new ArrayList<ItemStack>();
    private final ItemStack output;

    public BloomeryRecipeWrapper(BloomeryRecipe recipe) {
        TFCJEIPlugin.getAllIngredients().forEach(stack -> {
            if (recipe.isValidInput((ItemStack)stack)) {
                this.ingredients.add((ItemStack)stack);
            } else if (recipe.isValidAdditive((ItemStack)stack)) {
                this.additives.add((ItemStack)stack);
            }
        });
        this.output = recipe.getOutput();
    }

    public void getIngredients(IIngredients recipeIngredients) {
        ArrayList<List<ItemStack>> allInputs = new ArrayList<List<ItemStack>>();
        allInputs.add(this.ingredients);
        allInputs.add(this.additives);
        recipeIngredients.setInputLists(VanillaTypes.ITEM, allInputs);
        ArrayList<ArrayList> allOutputs = new ArrayList<ArrayList>();
        allOutputs.add(Lists.newArrayList((Object[])new ItemStack[]{this.output}));
        recipeIngredients.setOutputLists(VanillaTypes.ITEM, allOutputs);
    }
}

