/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.wrappers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.stone.BlockOreTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.items.metal.ItemOreTFC;
import net.dries007.tfc.objects.items.metal.ItemSmallOre;
import net.dries007.tfc.world.classic.worldgen.vein.VeinType;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class VeinWrapper
implements IRecipeWrapper {
    private final VeinType veinType;
    private final List<ItemStack> rockBlocks;
    private final List<ItemStack> oreItems;

    public VeinWrapper(VeinType vein) {
        this.veinType = vein;
        this.rockBlocks = TFCRegistries.ROCKS.getValuesCollection().stream().filter(vein::canSpawnIn).map(rock -> new ItemStack((Block)BlockRockVariant.get(rock, Rock.Type.RAW))).collect(Collectors.toList());
        if (this.veinType.getOre() != null) {
            Ore ore = this.veinType.getOre();
            this.oreItems = TFCRegistries.ROCKS.getValuesCollection().stream().map(r -> new ItemStack((Block)BlockOreTFC.get(ore, r))).collect(Collectors.toList());
            if (ore.isGraded()) {
                for (Ore.Grade grade : Ore.Grade.values()) {
                    this.oreItems.add(ItemOreTFC.get(ore, grade, 1));
                }
                this.oreItems.add(ItemSmallOre.get(ore, 1));
            } else {
                this.oreItems.add(ItemOreTFC.get(ore, 1));
            }
        } else {
            IBlockState state = this.veinType.getOreState(Rock.GRANITE, Ore.Grade.NORMAL);
            this.oreItems = Collections.singletonList(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)));
        }
    }

    public void getIngredients(IIngredients recipeIngredients) {
        recipeIngredients.setInputs(VanillaTypes.ITEM, this.rockBlocks);
        ArrayList<List<ItemStack>> outputList = new ArrayList<List<ItemStack>>();
        outputList.add(this.oreItems);
        if (this.veinType.hasLooseRocks()) {
            outputList.add(Collections.singletonList(this.veinType.getLooseRockItem()));
        }
        recipeIngredients.setOutputLists(VanillaTypes.ITEM, outputList);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int newLine = 11;
        float x = 16.0f;
        float y = 19.0f;
        String text = I18n.func_135052_a((String)"jei.tooltips.tfc.vein.min_y", (Object[])new Object[0]);
        minecraft.field_71466_p.func_175065_a(text, x -= (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f, y, 49920, false);
        x = 16.0f;
        text = String.valueOf(this.veinType.getMinY());
        minecraft.field_71466_p.func_175065_a(text, x -= (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f, y += 11.0f, 0xFFFFFF, false);
        x = 49.0f;
        y = 19.0f;
        text = I18n.func_135052_a((String)"jei.tooltips.tfc.vein.max_y", (Object[])new Object[0]);
        minecraft.field_71466_p.func_175065_a(text, x -= (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f, y, 49920, false);
        x = 49.0f;
        text = String.valueOf(this.veinType.getMaxY());
        minecraft.field_71466_p.func_175065_a(text, x -= (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f, y += 11.0f, 0xFFFFFF, false);
        x = 33.0f;
        text = I18n.func_135052_a((String)"jei.tooltips.tfc.vein.rarity", (Object[])new Object[0]);
        minecraft.field_71466_p.func_175065_a(text, x -= (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f, y += 11.0f, 49920, false);
        x = 33.0f;
        String rarityValue = String.format("%.1f", Float.valueOf(100.0f / (float)this.veinType.getRarity()));
        text = I18n.func_135052_a((String)"jei.tooltips.tfc.vein.rarity_value", (Object[])new Object[]{rarityValue});
        minecraft.field_71466_p.func_175065_a(text, x -= (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f, y += 11.0f, 0xFFFFFF, false);
        text = I18n.func_135052_a((String)"jei.tooltips.tfc.vein.loose_rock", (Object[])new Object[0]);
        List listString = minecraft.field_71466_p.func_78271_c(text, 52);
        y = 33.0f - (float)(11 * listString.size());
        for (String str : listString) {
            x = 127.0f;
            minecraft.field_71466_p.func_175065_a(str, x -= (float)minecraft.field_71466_p.func_78256_a(str) / 2.0f, y += 11.0f, 0xFFFFFF, false);
        }
        x = 81.0f;
        y = 3.0f;
        text = I18n.func_135052_a((String)("vein." + this.veinType.getRegistryName() + ".name"), (Object[])new Object[0]);
        minecraft.field_71466_p.func_175065_a(text, x -= (float)minecraft.field_71466_p.func_78256_a(text) / 2.0f, y, 0xFFFFFF, false);
    }
}

