/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.waila.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.capability.heat.Heat;
import net.dries007.tfc.compat.waila.interfaces.IWailaBlock;
import net.dries007.tfc.objects.blocks.devices.BlockBlastFurnace;
import net.dries007.tfc.objects.te.TEBlastFurnace;
import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlastFurnaceProvider
implements IWailaBlock {
    @Override
    @Nonnull
    public List<String> getTooltip(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull NBTTagCompound nbt) {
        ArrayList<String> currentTooltip = new ArrayList<String>();
        TEBlastFurnace blastFurnace = Helpers.getTE((IBlockAccess)world, pos, TEBlastFurnace.class);
        if (blastFurnace != null) {
            int chinmey = BlockBlastFurnace.getChimneyLevels(blastFurnace.func_145831_w(), blastFurnace.func_174877_v());
            if (chinmey > 0) {
                int maxItems = chinmey * 4;
                int oreStacks = blastFurnace.getOreStacks().size();
                int fuelStacks = blastFurnace.getFuelStacks().size();
                float temperature = nbt.func_74760_g("temperature");
                String heatTooltip = Heat.getTooltip(temperature);
                currentTooltip.add(new TextComponentTranslation("waila.tfc.bloomery.ores", new Object[]{oreStacks, maxItems}).func_150254_d());
                currentTooltip.add(new TextComponentTranslation("waila.tfc.bloomery.fuel", new Object[]{fuelStacks, maxItems}).func_150254_d());
                if (heatTooltip != null) {
                    currentTooltip.add(heatTooltip);
                }
            } else {
                currentTooltip.add(new TextComponentTranslation("waila.tfc.blast_furnace.not_formed", new Object[0]).func_150254_d());
            }
        }
        return currentTooltip;
    }

    @Override
    @Nonnull
    public List<Class<?>> getLookupClass() {
        return Collections.singletonList(TEBlastFurnace.class);
    }
}

